/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.widgets;

import java.util.Arrays;
import java.util.Iterator;
import javax.swing.ListModel;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.listeners.SWTListChangeListenerWrapper;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.model.value.swing.ListModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AddRemovePane<T extends Model>
extends Pane<T> {
    private Adapter adapter;
    private Button addButton;
    private Composite container;
    private boolean enabled;
    private IBaseLabelProvider labelProvider;
    private ListValueModel<?> listHolder;
    private Button optionalButton;
    private Button removeButton;
    private WritablePropertyValueModel<Object> selectedItemHolder;
    private ObjectListSelectionModel selectionModel;

    protected AddRemovePane(Pane<? extends T> parentPane, Composite parent, Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, IBaseLabelProvider labelProvider) {
        this(parentPane, parent, adapter, listHolder, selectedItemHolder, labelProvider, null);
    }

    protected AddRemovePane(Pane<? extends T> parentPane, Composite parent, Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, IBaseLabelProvider labelProvider, String helpId) {
        this(parentPane, parent, adapter, listHolder, selectedItemHolder, labelProvider, helpId, true);
    }

    protected AddRemovePane(Pane<? extends T> parentPane, Composite parent, Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, IBaseLabelProvider labelProvider, String helpId, boolean parentManagePane) {
        super(parentPane, parent, true, parentManagePane);
        this.initialize(adapter, listHolder, selectedItemHolder, labelProvider);
        this.initializeLayout(adapter, listHolder, selectedItemHolder, labelProvider, helpId);
    }

    protected AddRemovePane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, IBaseLabelProvider labelProvider) {
        this(parentPane, subjectHolder, parent, adapter, listHolder, selectedItemHolder, labelProvider, null);
    }

    protected AddRemovePane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, IBaseLabelProvider labelProvider, String helpId) {
        super(parentPane, subjectHolder, parent);
        this.initialize(adapter, listHolder, selectedItemHolder, labelProvider);
        this.initializeLayout(adapter, listHolder, selectedItemHolder, labelProvider, helpId);
    }

    protected void addCustomButtonAfterAddButton(Composite container, String helpId) {
    }

    protected void addCustomButtonAfterOptionalButton(Composite container, String helpId) {
    }

    protected void addItem() {
        this.adapter.addNewItem(this.selectionModel);
    }

    protected Adapter buildAdapter() {
        return this.adapter;
    }

    protected Button addAddButton(Composite parent) {
        return this.addUnmanagedButton(parent, this.adapter.addButtonText(), this.buildAddItemAction());
    }

    private Runnable buildAddItemAction() {
        return new Runnable(){

            public void run() {
                AddRemovePane.this.addItem();
            }
        };
    }

    private ListChangeListener buildListChangeListener() {
        return new SWTListChangeListenerWrapper(this.buildListChangeListener_());
    }

    private ListChangeListener buildListChangeListener_() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                AddRemovePane.this.itemsAdded(e);
            }

            public void itemsMoved(ListChangeEvent e) {
                AddRemovePane.this.itemsMoved(e);
            }

            public void itemsRemoved(ListChangeEvent e) {
                AddRemovePane.this.itemsRemoved(e);
            }

            public void itemsReplaced(ListChangeEvent e) {
                AddRemovePane.this.itemsReplaced(e);
            }

            public void listChanged(ListChangeEvent e) {
                AddRemovePane.this.listChanged(e);
            }

            public void listCleared(ListChangeEvent e) {
                AddRemovePane.this.listCleared(e);
            }
        };
    }

    protected void itemsAdded(ListChangeEvent e) {
    }

    protected void itemsMoved(ListChangeEvent e) {
    }

    protected void itemsRemoved(ListChangeEvent e) {
        Object selectedItem = this.selectedItemHolder.getValue();
        if (selectedItem == null) {
            this.updateButtons();
            return;
        }
        if (CollectionTools.contains((Iterator)e.items(), (Object)selectedItem)) {
            this.selectedItemHolder.setValue(null);
            this.updateButtons();
        }
    }

    protected void itemsReplaced(ListChangeEvent e) {
    }

    protected void listChanged(ListChangeEvent e) {
    }

    protected void listCleared(ListChangeEvent e) {
        this.selectedItemHolder.setValue(null);
        this.updateButtons();
    }

    private Runnable buildOptionalAction() {
        return new Runnable(){

            public void run() {
                AddRemovePane.this.editItem();
            }
        };
    }

    protected Button addOptionalButton(Composite container) {
        return this.addUnmanagedButton(container, this.adapter.optionalButtonText(), this.buildOptionalAction());
    }

    protected Button addRemoveButton(Composite parent) {
        return this.addUnmanagedButton(parent, this.adapter.removeButtonText(), this.buildRemoveItemsAction());
    }

    private Runnable buildRemoveItemsAction() {
        return new Runnable(){

            public void run() {
                AddRemovePane.this.removeItems();
            }
        };
    }

    protected ObjectListSelectionModel buildRowSelectionModel(ListValueModel<?> listModel) {
        return new ObjectListSelectionModel((ListModel)new ListModelAdapter(listModel));
    }

    protected void editItem() {
        this.adapter.optionOnSelection(this.getSelectionModel());
    }

    @Override
    public void enableWidgets(boolean enabled) {
        super.enableWidgets(enabled);
        this.enabled = enabled;
        if (!this.getMainControl().isDisposed()) {
            this.getMainControl().setEnabled(enabled);
        }
        this.updateButtons();
    }

    protected final Composite getContainer() {
        return this.container;
    }

    protected IBaseLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    protected final ListValueModel<?> getListHolder() {
        return this.listHolder;
    }

    public abstract Composite getMainControl();

    protected final WritablePropertyValueModel<Object> getSelectedItemHolder() {
        return this.selectedItemHolder;
    }

    public final ObjectListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    protected void initialize(Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, IBaseLabelProvider labelProvider) {
        this.listHolder = listHolder;
        this.labelProvider = labelProvider;
        this.adapter = adapter == null ? this.buildAdapter() : adapter;
        this.selectedItemHolder = selectedItemHolder;
        this.selectionModel = new ObjectListSelectionModel((ListModel)new ListModelAdapter(listHolder));
        this.listHolder.addListChangeListener("list values", this.buildListChangeListener());
    }

    protected void initializeButtonPane(Composite container, String helpId) {
        container = this.addSubPane(container);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 128;
        container.setLayoutData((Object)gridData);
        this.addButton = this.addAddButton(container);
        this.addAlignRight((Control)this.addButton);
        this.addCustomButtonAfterAddButton(container, helpId);
        if (this.adapter.hasOptionalButton()) {
            this.optionalButton = this.addOptionalButton(container);
            this.addAlignRight((Control)this.optionalButton);
        }
        this.addCustomButtonAfterOptionalButton(container, helpId);
        this.removeButton = this.addRemoveButton(container);
        this.addAlignRight((Control)this.removeButton);
        if (helpId != null) {
            this.getHelpSystem().setHelp((Control)this.addButton, helpId);
            this.getHelpSystem().setHelp((Control)this.removeButton, helpId);
            if (this.optionalButton != null) {
                this.getHelpSystem().setHelp((Control)this.optionalButton, helpId);
            }
        }
    }

    protected void initializeLayout(Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, IBaseLabelProvider labelProvider, String helpId) {
        this.initializeMainComposite(this.container, adapter, listHolder, selectedItemHolder, labelProvider, helpId);
        this.initializeButtonPane(this.container, helpId);
        this.enableWidgets(this.getSubject() != null);
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.container = this.addSubPane(container, 2, 0, 0, 0, 0);
    }

    protected abstract void initializeMainComposite(Composite var1, Adapter var2, ListValueModel<?> var3, WritablePropertyValueModel<?> var4, IBaseLabelProvider var5, String var6);

    protected void removeItems() {
        int[] indices = this.selectionModel.selectedIndices();
        Arrays.sort(indices);
        this.adapter.removeSelectedItems(this.selectionModel);
        if (this.getListHolder().size() > 0) {
            int index = Math.min(indices[0], this.getListHolder().size() - 1);
            Object item = this.getListHolder().get(index);
            this.selectedItemHolder.setValue(item);
        } else {
            this.selectedItemHolder.setValue(null);
        }
    }

    public void setSelectedItem(Object value) {
        this.selectedItemHolder.setValue(value);
    }

    protected void updateAddButton(Button addButton) {
        addButton.setEnabled(this.enabled);
    }

    protected void updateButtons() {
        if (!this.container.isDisposed()) {
            this.updateAddButton(this.addButton);
            this.updateRemoveButton(this.removeButton);
            this.updateOptionalButton(this.optionalButton);
        }
    }

    protected void updateOptionalButton(Button optionalButton) {
        if (optionalButton != null) {
            optionalButton.setEnabled(this.enabled && this.adapter.enableOptionOnSelectionChange(this.selectionModel));
        }
    }

    protected void updateRemoveButton(Button removeButton) {
        removeButton.setEnabled(this.enabled && this.adapter.enableRemoveOnSelectionChange(this.selectionModel));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractAdapter
    implements Adapter {
        private String addButtonText;
        private boolean hasOptionalButton;
        private String optionalButtonText;
        private String removeButtonText;

        public AbstractAdapter() {
            this(JptUiMessages.AddRemovePane_AddButtonText, JptUiMessages.AddRemovePane_RemoveButtonText);
        }

        public AbstractAdapter(boolean hasOptionalButton) {
            this();
            this.setHasOptionalButton(hasOptionalButton);
        }

        public AbstractAdapter(String optionalButtonText) {
            this(true);
            this.setOptionalButtonText(optionalButtonText);
        }

        public AbstractAdapter(String addButtonText, String removeButtonText) {
            this.addButtonText = addButtonText;
            this.removeButtonText = removeButtonText;
        }

        public AbstractAdapter(String addButtonText, String removeButtonText, String optionalButtonText) {
            this(optionalButtonText);
            this.setAddButtonText(addButtonText);
            this.setRemoveButtonText(removeButtonText);
        }

        @Override
        public String addButtonText() {
            return this.addButtonText;
        }

        @Override
        public boolean enableOptionOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
            return listSelectionModel.selectedValuesSize() == 1;
        }

        @Override
        public boolean enableRemoveOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
            return listSelectionModel.selectedValue() != null;
        }

        @Override
        public boolean hasOptionalButton() {
            return this.hasOptionalButton;
        }

        @Override
        public String optionalButtonText() {
            return this.optionalButtonText;
        }

        @Override
        public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
        }

        @Override
        public String removeButtonText() {
            return this.removeButtonText;
        }

        public void setAddButtonText(String addButtonText) {
            this.addButtonText = addButtonText;
        }

        public void setHasOptionalButton(boolean hasOptionalButton) {
            this.hasOptionalButton = hasOptionalButton;
        }

        public void setOptionalButtonText(String optionalButtonText) {
            this.optionalButtonText = optionalButtonText;
        }

        public void setRemoveButtonText(String removeButtonText) {
            this.removeButtonText = removeButtonText;
        }
    }

    public static interface Adapter {
        public String addButtonText();

        public void addNewItem(ObjectListSelectionModel var1);

        public boolean enableOptionOnSelectionChange(ObjectListSelectionModel var1);

        public boolean enableRemoveOnSelectionChange(ObjectListSelectionModel var1);

        public boolean hasOptionalButton();

        public String optionalButtonText();

        public void optionOnSelection(ObjectListSelectionModel var1);

        public String removeButtonText();

        public void removeSelectedItems(ObjectListSelectionModel var1);
    }
}

