/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.actions.ContextHelpAction;
import org.eclipse.mylyn.internal.wikitext.ui.editor.commands.Messages;
import org.eclipse.mylyn.internal.wikitext.ui.editor.help.HelpContent;
import org.eclipse.mylyn.internal.wikitext.ui.util.InformationPresenterUtil;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.ui.WikiText;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowCheatSheetCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object activeFocusControl = HandlerUtil.getVariable((ExecutionEvent)event, (String)"activeFocusControl");
        if (activeFocusControl instanceof Control) {
            Control control = (Control)activeFocusControl;
            MarkupLanguage markupLanguage = (MarkupLanguage)control.getData(MarkupLanguage.class.getName());
            ISourceViewer viewer = (ISourceViewer)control.getData(ISourceViewer.class.getName());
            if (markupLanguage != null && viewer != null) {
                ToolBarManager toolBarManager = new ToolBarManager();
                toolBarManager.add((IAction)new ContextHelpAction());
                InformationPresenter informationPresenter = InformationPresenterUtil.getHtmlInformationPresenter(viewer, new InformationPresenterUtil.SizeConstraint(50, 200, true, true), toolBarManager, this.computeCheatSheet(markupLanguage));
                Display.getCurrent().asyncExec(() -> informationPresenter.showInformation());
            }
        }
        return null;
    }

    private String computeCheatSheet(MarkupLanguage markupLanguage) {
        HelpContent content = null;
        if (markupLanguage != null && (content = (HelpContent)WikiTextUiPlugin.getDefault().getCheatSheets().get(markupLanguage.getName())) == null) {
            MarkupLanguage l = markupLanguage;
            while (content == null && l != null && l.getExtendsLanguage() != null) {
                if ((l = WikiText.getMarkupLanguage(l.getExtendsLanguage())) == null) continue;
                content = (HelpContent)WikiTextUiPlugin.getDefault().getCheatSheets().get(l.getName());
            }
        }
        if (content != null) {
            try {
                return content.getContent();
            }
            catch (Exception e) {
                WikiTextUiPlugin.getDefault().log(e);
            }
        }
        return NLS.bind((String)Messages.ShowCheatSheetCommand_noCheatSheetContent, (Object[])new Object[]{markupLanguage == null ? Messages.ShowCheatSheetCommand_unknownLanguage : markupLanguage.getName()});
    }
}

