/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.opt;

import org.sat4j.core.ConstrGroup;
import org.sat4j.core.VecInt;
import org.sat4j.opt.AbstractSelectorVariablesDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public final class MaxSatDecorator
extends AbstractSelectorVariablesDecorator {
    private static final long serialVersionUID = 1L;
    private final boolean equivalence;
    private final IVecInt lits = new VecInt();
    private int counter;
    private IConstr prevConstr;

    public MaxSatDecorator(ISolver solver) {
        this(solver, false);
    }

    public MaxSatDecorator(ISolver solver, boolean equivalence) {
        super(solver);
        this.equivalence = equivalence;
    }

    public void setExpectedNumberOfClauses(int nb) {
        super.setExpectedNumberOfClauses(nb);
        this.lits.ensure(nb);
    }

    public IConstr addClause(IVecInt literals) throws ContradictionException {
        int newvar = this.nextFreeVarId(true);
        this.lits.push(newvar);
        literals.push(newvar);
        if (this.equivalence) {
            ConstrGroup constrs = new ConstrGroup();
            constrs.add(super.addClause(literals));
            VecInt clause = new VecInt(2);
            clause.push(-newvar);
            int i = 0;
            while (i < literals.size() - 1) {
                clause.push(-literals.get(i));
                constrs.add(super.addClause(clause));
                ++i;
            }
            clause.pop();
            return constrs;
        }
        return super.addClause(literals);
    }

    public void reset() {
        this.lits.clear();
        super.reset();
        this.prevConstr = null;
    }

    public boolean hasNoObjectiveFunction() {
        return false;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return false;
    }

    public Number calculateObjective() {
        this.calculateObjectiveValue();
        return this.counter;
    }

    public void discardCurrentSolution() throws ContradictionException {
        if (this.prevConstr != null) {
            super.removeSubsumedConstr(this.prevConstr);
        }
        try {
            this.prevConstr = super.addAtMost(this.lits, this.counter - 1);
        }
        catch (ContradictionException ce) {
            this.setSolutionOptimal(true);
            throw ce;
        }
    }

    public boolean admitABetterSolution(IVecInt assumps) throws TimeoutException {
        boolean result = super.admitABetterSolution(assumps);
        if (!result && this.prevConstr != null) {
            super.removeConstr(this.prevConstr);
            this.prevConstr = null;
        }
        return result;
    }

    public void discard() throws ContradictionException {
        this.discardCurrentSolution();
    }

    public Number getObjectiveValue() {
        return this.counter;
    }

    void calculateObjectiveValue() {
        this.counter = 0;
        int[] nArray = this.getPrevfullmodel();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int q = nArray[n2];
            if (q > this.nVars()) {
                ++this.counter;
            }
            ++n2;
        }
    }

    public void forceObjectiveValueTo(Number forcedValue) throws ContradictionException {
        super.addAtMost(this.lits, forcedValue.intValue());
    }

    public void setTimeoutForFindingBetterSolution(int seconds) {
        throw new UnsupportedOperationException("No implemented yet");
    }
}

