/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.utils;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.Nullable;

public interface DeepCloneable {
    public static <T> T deepClone(T obj) {
        if (obj instanceof DeepCloneable) {
            return (T)((DeepCloneable)obj).deepClone();
        }
        if (obj instanceof List) {
            ArrayList clone;
            if (obj instanceof ArrayList) {
                ArrayList source = (ArrayList)obj;
                clone = (ArrayList)source.clone();
            } else if (obj instanceof LinkedList) {
                LinkedList source = (LinkedList)obj;
                clone = (LinkedList)source.clone();
            } else {
                List source = (List)obj;
                clone = new ArrayList(source);
            }
            clone.replaceAll(DeepCloneable::deepCloneNullable);
            return (T)clone;
        }
        if (obj instanceof Set) {
            Set clone;
            Set source;
            AbstractSet cloneable;
            if (obj instanceof TreeSet) {
                cloneable = (TreeSet)obj;
                source = cloneable;
                clone = (HashSet)((TreeSet)cloneable).clone();
            } else if (obj instanceof HashSet) {
                cloneable = (HashSet)obj;
                source = cloneable;
                clone = (Set)((HashSet)cloneable).clone();
            } else {
                source = (Set)obj;
                clone = new HashSet();
            }
            clone.clear();
            for (Object e : source) {
                clone.add(DeepCloneable.deepCloneNullable(e));
            }
            return (T)clone;
        }
        if (obj instanceof Map) {
            if (obj instanceof HashMap) {
                HashMap source = (HashMap)obj;
                Map clone = (Map)source.clone();
                clone.replaceAll((k, v) -> DeepCloneable.deepCloneNullable(v));
                return (T)clone;
            }
            if (obj instanceof IdentityHashMap) {
                IdentityHashMap source = (IdentityHashMap)obj;
                Map clone = (Map)source.clone();
                clone.replaceAll((k, v) -> DeepCloneable.deepCloneNullable(v));
                return (T)clone;
            }
            if (obj instanceof TreeMap) {
                TreeMap source = (TreeMap)obj;
                Map clone = (Map)source.clone();
                clone.replaceAll((k, v) -> DeepCloneable.deepCloneNullable(v));
                return (T)clone;
            }
        }
        return obj;
    }

    public static <T> @Nullable T deepCloneNullable(@Nullable T obj) {
        if (obj == null) {
            return null;
        }
        return DeepCloneable.deepClone(obj);
    }

    public Object deepClone();
}

