/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository.simple;

import java.util.Collections;
import java.util.Map;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;

public class SimpleArtifactDescriptor
extends ArtifactDescriptor {
    public static final String ARTIFACT_REFERENCE = "artifact.reference";
    protected Map<String, String> repositoryProperties;

    public SimpleArtifactDescriptor(IArtifactKey key) {
        super(key);
    }

    public SimpleArtifactDescriptor(IArtifactDescriptor base) {
        super(base);
    }

    public String getRepositoryProperty(String propertyKey) {
        return this.repositoryProperties != null ? this.repositoryProperties.get(propertyKey) : null;
    }

    public void setRepositoryProperty(String key, String value) {
        if (value == null) {
            if (this.repositoryProperties != null) {
                this.repositoryProperties.remove(key);
                if (this.repositoryProperties.isEmpty()) {
                    this.repositoryProperties = null;
                }
            }
        } else if (this.repositoryProperties == null) {
            this.repositoryProperties = Collections.singletonMap(key.intern(), value);
        } else {
            if (this.repositoryProperties.size() == 1) {
                this.repositoryProperties = new OrderedProperties(this.repositoryProperties);
            }
            this.repositoryProperties.put(key, value);
        }
    }

    public void addRepositoryProperties(Map<String, String> additionalProperties) {
        if (additionalProperties.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : additionalProperties.entrySet()) {
            this.setRepositoryProperty(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, String> getRepositoryProperties() {
        if (this.repositoryProperties == null) {
            return Collections.emptyMap();
        }
        return OrderedProperties.unmodifiableProperties(this.repositoryProperties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SimpleArtifactDescriptor)) {
            return false;
        }
        SimpleArtifactDescriptor other = (SimpleArtifactDescriptor)((Object)obj);
        String locationProperty = this.getRepositoryProperty(ARTIFACT_REFERENCE);
        String otherProperty = other.getRepositoryProperty(ARTIFACT_REFERENCE);
        if (locationProperty != null ? !locationProperty.equals(otherProperty) : otherProperty != null) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int superHash = super.hashCode();
        String ref = this.getRepositoryProperty(ARTIFACT_REFERENCE);
        if (ref != null) {
            return 31 * superHash + ref.hashCode();
        }
        return superHash;
    }
}

