/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.quickaccess;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.ui.quickaccess.QuickAccessElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class LaunchQuickAccessElement
extends QuickAccessElement {
    private static final String MODE_RUN = "run";
    private static final String MODE_DEBUG = "debug";
    private static final String MODE_PROFILE = "profile";
    private static final ImageRegistry REGISTRY = DebugPluginImages.getImageRegistry();
    private ILaunchConfiguration launch;
    private ILaunchMode launchMode;

    static {
        LaunchQuickAccessElement.registerImage(MODE_RUN);
        LaunchQuickAccessElement.registerImage(MODE_DEBUG);
        LaunchQuickAccessElement.registerImage(MODE_PROFILE);
    }

    public LaunchQuickAccessElement(ILaunchConfiguration launch, ILaunchMode launchMode) {
        this.launch = launch;
        this.launchMode = launchMode;
    }

    private static void registerImage(String key) {
        Bundle bundle = FrameworkUtil.getBundle(DebugPluginImages.class);
        String path = "$nl$/icons/full/ovr16/quickaccess_" + key + ".png";
        if (bundle == null) {
            REGISTRY.put(key, ImageDescriptor.getMissingImageDescriptor());
        } else {
            REGISTRY.put(key, ImageDescriptor.createFromURLSupplier((boolean)true, () -> FileLocator.find((Bundle)bundle, (IPath)IPath.fromOSString((String)path), null)));
        }
    }

    public String getLabel() {
        return this.launch.getName();
    }

    public String getMatchLabel() {
        return this.getLabel() + " " + this.launchMode.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        try {
            ImageDescriptor baseImage = DebugPluginImages.getImageDescriptor(this.launch.getType().getIdentifier());
            ImageDescriptor overlay = REGISTRY.getDescriptor(this.launchMode.getIdentifier());
            if (overlay != null) {
                return new DecorationOverlayIcon(baseImage, overlay, 3);
            }
            return baseImage;
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
            return null;
        }
    }

    public String getId() {
        return this.launch.getName() + "/" + this.launchMode.getIdentifier();
    }

    public void execute() {
        DebugUITools.launch(this.launch, this.launchMode.getIdentifier());
    }
}

