/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;

public abstract class BaseDirectory
extends Directory {
    protected volatile boolean isOpen = true;
    protected final LockFactory lockFactory;

    protected BaseDirectory(LockFactory lockFactory) {
        if (lockFactory == null) {
            throw new NullPointerException("LockFactory must not be null, use an explicit instance!");
        }
        this.lockFactory = lockFactory;
    }

    @Override
    public final Lock obtainLock(String name) throws IOException {
        return this.lockFactory.obtainLock(this, name);
    }

    @Override
    protected final void ensureOpen() throws AlreadyClosedException {
        if (!this.isOpen) {
            throw new AlreadyClosedException("this Directory is closed");
        }
    }

    @Override
    public String toString() {
        return super.toString() + " lockFactory=" + this.lockFactory;
    }
}

