/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import java.io.IOException;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;

public class EclipseSystemReader
extends SystemReader {
    private static final String[] HIDDEN_VARIABLES = new String[]{"GIT_DIR", "GIT_WORK_TREE", "GIT_OBJECT_DIRECTORY", "GIT_INDEX_FILE", "GIT_ALTERNATE_OBJECT_DIRECTORIES"};
    @NonNull
    private final SystemReader delegate;

    public EclipseSystemReader(@NonNull SystemReader delegate) {
        this.delegate = delegate;
    }

    public String getenv(String variable) {
        String result = this.delegate.getenv(variable);
        if (result == null) {
            return result;
        }
        boolean isWin = this.isWindows();
        String[] stringArray = HIDDEN_VARIABLES;
        int n = HIDDEN_VARIABLES.length;
        int n2 = 0;
        while (n2 < n) {
            String gitvar = stringArray[n2];
            if (isWin && gitvar.equalsIgnoreCase(variable) || !isWin && gitvar.equals(variable)) {
                return null;
            }
            ++n2;
        }
        return result;
    }

    public String getHostname() {
        return this.delegate.getHostname();
    }

    public String getProperty(String key) {
        return this.delegate.getProperty(key);
    }

    public FileBasedConfig openUserConfig(Config parent, FS fs) {
        return this.delegate.openUserConfig(parent, fs);
    }

    public FileBasedConfig openJGitConfig(Config parent, FS fs) {
        return this.delegate.openJGitConfig(parent, fs);
    }

    public FileBasedConfig openSystemConfig(Config parent, FS fs) {
        return this.delegate.openSystemConfig(parent, fs);
    }

    public long getCurrentTime() {
        return this.delegate.getCurrentTime();
    }

    public int getTimezone(long when) {
        return this.delegate.getTimezone(when);
    }

    public StoredConfig getUserConfig() throws IOException, ConfigInvalidException {
        return this.delegate.getUserConfig();
    }

    public StoredConfig getJGitConfig() throws IOException, ConfigInvalidException {
        return this.delegate.getJGitConfig();
    }

    public StoredConfig getSystemConfig() throws IOException, ConfigInvalidException {
        return this.delegate.getSystemConfig();
    }
}

