/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class FileLocationDetails {
    private static final Pattern lPattern = Pattern.compile("^(?<path>.*?)[+:](?<line>\\d+)$");
    private static final Pattern lcPattern = Pattern.compile("^(?<path>.*?)[+:](?<line>\\d+)[:+](?<column>\\d+)$");
    IPath path;
    IFileStore fileStore;
    IFileInfo fileInfo;
    int line = -1;
    int column = -1;

    private static String getPath(Matcher m) {
        return m.group("path");
    }

    private static int getValue(String name, Matcher m) {
        return Integer.parseInt(m.group(name));
    }

    public static FileLocationDetails resolve(String path) {
        FileLocationDetails details;
        if (FileLocationDetails.isValidPath(path) && (details = FileLocationDetails.checkLocation(path, -1, -1)) != null) {
            return details;
        }
        Matcher m = lPattern.matcher(path);
        if (m.matches()) {
            try {
                FileLocationDetails details2;
                String matchedPath = FileLocationDetails.getPath(m);
                if (FileLocationDetails.isValidPath(matchedPath) && (details2 = FileLocationDetails.checkLocation(matchedPath, FileLocationDetails.getValue("line", m), -1)) != null) {
                    return details2;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((m = lcPattern.matcher(path)).matches()) {
            try {
                FileLocationDetails details3 = FileLocationDetails.checkLocation(FileLocationDetails.getPath(m), FileLocationDetails.getValue("line", m), FileLocationDetails.getValue("column", m));
                if (details3 != null) {
                    return details3;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    private static boolean isValidPath(String path) {
        if (Platform.getOS().equals("win32")) {
            try {
                Path.of(path, new String[0]);
            }
            catch (InvalidPathException invalidPathException) {
                return false;
            }
        }
        return true;
    }

    private static FileLocationDetails checkLocation(String path, int line, int column) {
        FileLocationDetails spec = new FileLocationDetails();
        spec.path = IPath.fromOSString((String)path);
        spec.fileStore = EFS.getLocalFileSystem().getStore(spec.path);
        spec.fileInfo = spec.fileStore.fetchInfo();
        spec.line = line;
        spec.column = column;
        return spec.fileInfo.exists() ? spec : null;
    }
}

