/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.local.files;

import java.io.File;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.local.LocalFileNativesManager;
import org.eclipse.rse.internal.services.local.files.LocalFileService;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.services.files.IHostFilePermissionsContainer;

public class LocalHostFile
implements IHostFile,
IHostFilePermissionsContainer {
    private File _file;
    private long _lastQueryTime = 0L;
    private Boolean _isFile = null;
    private Boolean _isDirectory = null;
    private Boolean _exists = null;
    private Boolean _isHidden = null;
    private boolean _isRoot = false;
    private boolean _isArchive = false;
    private IHostFilePermissions _permissions = null;
    private FileInfo _info = null;
    private boolean _needsQuery = false;

    public LocalHostFile(File file) {
        this._file = file;
        this._isArchive = ArchiveHandlerManager.getInstance().isArchive(this._file);
        this.fetchInfo();
    }

    public LocalHostFile(File file, boolean isRoot, FileInfo info) {
        this._file = file;
        this._info = info;
        this._isRoot = isRoot;
        if (!isRoot) {
            this._isArchive = ArchiveHandlerManager.getInstance().isArchive(this._file);
        }
    }

    private void fetchInfo() {
        if (LocalFileService.isUsingNatives()) {
            this._info = LocalFileNativesManager.fetchFileInfo((String)this._file.getAbsolutePath());
            if (this._info.getName().length() == 0) {
                String name = this._file.getName();
                this._info.setName(new String(name.toCharArray()));
            }
        }
        this._needsQuery = false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalHostFile) {
            LocalHostFile other = (LocalHostFile)obj;
            return this._file.equals(other._file) && this._isRoot == other._isRoot && this._isArchive == other._isArchive;
        }
        return false;
    }

    public String getName() {
        if (this._isRoot) {
            return this._file.getPath();
        }
        return this._file.getName();
    }

    public boolean isHidden() {
        if (this._isHidden == null || this.needsQuery()) {
            String name = this.getName();
            this._isHidden = name != null && name.charAt(0) == '.' ? Boolean.TRUE : (this._info != null ? new Boolean(this._info.getAttribute(16)) : new Boolean(!this._isRoot && this._file.isHidden()));
        }
        return this._isHidden;
    }

    public String getParentPath() {
        return this._file.getParent();
    }

    public boolean isDirectory() {
        if (this._isDirectory == null) {
            this._isDirectory = this._info != null ? new Boolean(this._info.isDirectory()) : new Boolean(this._file.isDirectory());
        }
        return this._isDirectory;
    }

    public boolean isRoot() {
        return this._isRoot;
    }

    public boolean isFile() {
        if (this._isFile == null) {
            this._isFile = this._info != null ? new Boolean(!this._info.isDirectory()) : new Boolean(this._file.isFile());
        }
        return this._isFile;
    }

    public File getFile() {
        return this._file;
    }

    public boolean exists() {
        boolean needsQuery = this.needsQuery();
        if (this._exists == null || needsQuery) {
            if (this._info != null) {
                if (needsQuery) {
                    this.fetchInfo();
                }
                this._exists = new Boolean(this._info.exists());
            } else {
                this._exists = new Boolean(this._file.exists());
            }
        }
        return this._exists;
    }

    public String getAbsolutePath() {
        return this._file.getAbsolutePath();
    }

    public long getSize() {
        if (this._info != null) {
            if (this.needsQuery()) {
                this.fetchInfo();
            }
            return this._info.getLength();
        }
        return this._file.length();
    }

    public long getModifiedDate() {
        if (this._info != null) {
            if (this.needsQuery()) {
                this.fetchInfo();
            }
            return this._info.getLastModified();
        }
        return this._file.lastModified();
    }

    public void renameTo(String newAbsolutePath) {
        this._file = new File(newAbsolutePath);
        this._isArchive = ArchiveHandlerManager.getInstance().isArchive(this._file);
        this.fetchInfo();
    }

    public boolean isArchive() {
        return this._isArchive;
    }

    public boolean canRead() {
        if (this._info != null) {
            if (this.needsQuery()) {
                this.fetchInfo();
            }
            return this._info.getAttribute(0x400000);
        }
        return this._file.canRead();
    }

    public boolean canWrite() {
        if (this._info != null) {
            boolean readOnly;
            if (this.needsQuery()) {
                this.fetchInfo();
            }
            if (readOnly = this._info.getAttribute(2)) {
                return false;
            }
            return this._info.getAttribute(0x800000);
        }
        return this._file.canWrite();
    }

    public IHostFilePermissions getPermissions() {
        return this._permissions;
    }

    public void setPermissions(IHostFilePermissions permissions) {
        this._permissions = permissions;
    }

    private boolean needsQuery() {
        if (LocalFileService.isUsingNatives() && this._needsQuery) {
            return true;
        }
        long t = System.currentTimeMillis();
        if (this._lastQueryTime == 0L || t - this._lastQueryTime > 5000L) {
            this._lastQueryTime = t;
            return true;
        }
        return false;
    }

    public void setNeedsQuery(boolean flag) {
        this._needsQuery = true;
    }
}

