/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.cheatsheets.composite.parser.IStatusContainer;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;

public class TaskDependencies {
    private List<Dependency> dependencies;
    private Map<String, AbstractTask> taskIdMap = new HashMap<String, AbstractTask>();

    public void saveId(AbstractTask task) {
        String id = task.getId();
        if (id != null) {
            this.taskIdMap.put(id, task);
        }
    }

    public AbstractTask getTask(String id) {
        return this.taskIdMap.get(id);
    }

    public TaskDependencies() {
        this.dependencies = new ArrayList<Dependency>();
    }

    public void addDependency(AbstractTask sourceTask, String requiredTaskId) {
        this.dependencies.add(new Dependency(sourceTask, requiredTaskId));
    }

    public void resolveDependencies(IStatusContainer status) {
        for (Dependency dep : this.dependencies) {
            AbstractTask sourceTask = dep.getSourceTask();
            AbstractTask requiredTask = this.getTask(dep.requiredTaskId);
            if (requiredTask == null) {
                String message = NLS.bind((String)Messages.ERROR_PARSING_INVALID_ID, (Object[])new Object[]{dep.getRequiredTaskId()});
                status.addStatus(4, message, null);
                continue;
            }
            if (sourceTask.requiresTask(requiredTask)) continue;
            sourceTask.addRequiredTask(requiredTask);
        }
        this.checkForCircularities(status);
    }

    private void checkForCircularities(IStatusContainer status) {
        int i;
        HashSet<AbstractTask> tasks = new HashSet<AbstractTask>();
        for (AbstractTask nextTask : this.taskIdMap.values()) {
            if (nextTask.getRequiredTasks().length <= 0) continue;
            tasks.add(nextTask);
        }
        boolean makingProgress = true;
        while (makingProgress) {
            HashSet<ICompositeCheatSheetTask> remainingTasks = new HashSet<ICompositeCheatSheetTask>();
            makingProgress = false;
            Iterator taskIterator = tasks.iterator();
            while (taskIterator.hasNext() && !makingProgress) {
                boolean mayBeInCycle = false;
                ICompositeCheatSheetTask nextTask = (ICompositeCheatSheetTask)taskIterator.next();
                ICompositeCheatSheetTask[] requiredTasks2 = nextTask.getRequiredTasks();
                i = 0;
                while (i < requiredTasks2.length) {
                    if (tasks.contains(requiredTasks2[i])) {
                        mayBeInCycle = true;
                    }
                    ++i;
                }
                if (mayBeInCycle) {
                    remainingTasks.add(nextTask);
                    continue;
                }
                makingProgress = true;
            }
            tasks = remainingTasks;
        }
        if (!tasks.isEmpty()) {
            status.addStatus(4, Messages.ERROR_PARSING_CYCLE_DETECTED, null);
            ArrayList<ICompositeCheatSheetTask> cycle = new ArrayList<ICompositeCheatSheetTask>();
            ICompositeCheatSheetTask cycleStartTask = (ICompositeCheatSheetTask)tasks.iterator().next();
            while (!cycle.contains(cycleStartTask)) {
                ICompositeCheatSheetTask[] requiredTasks;
                cycle.add(cycleStartTask);
                ICompositeCheatSheetTask[] iCompositeCheatSheetTaskArray = requiredTasks = cycleStartTask.getRequiredTasks();
                i = requiredTasks.length;
                int requiredTasks2 = 0;
                while (requiredTasks2 < i) {
                    ICompositeCheatSheetTask requiredTask = iCompositeCheatSheetTaskArray[requiredTasks2];
                    if (tasks.contains(requiredTask)) {
                        cycleStartTask = requiredTask;
                    }
                    ++requiredTasks2;
                }
            }
            boolean cycleStarted = false;
            String thisTask = null;
            String lastTask = null;
            String firstTask = null;
            for (ICompositeCheatSheetTask task : cycle) {
                if (task == cycleStartTask) {
                    cycleStarted = true;
                    firstTask = task.getName();
                }
                if (!cycleStarted) continue;
                lastTask = thisTask;
                thisTask = task.getName();
                if (lastTask == null) continue;
                String message = NLS.bind((String)Messages.ERROR_PARSING_CYCLE_CONTAINS, (Object[])new Object[]{lastTask, thisTask});
                status.addStatus(4, message, null);
            }
            String message = NLS.bind((String)Messages.ERROR_PARSING_CYCLE_CONTAINS, (Object[])new Object[]{thisTask, firstTask});
            status.addStatus(4, message, null);
        }
    }

    private static class Dependency {
        private AbstractTask sourceTask;
        private String requiredTaskId;

        public Dependency(AbstractTask sourceTask, String requiredTaskId) {
            this.sourceTask = sourceTask;
            this.requiredTaskId = requiredTaskId;
        }

        public AbstractTask getSourceTask() {
            return this.sourceTask;
        }

        public String getRequiredTaskId() {
            return this.requiredTaskId;
        }
    }
}

