/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.SystemResourceManager;

public class SystemResourceHelpers
implements FileFilter {
    private static SystemResourceHelpers defaultInstance = null;
    private boolean filesOnly = false;
    private boolean foldersOnly = false;
    private String namePrefix = null;
    private String nameSuffix = null;

    public static SystemResourceHelpers getResourceHelpers() {
        if (defaultInstance == null) {
            defaultInstance = new SystemResourceHelpers();
        }
        return defaultInstance;
    }

    public void deleteResource(IResource fileOrFolder) {
        try {
            if (fileOrFolder instanceof IFile) {
                this.deleteFile((IFile)fileOrFolder);
            } else {
                this.deleteFolder((IFolder)fileOrFolder);
            }
        }
        catch (Exception exc) {
            this.logException("Exception deleting resource " + fileOrFolder.getName(), exc);
        }
    }

    public void renameResource(IResource fileOrFolder, String newName) {
        if (fileOrFolder.getName().equals(newName)) {
            Exception exc = new Exception("Rename to same name: " + newName);
            exc.fillInStackTrace();
            exc.printStackTrace();
            return;
        }
        try {
            if (fileOrFolder instanceof IFile) {
                this.renameFile((IFile)fileOrFolder, newName);
            } else {
                this.renameFolder((IFolder)fileOrFolder, newName);
            }
        }
        catch (Exception exc) {
            this.logException("Exception rename resource " + fileOrFolder.getName() + " to " + newName, exc);
        }
    }

    public void refreshResource(IResource fileOrFolder) {
        SystemResourceManager.turnOffResourceEventListening();
        try {
            if (!fileOrFolder.getWorkspace().isTreeLocked()) {
                fileOrFolder.refreshLocal(2, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SystemResourceManager.turnOnResourceEventListening();
    }

    public void refreshResourceShallow(IResource fileOrFolder) {
        SystemResourceManager.turnOffResourceEventListening();
        try {
            if (!fileOrFolder.getWorkspace().isTreeLocked()) {
                fileOrFolder.refreshLocal(0, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SystemResourceManager.turnOnResourceEventListening();
    }

    public static boolean testIfResourceInUse(IResource resource) {
        IPath localOSLocation;
        boolean inUse;
        boolean bl = inUse = resource.getResourceAttributes().isReadOnly() || !resource.isAccessible();
        if (!inUse && (localOSLocation = resource.getLocation()) != null) {
            File osFile = new File(localOSLocation.toOSString());
            boolean bl2 = inUse = !osFile.canWrite();
            if (!inUse && resource instanceof IFile) {
                try {
                    FileWriter outFileStream = new FileWriter(osFile.getAbsolutePath(), true);
                    outFileStream.close();
                }
                catch (IOException exc) {
                    inUse = true;
                }
            }
        }
        return inUse;
    }

    public IFolder getOrCreateFolder(IContainer parentFolder, String folderName) {
        IFolder folder = this.getFolder(parentFolder, folderName);
        if (!this.exists((IResource)folder)) {
            this.createFolder(folder);
        }
        return folder;
    }

    public boolean ensureFolderExists(IFolder folder) {
        boolean ok = true;
        if (!this.exists((IResource)folder)) {
            ok = this.createFolder(folder);
        }
        return ok;
    }

    public IFolder getFolder(IContainer parent, String folderName) {
        SystemResourceManager.turnOffResourceEventListening();
        IFolder folder = null;
        folder = parent instanceof IProject ? ((IProject)parent).getFolder(folderName) : ((IFolder)parent).getFolder(folderName);
        SystemResourceManager.turnOnResourceEventListening();
        return folder;
    }

    public IFolder getRenamedFolder(IFolder oldFolder, String newFolderName) {
        SystemResourceManager.turnOffResourceEventListening();
        IFolder folder = null;
        IContainer parent = oldFolder.getParent();
        folder = parent instanceof IProject ? ((IProject)parent).getFolder(newFolderName) : ((IFolder)parent).getFolder(newFolderName);
        SystemResourceManager.turnOnResourceEventListening();
        return folder;
    }

    public boolean createFolder(IFolder folder) {
        boolean ok;
        block2: {
            ok = true;
            try {
                SystemResourceManager.turnOffResourceEventListening();
                folder.create(true, true, null);
                SystemResourceManager.turnOnResourceEventListening();
            }
            catch (CoreException e) {
                int code;
                SystemResourceManager.turnOnResourceEventListening();
                IStatus status = e.getStatus();
                if (status == null || (code = status.getCode()) == 367) break block2;
                this.logException("error creating folder " + folder.getName(), (Exception)((Object)e));
                ok = false;
            }
        }
        return ok;
    }

    public boolean deleteFolder(IFolder folder) throws Exception {
        this.refreshResource((IResource)folder);
        boolean existsInFileSystem = this.exists((IResource)folder);
        if (!existsInFileSystem) {
            return true;
        }
        boolean existsInWorkSpace = folder.exists();
        if (existsInFileSystem && !existsInWorkSpace) {
            this.logMessage("...deleteFolder error: folder " + folder.getLocation().toOSString() + " exists in file system but not in workspace! Cannot delete it.");
            existsInWorkSpace = folder.exists();
        }
        boolean ok = true;
        SystemResourceManager.turnOffResourceEventListening();
        folder.delete(true, false, null);
        SystemResourceManager.turnOnResourceEventListening();
        return ok;
    }

    public boolean renameFolder(IFolder folder, String newName) throws Exception {
        if (!this.exists((IResource)folder)) {
            return true;
        }
        boolean ok = true;
        IPath newPath = folder.getFullPath().removeLastSegments(1).append(newName);
        try {
            SystemResourceManager.turnOffResourceEventListening();
            if (!newPath.toFile().exists()) {
                folder.move(newPath, true, false, null);
            }
            SystemResourceManager.turnOnResourceEventListening();
        }
        catch (Exception exc) {
            SystemResourceManager.turnOnResourceEventListening();
            throw exc;
        }
        return ok;
    }

    public boolean moveFolder(IFolder newParent, IFolder folder) throws Exception {
        boolean ok = true;
        if (!this.exists((IResource)folder)) {
            return true;
        }
        SystemResourceManager.turnOffResourceEventListening();
        folder.move(newParent.getFullPath().append(folder.getName()), true, false, null);
        SystemResourceManager.turnOnResourceEventListening();
        return ok;
    }

    public String getFolderPath(IFolder folder) {
        return folder.getLocation().toOSString();
    }

    public IFolder[] listFolders(IContainer projectOrFolder) {
        if (!projectOrFolder.exists()) {
            return new IFolder[0];
        }
        SystemResourceManager.turnOffResourceEventListening();
        Vector<IResource> folders = new Vector<IResource>();
        try {
            IResource[] members = projectOrFolder.members();
            if (members != null) {
                int idx = 0;
                while (idx < members.length) {
                    if (members[idx].getType() == 2) {
                        folders.addElement(members[idx]);
                    }
                    ++idx;
                }
            }
        }
        catch (Exception exc) {
            this.logException("Error retrieving folder list", exc);
        }
        SystemResourceManager.turnOnResourceEventListening();
        return this.convertToFolderArray(folders);
    }

    public IFolder[] listFolders(IContainer projectOrFolder, String fileName) {
        if (!this.exists((IResource)projectOrFolder)) {
            return new IFolder[0];
        }
        SystemResourceManager.turnOffResourceEventListening();
        Vector<IResource> folders = new Vector<IResource>();
        try {
            this.refreshResource((IResource)projectOrFolder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            IResource[] members = projectOrFolder.members();
            if (members != null) {
                int idx = 0;
                while (idx < members.length) {
                    if (members[idx].getType() == 2 && this.exists((IResource)this.getFile((IContainer)((IFolder)members[idx]), fileName))) {
                        folders.addElement(members[idx]);
                    }
                    ++idx;
                }
            }
        }
        catch (Exception exc) {
            this.logException("Error retrieving folder list", exc);
        }
        SystemResourceManager.turnOnResourceEventListening();
        return this.convertToFolderArray(folders);
    }

    public String[] listFolders(IFolder folder, String namePrefix, String nameSuffix) {
        this.setListValues(false, true, namePrefix, nameSuffix);
        if (!folder.exists()) {
            return new String[0];
        }
        File dirFile = new File(folder.getLocation().toOSString());
        File[] fileObjs = dirFile.listFiles(this);
        String[] folders = null;
        if (fileObjs != null) {
            folders = new String[fileObjs.length];
            int idx = 0;
            while (idx < folders.length) {
                folders[idx] = fileObjs[idx].getName();
                ++idx;
            }
        } else {
            folders = new String[]{};
        }
        return folders;
    }

    public IFile getFile(IContainer parent, String fileName) {
        IFile file = null;
        SystemResourceManager.turnOffResourceEventListening();
        file = parent instanceof IProject ? ((IProject)parent).getFile(fileName) : ((IFolder)parent).getFile(fileName);
        SystemResourceManager.turnOnResourceEventListening();
        return file;
    }

    public boolean fileExists(IFile file) {
        String fileLocation = file.getLocation().toOSString();
        return new File(fileLocation).exists();
    }

    public boolean deleteFile(IFile file) throws Exception {
        SystemResourceManager.turnOffResourceEventListening();
        try {
            file.refreshLocal(2, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean ok = true;
        file.delete(true, false, null);
        SystemResourceManager.turnOnResourceEventListening();
        return ok;
    }

    public boolean renameFile(IFile file, String newName) throws Exception {
        boolean ok = true;
        IPath newPath = file.getFullPath().removeLastSegments(1).append(newName);
        SystemResourceManager.turnOffResourceEventListening();
        try {
            file.refreshLocal(2, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            file.move(newPath, true, false, null);
        }
        catch (Exception exc) {
            SystemResourceManager.turnOnResourceEventListening();
            throw exc;
        }
        SystemResourceManager.turnOnResourceEventListening();
        return ok;
    }

    public boolean moveFile(IFolder newParent, IFile file) throws Exception {
        boolean ok = true;
        SystemResourceManager.turnOffResourceEventListening();
        try {
            file.refreshLocal(2, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            file.move(newParent.getFullPath().append(file.getName()), true, false, null);
        }
        catch (Exception exc) {
            SystemResourceManager.turnOnResourceEventListening();
            throw exc;
        }
        SystemResourceManager.turnOnResourceEventListening();
        return ok;
    }

    public static String getFilePath(IFile file) {
        return file.getLocation().toOSString();
    }

    public IFile[] listFiles(IContainer projectOrFolder) {
        if (!this.exists((IResource)projectOrFolder)) {
            return new IFile[0];
        }
        SystemResourceManager.turnOffResourceEventListening();
        Vector<IResource> files = new Vector<IResource>();
        try {
            this.refreshResource((IResource)projectOrFolder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            IResource[] members = projectOrFolder.members();
            if (members != null) {
                int idx = 0;
                while (idx < members.length) {
                    if (members[idx].getType() == 1) {
                        files.addElement(members[idx]);
                    }
                    ++idx;
                }
            }
        }
        catch (Exception exc) {
            this.logException("Error retrieving file list", exc);
        }
        SystemResourceManager.turnOnResourceEventListening();
        return this.convertToFileArray(files);
    }

    public String[] listFiles(IFolder folder, String namePrefix, String nameSuffix) {
        this.setListValues(true, false, namePrefix, nameSuffix);
        File dirFile = new File(folder.getLocation().toOSString());
        File[] fileObjs = dirFile.listFiles(this);
        String[] files = null;
        if (fileObjs != null) {
            files = new String[fileObjs.length];
            int idx = 0;
            while (idx < files.length) {
                files[idx] = fileObjs[idx].getName();
                ++idx;
            }
        } else {
            files = new String[]{};
        }
        return files;
    }

    public IFolder[] convertToFolderArray(Vector vector) {
        if (vector == null) {
            return null;
        }
        IFolder[] folders = new IFolder[vector.size()];
        int idx = 0;
        while (idx < vector.size()) {
            folders[idx] = (IFolder)vector.elementAt(idx);
            ++idx;
        }
        return folders;
    }

    public IFile[] convertToFileArray(Vector vector) {
        if (vector == null) {
            return null;
        }
        IFile[] files = new IFile[vector.size()];
        int idx = 0;
        while (idx < vector.size()) {
            files[idx] = (IFile)vector.elementAt(idx);
            ++idx;
        }
        return files;
    }

    public Vector convertToVector(String[] array) {
        Vector<String> v = new Vector<String>();
        if (array != null) {
            int idx = 0;
            while (idx < array.length) {
                v.addElement(array[idx]);
                ++idx;
            }
        }
        return v;
    }

    public Vector convertToVectorAndStrip(String[] array, String namePrefix, String nameSuffix) {
        Vector<String> v = new Vector<String>();
        if (array != null) {
            int idx = 0;
            while (idx < array.length) {
                String name = array[idx];
                if (namePrefix != null) {
                    name = name.substring(namePrefix.length());
                }
                if (nameSuffix != null) {
                    name = name.substring(0, name.lastIndexOf(nameSuffix));
                }
                v.addElement(name);
                ++idx;
            }
        }
        return v;
    }

    public void setListValues(boolean filesOnly, boolean foldersOnly, String namePrefix, String nameSuffix) {
        this.filesOnly = filesOnly;
        this.foldersOnly = foldersOnly;
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
    }

    public boolean accept(File file) {
        boolean match = true;
        if (this.filesOnly ? !file.isFile() : this.foldersOnly && !file.isDirectory()) {
            return false;
        }
        String name = file.getName();
        if (this.nameSuffix != null && !name.endsWith(this.nameSuffix)) {
            return false;
        }
        if (this.namePrefix != null && !name.startsWith(this.namePrefix)) {
            return false;
        }
        return match;
    }

    public void logMessage(String msg) {
        RSECorePlugin.getDefault().getLogger().logWarning(msg);
    }

    public void logException(String msg, Exception exc) {
        RSECorePlugin.getDefault().getLogger().logError(msg, exc);
    }

    public boolean exists(IResource resource) {
        if (resource.exists()) {
            return true;
        }
        this.refreshResourceShallow(resource);
        return resource.exists();
    }
}

