/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence;

import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.SystemResourceManager;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.internal.persistence.PFPersistenceAnchor;
import org.eclipse.rse.internal.persistence.PFPersistenceLocation;
import org.eclipse.rse.internal.persistence.PFWorkspaceJob;
import org.eclipse.rse.internal.persistence.PFWorkspaceLocation;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.persistence.dom.RSEDOM;

class PFWorkspaceAnchor
implements PFPersistenceAnchor {
    PFWorkspaceAnchor() {
    }

    public String[] getProfileLocationNames() {
        Vector<String> names = new Vector<String>(10);
        IFolder providerFolder = this.getProviderFolder();
        if (providerFolder.isAccessible()) {
            try {
                IResource[] profileCandidates = providerFolder.members();
                int i = 0;
                while (i < profileCandidates.length) {
                    String candidateName;
                    IResource profileCandidate = profileCandidates[i];
                    if (profileCandidate.getType() == 2 && (candidateName = profileCandidate.getName()).startsWith("PRF")) {
                        names.add(candidateName);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                this.logException((Exception)((Object)e));
            }
        }
        String[] result = new String[names.size()];
        names.toArray(result);
        return result;
    }

    public IStatus deleteProfileLocation(String profileName, IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        IFolder profileFolder = this.getProfileFolder(profileName);
        if (profileFolder.exists()) {
            try {
                profileFolder.delete(1, monitor);
            }
            catch (CoreException e) {
                result = new Status(4, "org.eclipse.rse.core", 1, RSECoreMessages.PropertyFileProvider_UnexpectedException, (Throwable)e);
            }
        }
        return result;
    }

    public PFPersistenceLocation getProfileLocation(String profileLocationName) {
        IFolder profileFolder = this.getProfileFolder(profileLocationName);
        PFWorkspaceLocation result = new PFWorkspaceLocation(profileFolder);
        return result;
    }

    public Job makeSaveJob(RSEDOM dom, IRSEPersistenceProvider provider) {
        return new PFWorkspaceJob(dom, provider);
    }

    private IFolder getProfileFolder(String profileLocationName) {
        IFolder providerFolder = this.getProviderFolder();
        IFolder profileFolder = this.getFolder((IContainer)providerFolder, profileLocationName);
        return profileFolder;
    }

    private IFolder getProviderFolder() {
        IProject project = SystemResourceManager.getRemoteSystemsProject(false);
        if (project.isAccessible()) {
            try {
                project.refreshLocal(2, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        IFolder providerFolder = this.getFolder((IContainer)project, "dom.properties");
        return providerFolder;
    }

    private IFolder getFolder(IContainer parent, String name) {
        Path path = new Path(name);
        IFolder folder = parent.getFolder((IPath)path);
        return folder;
    }

    private void logException(Exception e) {
        RSECorePlugin.getDefault().getLogger().logError("unexpected exception", e);
    }
}

