/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service.xml;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class StripInvalidXMLCharsReader
extends FilterReader {
    public StripInvalidXMLCharsReader(Reader in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int r = -1;
        while ((r = super.read()) != -1) {
            if (!this.isValidXMLCodePoint(r)) continue;
            return r;
        }
        return -1;
    }

    private boolean isValidXMLCodePoint(int cp) {
        return cp == 9 || cp == 10 || cp == 13 || cp >= 32 && cp <= 55295 || cp >= 57344 && cp <= 65533 || cp >= 65536 && cp <= 0x10FFFF;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read;
        int remaining = read = super.read(cbuf, off, len);
        int i = off;
        while (i < off + read) {
            char c = cbuf[i];
            if (!this.isValidXMLCodePoint(c)) {
                --remaining;
                int after = off + read - i - 1;
                if (after > 0) {
                    System.arraycopy(cbuf, i + 1, cbuf, i, after);
                    cbuf[remaining] = '\u0000';
                }
            }
            ++i;
        }
        return remaining;
    }
}

