/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.open;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.rse.ui.open.ISystemQuickOpenPage;
import org.eclipse.rse.ui.open.ISystemQuickOpenPageContainer;
import org.eclipse.rse.ui.open.SystemQuickOpenPageDescriptor;
import org.eclipse.rse.ui.open.SystemQuickOpenUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class SystemQuickOpenDialog
extends Dialog
implements ISystemQuickOpenPageContainer,
IRunnableContext {
    private Control contents;
    private Button cancelButton;
    private Button openButton;
    private long activeRunningOperations;
    private Cursor waitCursor;
    private Cursor arrowCursor;
    private ProgressMonitorPart progressMonitorPart;
    private MessageDialog windowClosingDialog;
    private Point minSize;
    private ISelection selection;
    private String initialPageId;
    private ISystemQuickOpenPage currentPage;
    private int currentIndex;
    private List descriptors;

    public SystemQuickOpenDialog(Shell shell, ISelection selection, String pageId) {
        super(shell);
        this.selection = selection;
        this.initialPageId = pageId;
        this.descriptors = SystemQuickOpenUtil.getInstance().getQuickOpenPageDescriptors(this.initialPageId);
    }

    public void create() {
        super.create();
        if (this.currentPage != null) {
            this.currentPage.setVisible(true);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Open");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.contents = this.createPageArea(composite);
        GridLayout pmlayout = new GridLayout();
        pmlayout.numColumns = 1;
        this.progressMonitorPart = new ProgressMonitorPart(composite, (Layout)pmlayout, -1);
        this.progressMonitorPart.setLayoutData((Object)new GridData(768));
        this.progressMonitorPart.setVisible(false);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        SystemQuickOpenDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Control createPageArea(Composite parent) {
        int numPages = this.descriptors.size();
        if (numPages == 0) {
            Label label = new Label(parent, 0x1000040);
            return label;
        }
        this.currentIndex = this.getPreferredPageIndex();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                SystemQuickOpenDialog.this.currentPage = SystemQuickOpenDialog.this.getDescriptorAt(SystemQuickOpenDialog.this.currentIndex).createObject();
            }
        });
        this.currentPage.setContainer(this);
        if (numPages == 1) {
            return this.getControl(this.currentPage, parent);
        }
        Composite border = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 7;
        border.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(border, 0);
        folder.setLayoutData((Object)new GridData(1808));
        folder.setLayout((Layout)new TabFolderLayout());
        int i = 0;
        while (i < numPages) {
            SystemQuickOpenPageDescriptor descriptor = (SystemQuickOpenPageDescriptor)this.descriptors.get(i);
            final TabItem item = new TabItem(folder, 0);
            item.setText(descriptor.getLabel());
            item.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    item.setData(null);
                    if (item.getImage() != null) {
                        item.getImage().dispose();
                    }
                }
            });
            ImageDescriptor imageDesc = descriptor.getImage();
            if (imageDesc != null) {
                item.setImage(imageDesc.createImage());
            }
            item.setData((Object)descriptor);
            if (i == this.currentIndex) {
                item.setControl(this.getControl(this.currentPage, (Composite)folder));
                item.setData((Object)this.currentPage);
            }
            ++i;
        }
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SystemQuickOpenDialog.this.turnToPage(event);
            }
        });
        folder.setSelection(this.currentIndex);
        return border;
    }

    private int getPreferredPageIndex() {
        int result = 0;
        int size = this.descriptors.size();
        int i = 0;
        while (i < size) {
            SystemQuickOpenPageDescriptor descriptor = (SystemQuickOpenPageDescriptor)this.descriptors.get(i);
            if (this.initialPageId != null && this.initialPageId.equals(descriptor.getId())) {
                return i;
            }
            ++i;
        }
        return result;
    }

    private SystemQuickOpenPageDescriptor getDescriptorAt(int index) {
        return (SystemQuickOpenPageDescriptor)this.descriptors.get(index);
    }

    private Control getControl(ISystemQuickOpenPage page, Composite parent) {
        if (page.getControl() == null) {
            Composite pageWrapper = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            pageWrapper.setLayoutData((Object)new GridData(768));
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            pageWrapper.setLayout((Layout)layout);
            page.createControl(pageWrapper);
        }
        return page.getControl().getParent();
    }

    private void turnToPage(SelectionEvent event) {
        final TabItem item = (TabItem)event.item;
        if (item.getControl() == null) {
            final SystemQuickOpenPageDescriptor descriptor = (SystemQuickOpenPageDescriptor)item.getData();
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    item.setData((Object)descriptor.createObject());
                }
            });
            ISystemQuickOpenPage page = (ISystemQuickOpenPage)item.getData();
            page.setContainer(this);
            Control newControl = this.getControl(page, (Composite)event.widget);
            item.setControl(newControl);
        }
        if (item.getData() instanceof ISystemQuickOpenPage) {
            this.currentPage = (ISystemQuickOpenPage)item.getData();
            this.currentIndex = item.getParent().getSelectionIndex();
            this.resizeDialogIfNeeded(item.getControl());
            this.currentPage.setVisible(true);
        }
    }

    private void resizeDialogIfNeeded(Control newControl) {
        Point newSize;
        Point currentSize = this.currentPage.getControl().getSize();
        if (this.mustResize(currentSize, newSize = newControl.computeSize(-1, -1, true))) {
            Shell shell = this.getShell();
            shell.setSize(shell.computeSize(-1, -1, true));
        }
    }

    private boolean mustResize(Point currentSize, Point newSize) {
        return currentSize.x < newSize.x || currentSize.y < newSize.y;
    }

    private Point getMinSize() {
        if (this.minSize != null) {
            return this.minSize;
        }
        int x = 0;
        int y = 0;
        int length = this.descriptors.size();
        int i = 0;
        while (i < length) {
            Point size = this.getDescriptorAt(i).getPreferredSize();
            if (size.x != -1) {
                x = Math.max(x, size.x);
            }
            if (size.y != -1) {
                y = Math.max(y, size.y);
            }
            ++i;
        }
        this.minSize = new Point(x, y);
        return this.minSize;
    }

    protected void cancelPressed() {
        if (this.activeRunningOperations == 0L) {
            super.cancelPressed();
        }
    }

    protected void okPressed() {
        boolean result = this.performAction();
        if (result) {
            super.okPressed();
        }
    }

    protected boolean performAction() {
        if (this.currentPage == null) {
            return true;
        }
        return this.currentPage.performAction();
    }

    public IRunnableContext getRunnableContext() {
        return this;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setPerformActionEnabled(boolean state) {
        if (this.openButton != null) {
            this.openButton.setEnabled(state);
        }
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        HashMap state = null;
        try {
            ++this.activeRunningOperations;
            state = this.aboutToStart(fork && cancelable);
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.getProgressMonitor(), (Display)this.getShell().getDisplay());
        }
        catch (Throwable throwable) {
            if (state != null) {
                this.stopped(state);
            }
            --this.activeRunningOperations;
            throw throwable;
        }
        if (state != null) {
            this.stopped(state);
        }
        --this.activeRunningOperations;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.progressMonitorPart;
    }

    protected synchronized HashMap aboutToStart(boolean enableCancelButton) {
        HashMap savedState = null;
        Shell shell = this.getShell();
        if (shell != null) {
            Display d = shell.getDisplay();
            Control focusControl = d.getFocusControl();
            if (focusControl != null && focusControl.getShell() != shell) {
                focusControl = null;
            }
            this.waitCursor = new Cursor((Device)d, 1);
            this.setDisplayCursor(d, this.waitCursor);
            this.arrowCursor = new Cursor((Device)d, 0);
            this.cancelButton.setCursor(this.arrowCursor);
            savedState = this.saveUIState(enableCancelButton);
            if (focusControl != null) {
                savedState.put("focusControl", focusControl);
            }
            this.progressMonitorPart.attachToCancelComponent((Control)this.cancelButton);
            this.progressMonitorPart.setVisible(true);
        }
        return savedState;
    }

    protected synchronized void stopped(HashMap state) {
        Shell shell = this.getShell();
        if (shell != null) {
            this.progressMonitorPart.setVisible(false);
            this.progressMonitorPart.removeFromCancelComponent((Control)this.cancelButton);
            this.restoreUIState(state);
            this.setDisplayCursor(shell.getDisplay(), null);
            this.cancelButton.setCursor(null);
            this.waitCursor.dispose();
            this.waitCursor = null;
            this.arrowCursor.dispose();
            this.arrowCursor = null;
            Control focusControl = (Control)state.get("focusControl");
            if (focusControl != null && !focusControl.isDisposed()) {
                focusControl.setFocus();
            }
        }
    }

    private void setDisplayCursor(Display d, Cursor c) {
        Shell[] shells = d.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].setCursor(c);
            ++i;
        }
    }

    private void restoreUIState(HashMap state) {
        this.restoreEnableState((Control)this.cancelButton, state, "cancel");
        this.restoreEnableState((Control)this.openButton, state, "open");
        ControlEnableState pageState = (ControlEnableState)state.get("tabForm");
        pageState.restore();
    }

    protected void restoreEnableState(Control w, HashMap h, String key) {
        Boolean b;
        if (!w.isDisposed() && (b = (Boolean)h.get(key)) != null) {
            w.setEnabled(b.booleanValue());
        }
    }

    private HashMap saveUIState(boolean keepCancelEnabled) {
        HashMap<String, ControlEnableState> savedState = new HashMap<String, ControlEnableState>();
        this.saveEnableStateAndSet((Control)this.cancelButton, savedState, "cancel", keepCancelEnabled);
        this.saveEnableStateAndSet((Control)this.openButton, savedState, "open", false);
        savedState.put("tabForm", ControlEnableState.disable((Control)this.contents));
        return savedState;
    }

    private void saveEnableStateAndSet(Control w, HashMap h, String key, boolean enabled) {
        if (!w.isDisposed()) {
            h.put(key, new Boolean(w.isEnabled()));
            w.setEnabled(enabled);
        }
    }

    protected void handleShellCloseEvent() {
        if (this.okToClose()) {
            super.handleShellCloseEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean okToClose() {
        if (this.activeRunningOperations > 0L) {
            SystemQuickOpenDialog systemQuickOpenDialog = this;
            synchronized (systemQuickOpenDialog) {
                this.windowClosingDialog = this.createClosingDialog();
            }
            this.windowClosingDialog.open();
            systemQuickOpenDialog = this;
            synchronized (systemQuickOpenDialog) {
                this.windowClosingDialog = null;
            }
            return false;
        }
        return true;
    }

    private MessageDialog createClosingDialog() {
        MessageDialog result = new MessageDialog(this.getShell(), JFaceResources.getString((String)"WizardClosingDialog.title"), null, JFaceResources.getString((String)"WizardClosingDialog.message"), 3, new String[]{IDialogConstants.OK_LABEL}, 0);
        return result;
    }

    private class TabFolderLayout
    extends Layout {
        private TabFolderLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = 0;
            int y = 0;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Point size = children[i].computeSize(-1, -1, flushCache);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
                ++i;
            }
            Point minSize = SystemQuickOpenDialog.this.getMinSize();
            x = Math.max(x, minSize.x);
            y = Math.max(y, minSize.y);
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setBounds(rect);
                ++i;
            }
        }
    }
}

