/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.text;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.ui.text.ITMPresentationReconcilerListener;

public final class TMPresentationReconcilerTestGenerator
implements ITMPresentationReconcilerListener,
IDocumentListener,
ITextListener {
    private ITextViewer viewer = (ITextViewer)NullSafetyHelper.lazyNonNull();
    private IDocument document = (IDocument)NullSafetyHelper.lazyNonNull();
    private final StringBuilder code = new StringBuilder();

    @Override
    public void onInstalled(ITextViewer viewer, IDocument document) {
        this.viewer = viewer;
        this.document = document;
        document.addDocumentListener((IDocumentListener)this);
        viewer.addTextListener((ITextListener)this);
        this.write("package org.eclipse.tm4e.ui.text;", true);
        this.write("", true);
        this.write("import org.eclipse.jface.text.Document;", true);
        this.write("import org.eclipse.jface.text.IDocument;", true);
        this.write("import org.eclipse.jface.text.TextViewer;", true);
        this.write("import org.eclipse.swt.SWT;", true);
        this.write("import org.eclipse.swt.widgets.Display;", true);
        this.write("import org.eclipse.swt.widgets.Shell;", true);
        this.write("import org.eclipse.tm4e.core.grammar.IGrammar;", true);
        this.write("import org.eclipse.tm4e.core.registry.Registry;", true);
        this.write("import org.eclipse.tm4e.ui.text.TMPresentationReconciler;", true);
        this.write("import org.eclipse.tm4e.ui.themes.ITokenProvider;", true);
        this.write("import org.eclipse.tm4e.ui.themes.css.CSSTokenProvider;", true);
        this.write("import org.junit.Test;", true);
        this.write("", true);
        this.write("public class TMPresentationReconcilerTest {", true);
        this.write("", true);
        this.write("\t@Test", true);
        this.write("\tpublic void colorize() throws Exception {", true);
        this.write("", true);
        this.write("\t\tDisplay display = new Display();", true);
        this.write("\t\tShell shell = new Shell(display);", true);
        this.write("\t\tTextViewer viewer = new TextViewer(shell, SWT.NONE);", true);
        this.write("\t\tIDocument document = new Document();", true);
        this.write("\t\tviewer.setDocument(document);", true);
        this.write("\t\tdocument.set(\"");
        this.write(this.toText(document.get()));
        this.write("\");", true);
        this.write("", true);
        this.write("\t\tTMPresentationReconciler reconciler = new TMPresentationReconciler();", true);
        this.write("\t\treconciler.setTokenProvider(getTokenProvider());", true);
        this.write("\t\treconciler.setGrammar(getGrammar());", true);
        this.write("\t\treconciler.install(viewer);", true);
        this.write("", true);
    }

    private String toText(String text) {
        StringBuilder newText = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    newText.append("\\n");
                    break;
                }
                case '\r': {
                    newText.append("\\r");
                    break;
                }
                case '\"': {
                    newText.append("\\\"");
                    break;
                }
                default: {
                    newText.append(c);
                }
            }
            ++i;
        }
        return newText.toString();
    }

    @Override
    public void onUninstalled() {
        this.write("", true);
        this.write("\t\twhile (!shell.isDisposed()) {", true);
        this.write("\t\t}", true);
        this.write("\t}", true);
        this.write("\tprivate static ITokenProvider getTokenProvider() {", true);
        this.write("\t\treturn new CSSTokenProvider(TMPresentationReconcilerTest.class.getResourceAsStream(\"Solarized-light.css\"));", true);
        this.write("\t}", true);
        this.write("", true);
        this.write("\tprivate static IGrammar getGrammar() {", true);
        this.write("\t\tRegistry registry = new Registry();", true);
        this.write("\t\ttry {", true);
        this.write("\t\tString grammar=\"YouGrammar.tmLanguage\";", true);
        this.write("\t\t\treturn registry.loadGrammarFromPathSync(grammar,TMPresentationReconcilerTest.class.getResourceAsStream(grammar));", true);
        this.write("\t\t} catch (Exception e) {", true);
        this.write("\t\t\te.printStackTrace();", true);
        this.write("\t\treturn null;", true);
        this.write("\t\t}", true);
        this.write("\t}", true);
        this.write("}");
        System.err.println(this.code.toString());
        this.document.removeDocumentListener((IDocumentListener)this);
        this.viewer.removeTextListener((ITextListener)this);
    }

    @Override
    public void onColorized(TextPresentation presentation, @Nullable Throwable e) {
    }

    private void write(String s, boolean newLine) {
        this.code.append(s);
        if (newLine) {
            this.code.append("\n");
        }
    }

    private void write(String s) {
        this.write(s, false);
    }

    public void documentAboutToBeChanged(@Nullable DocumentEvent event) {
    }

    public void documentChanged(@Nullable DocumentEvent event) {
        if (event == null) {
            return;
        }
        String command = "document.replace(" + event.getOffset() + ", " + event.getLength() + ", \"" + this.toText(event.getText()) + "\");";
        this.write("\t\t" + command, true);
    }

    public void textChanged(@Nullable TextEvent event) {
        if (event == null || event.getDocumentEvent() != null) {
            return;
        }
        String command = "viewer.invalidateTextPresentation(" + event.getOffset() + ", " + event.getLength() + ");";
        this.write("\t\t" + command, true);
    }
}

