/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.themes;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.tm4e.core.internal.utils.StringUtils;
import org.eclipse.tm4e.core.theme.RGB;
import org.eclipse.tm4e.ui.internal.utils.PreferenceUtils;
import org.eclipse.tm4e.ui.internal.utils.UI;

public final class ColorManager {
    private static final ColorManager INSTANCE = new ColorManager();
    private final Map<RGB, Color> fColorTable = new HashMap<RGB, Color>(10);

    public static ColorManager getInstance() {
        return INSTANCE;
    }

    private static Color rgbToColor(RGB rgb) {
        return new Color((Device)UI.getDisplay(), rgb.red, rgb.green, rgb.blue);
    }

    private ColorManager() {
    }

    public Color getColor(RGB rgb) {
        return this.fColorTable.computeIfAbsent(rgb, ColorManager::rgbToColor);
    }

    public void dispose() {
        this.fColorTable.values().forEach(Color::dispose);
    }

    public @Nullable Color getPreferenceEditorColor(String tokenId) {
        IEclipsePreferences prefStore = PreferenceUtils.getEditorsPreferenceStore();
        if (prefStore == null) {
            return null;
        }
        return this.getColor(this.stringToRGB(prefStore.get(tokenId, "")));
    }

    public boolean isColorUserDefined(String tokenId) {
        IEclipsePreferences prefStore = PreferenceUtils.getEditorsPreferenceStore();
        if (prefStore == null) {
            return false;
        }
        String systemDefaultToken = this.getSystemDefaultToken(tokenId);
        return "".equals(systemDefaultToken) || !prefStore.getBoolean(systemDefaultToken, true);
    }

    public @Nullable Color getPriorityColor(@Nullable Color themeColor, String tokenId) {
        if (this.isColorUserDefined(tokenId)) {
            return this.getPreferenceEditorColor(tokenId);
        }
        return themeColor != null ? themeColor : null;
    }

    private String getSystemDefaultToken(String tokenId) {
        return switch (tokenId) {
            case "AbstractTextEditor.Color.Foreground" -> "AbstractTextEditor.Color.Foreground.SystemDefault";
            case "AbstractTextEditor.Color.Background" -> "AbstractTextEditor.Color.Background.SystemDefault";
            case "AbstractTextEditor.Color.SelectionBackground" -> "AbstractTextEditor.Color.SelectionBackground.SystemDefault";
            case "AbstractTextEditor.Color.SelectionForeground" -> "AbstractTextEditor.Color.SelectionForeground.SystemDefault";
            default -> "";
        };
    }

    private RGB stringToRGB(String value) {
        String[] rgbValues = StringUtils.splitToArray((String)value, (char)',');
        return rgbValues.length == 3 ? new RGB(Integer.parseInt(rgbValues[0]), Integer.parseInt(rgbValues[1]), Integer.parseInt(rgbValues[2])) : new RGB(255, 255, 255);
    }
}

