/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.ui.internal;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.userstorage.ui.internal.Activator;

public abstract class SystemBrowser {
    private static final String[] NO_COMMANDS = new String[0];
    private static final String[] WIN_COMMANDS = NO_COMMANDS;
    private static final String[] MAC_COMMANDS = new String[]{"open"};
    private static final String[] LINUX_COMMANDS = new String[]{"kde-open", "gnome-open", "xdg-open", "sensible-browser"};

    public static void openSafe(Shell shell, String url, String defaultMessage) {
        if (!SystemBrowser.open(url)) {
            MessageDialog.openInformation((Shell)shell, (String)"System Browser Not Found", (String)defaultMessage);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean open(String url) {
        try {
            String[] stringArray = SystemBrowser.getOpenCommands();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String command = stringArray[n2];
                if (SystemBrowser.open(command, url)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable command) {
            // empty catch block
        }
        try {
            Desktop desktop = Desktop.getDesktop();
            desktop.browse(new URI(url));
            return true;
        }
        catch (Throwable ex) {
            Activator.log(ex, 2);
            return false;
        }
    }

    private static boolean open(String command, String url) {
        if (SystemBrowser.getFromPath(command) != null) {
            String[] cmdarray = new String[]{command, url};
            try {
                Process process = Runtime.getRuntime().exec(cmdarray);
                if (process != null) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private static String[] getOpenCommands() {
        String os = Platform.getOS();
        if ("win32".equals(os)) {
            return WIN_COMMANDS;
        }
        if ("macosx".equals(os)) {
            return MAC_COMMANDS;
        }
        if ("linux".equals(os)) {
            return LINUX_COMMANDS;
        }
        return NO_COMMANDS;
    }

    private static File getFromPath(String command) {
        String path = System.getenv().get("PATH");
        StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String folder = tokenizer.nextToken();
            File file = new File(folder, command);
            if (!file.isFile()) continue;
            return file;
        }
        return null;
    }
}

