/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.future.CancelOption;

public interface WaitableFuture {
    public Object getId();

    default public boolean await(CancelOption ... options) throws IOException {
        return this.await(Long.MAX_VALUE, options);
    }

    default public boolean await(long timeout, TimeUnit unit, CancelOption ... options) throws IOException {
        return this.await(unit.toMillis(timeout), options);
    }

    default public boolean await(Duration timeout, CancelOption ... options) throws IOException {
        return timeout != null ? this.await(timeout.toMillis(), options) : this.await(options);
    }

    public boolean await(long var1, CancelOption ... var3) throws IOException;

    default public boolean awaitUninterruptibly(CancelOption ... options) {
        return this.awaitUninterruptibly(Long.MAX_VALUE, options);
    }

    default public boolean awaitUninterruptibly(long timeout, TimeUnit unit, CancelOption ... options) {
        return this.awaitUninterruptibly(unit.toMillis(timeout), options);
    }

    default public boolean awaitUninterruptibly(Duration timeoutMillis, CancelOption ... options) {
        return timeoutMillis != null ? this.awaitUninterruptibly(timeoutMillis.toMillis(), options) : this.awaitUninterruptibly(options);
    }

    public boolean awaitUninterruptibly(long var1, CancelOption ... var3);

    public boolean isDone();
}

