/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers.internal;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StructuredViewer;

public class ExpandableNode {
    private Object[] orginalArray;
    private final int startOffSet;
    private final int limit;
    private static Object VALUE = new Object();
    private final List<Object> addedElements;
    private final int start;
    private final StructuredViewer viewer;
    private final IdentityHashMap<Object, Object> uniqueElementsMap;

    public ExpandableNode(Object[] children, int startOffSet, int limit, StructuredViewer viewer) {
        Assert.isNotNull((Object)children, (String)"children of an ExpandableNode cannot be null");
        Assert.isTrue((startOffSet >= 0 && startOffSet < children.length ? 1 : 0) != 0, (String)("startOffSet must be within the range of children: " + startOffSet));
        this.orginalArray = children;
        this.startOffSet = startOffSet;
        this.start = startOffSet;
        this.limit = limit;
        this.viewer = viewer;
        this.addedElements = new ArrayList<Object>();
        this.uniqueElementsMap = new IdentityHashMap();
    }

    public int getOffset() {
        return this.startOffSet;
    }

    public int getLimit() {
        return this.limit;
    }

    public Object[] getRemainingElements() {
        if (this.addedElements.size() > 0) {
            Object[] children = this.updateChildrenWithAddedElements();
            return children;
        }
        Object[] children = new Object[this.orginalArray.length - this.startOffSet];
        System.arraycopy(this.orginalArray, this.startOffSet, children, 0, children.length);
        return children;
    }

    private Object[] updateChildrenWithAddedElements() {
        Object[] children = new Object[this.orginalArray.length - this.startOffSet + this.addedElements.size()];
        System.arraycopy(this.orginalArray, this.startOffSet, children, 0, this.orginalArray.length - this.startOffSet);
        System.arraycopy(this.addedElements.toArray(), 0, children, this.orginalArray.length - this.startOffSet, this.addedElements.size());
        if (this.viewer.getComparator() != null) {
            this.viewer.getComparator().sort(this.viewer, children);
        }
        Object[] newOriginalArray = new Object[this.orginalArray.length + this.addedElements.size()];
        System.arraycopy(this.orginalArray, 0, newOriginalArray, 0, this.startOffSet);
        System.arraycopy(children, 0, newOriginalArray, this.startOffSet, children.length);
        this.orginalArray = newOriginalArray;
        this.addedElements.clear();
        return children;
    }

    public Object[] getAllElements() {
        if (this.addedElements.size() > 0) {
            this.updateChildrenWithAddedElements();
            return this.orginalArray;
        }
        return this.orginalArray;
    }

    public String getLabel() {
        String label;
        int all = this.orginalArray.length + this.addedElements.size();
        int remaining = all - this.start;
        if (remaining > this.limit) {
            if (remaining == this.limit + 1) {
                String suffix = remaining == 1 ? "" : "s";
                return JFaceResources.format("ExpandableNode.showRemaining", remaining, suffix);
            }
            label = JFaceResources.format("ExpandableNode.defaultLabel", this.limit, remaining);
        } else {
            String suffix = remaining == 1 ? "" : "s";
            label = JFaceResources.format("ExpandableNode.showRemaining", remaining, suffix);
        }
        return label;
    }

    public void addElement(Object element) {
        this.initializeUniqueMap();
        this.uniqueElementsMap.put(element, VALUE);
        this.addedElements.add(element);
    }

    private void initializeUniqueMap() {
        if (this.uniqueElementsMap.isEmpty()) {
            Object[] objectArray = this.orginalArray;
            int n = this.orginalArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.uniqueElementsMap.put(element, VALUE);
                ++n2;
            }
        }
    }

    public boolean contains(Object element) {
        this.initializeUniqueMap();
        return this.uniqueElementsMap.containsKey(element);
    }
}

