/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ImageManager {
    private static final String PROP_IMAGE_MANAGER = "org.eclipse.team.ui.imageManager";
    private LocalResourceManager imageManager;
    private CompareConfiguration compareConfig = new CompareConfiguration();
    private boolean disposed = false;

    public static synchronized ImageManager getImageManager(ISynchronizationContext context, ISynchronizePageConfiguration configuration) {
        ImageManager manager = (ImageManager)context.getCache().get(PROP_IMAGE_MANAGER);
        if (manager == null || manager.disposed) {
            ImageManager newRegistry = new ImageManager();
            context.getCache().put(PROP_IMAGE_MANAGER, (Object)newRegistry);
            Viewer v = ImageManager.getViewer(configuration);
            if (v != null) {
                v.getControl().addDisposeListener(e -> newRegistry.dispose());
            } else {
                context.getCache().addCacheListener(cache -> newRegistry.dispose());
            }
            manager = newRegistry;
        }
        return manager;
    }

    private static Viewer getViewer(ISynchronizePageConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        if (configuration.getPage() == null) {
            return null;
        }
        return configuration.getPage().getViewer();
    }

    public Image getImage(ImageDescriptor descriptor) {
        if (descriptor == null || this.disposed) {
            return null;
        }
        ResourceManager manager = this.getResourceManager();
        Image image = (Image)manager.create((DeviceResourceDescriptor)descriptor);
        return image;
    }

    private synchronized ResourceManager getResourceManager() {
        if (this.imageManager == null) {
            this.imageManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.imageManager;
    }

    public void dispose() {
        this.disposed = true;
        this.compareConfig.dispose();
        if (this.imageManager != null) {
            this.imageManager.dispose();
        }
    }

    public Image getImage(Image base, int compareKind) {
        if (this.disposed) {
            return null;
        }
        return this.compareConfig.getImage(base, compareKind);
    }
}

