/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.audio;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.server.ui.internal.audio.AudioCore;
import org.eclipse.wst.server.ui.internal.audio.Sound;
import org.eclipse.wst.server.ui.internal.viewers.BaseContentProvider;

class AudioTableContentProvider
extends BaseContentProvider {
    protected static final String MISC_CATEGORY = "miscCategory";

    public Object[] getElements(Object inputElement) {
        AudioCore core = AudioCore.getInstance();
        Map<String, String> categories = core.getCategories();
        Map<String, Sound> sounds = core.getSounds();
        ArrayList<Object> list = new ArrayList<Object>(sounds.size());
        ArrayList<String> cats = new ArrayList<String>();
        Iterator<String> iterator = categories.keySet().iterator();
        while (iterator.hasNext()) {
            cats.add(iterator.next());
        }
        this.sortCategories(cats);
        for (String id : categories.keySet()) {
            List<Sound> l = AudioTableContentProvider.getSoundsByCategory(id);
            if (l.isEmpty()) continue;
            list.add(id);
            this.sortSounds(l);
            int size = l.size();
            int i = 0;
            while (i < size) {
                list.add(l.get(i));
                ++i;
            }
        }
        List<Sound> l = AudioTableContentProvider.getSoundsByCategory(null);
        if (!l.isEmpty()) {
            list.add(MISC_CATEGORY);
            this.sortSounds(l);
            int size = l.size();
            int i = 0;
            while (i < size) {
                list.add(l.get(i));
                ++i;
            }
        }
        return list.toArray();
    }

    protected static List<Sound> getSoundsByCategory(String category) {
        AudioCore core = AudioCore.getInstance();
        Map<String, Sound> sounds = core.getSounds();
        Map<String, String> categories = core.getCategories();
        ArrayList<Sound> list = new ArrayList<Sound>();
        for (String id : sounds.keySet()) {
            Sound sound = sounds.get(id);
            if (category != null && category.equals(sound.getCategory())) {
                list.add(sound);
                continue;
            }
            if (category != null || sound.getCategory() != null && categories.containsKey(sound.getCategory())) continue;
            list.add(sound);
        }
        return list;
    }

    protected void sortCategories(List<String> list) {
        int size = list.size();
        if (size < 2) {
            return;
        }
        Map<String, String> categories = AudioCore.getInstance().getCategories();
        int i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                String b;
                String bb;
                String a = list.get(i);
                String aa = categories.get(a);
                if (aa.compareTo(bb = categories.get(b = list.get(j))) > 0) {
                    list.set(i, b);
                    list.set(j, a);
                }
                ++j;
            }
            ++i;
        }
    }

    protected void sortSounds(List<Sound> sounds) {
        int size = sounds.size();
        if (size < 2) {
            return;
        }
        int i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                Sound a = sounds.get(i);
                Sound b = sounds.get(j);
                if (a.getName().compareTo(b.getName()) > 0) {
                    sounds.set(i, b);
                    sounds.set(j, a);
                }
                ++j;
            }
            ++i;
        }
    }
}

