/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess.providers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.providers.CommandElement;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class CommandProvider
extends QuickAccessProvider {
    private IEclipseContext context;
    private ExpressionContext evaluationContext;
    private final Map<String, CommandElement> idToCommand = Collections.synchronizedMap(new HashMap());
    private IHandlerService handlerService;
    private ICommandService commandService;
    private EHandlerService ehandlerService;
    private ICommandImageService commandImageService;
    private boolean allCommandsRetrieved;

    public void setContext(IEclipseContext context) {
        this.reset();
        this.context = context;
        this.evaluationContext = new ExpressionContext(context);
    }

    @Override
    public String getId() {
        return "org.eclipse.ui.commands";
    }

    @Override
    public QuickAccessElement findElement(String id, String filterText) {
        this.retrieveCommand(id);
        return this.idToCommand.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuickAccessElement[] getElements() {
        if (!this.allCommandsRetrieved) {
            ICommandService commandService = this.getCommandService();
            Collection commandIds = commandService.getDefinedCommandIds();
            for (String commandId : commandIds) {
                this.retrieveCommand(commandId);
            }
            this.allCommandsRetrieved = true;
        }
        Map<String, CommandElement> map = this.idToCommand;
        synchronized (map) {
            return (QuickAccessElement[])this.idToCommand.values().stream().toArray(QuickAccessElement[]::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveCommand(String currentCommandId) {
        boolean commandRetrieved = this.idToCommand.containsKey(currentCommandId);
        if (!commandRetrieved) {
            ICommandService commandService = this.getCommandService();
            EHandlerService ehandlerService = this.getEHandlerService();
            Command command = commandService.getCommand(currentCommandId);
            ParameterizedCommand pcmd = new ParameterizedCommand(command, null);
            if (command != null && ehandlerService.canExecute(pcmd, this.context)) {
                try {
                    Collection combinations = ParameterizedCommand.generateCombinations((Command)command);
                    for (ParameterizedCommand pc : combinations) {
                        String id = pc.serialize();
                        Map<String, CommandElement> map = this.idToCommand;
                        synchronized (map) {
                            this.idToCommand.put(id, new CommandElement(pc, id, this));
                        }
                    }
                }
                catch (NotDefinedException notDefinedException) {}
            }
        }
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_NODE");
    }

    @Override
    public String getName() {
        return QuickAccessMessages.QuickAccess_Commands;
    }

    EHandlerService getEHandlerService() {
        if (this.ehandlerService == null) {
            this.ehandlerService = this.context != null ? (EHandlerService)this.context.get(EHandlerService.class) : (EHandlerService)PlatformUI.getWorkbench().getService(EHandlerService.class);
        }
        return this.ehandlerService;
    }

    ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.context != null ? (ICommandService)this.context.get(ICommandService.class) : (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        }
        return this.commandService;
    }

    IHandlerService getHandlerService() {
        if (this.handlerService == null) {
            this.handlerService = this.context != null ? (IHandlerService)this.context.get(IHandlerService.class) : (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        }
        return this.handlerService;
    }

    public ICommandImageService getCommandImageService() {
        if (this.commandImageService == null) {
            this.commandImageService = this.context != null ? (ICommandImageService)this.context.get(ICommandImageService.class) : (ICommandImageService)PlatformUI.getWorkbench().getService(ICommandImageService.class);
        }
        return this.commandImageService;
    }

    public IEvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReset() {
        this.allCommandsRetrieved = false;
        Map<String, CommandElement> map = this.idToCommand;
        synchronized (map) {
            this.idToCommand.clear();
        }
        this.evaluationContext = null;
        this.context = null;
    }

    @Override
    public boolean requiresUiAccess() {
        return true;
    }
}

