/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.director.Messages;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.osgi.util.NLS;

public abstract class Explanation
implements Comparable<Explanation> {
    public static final Explanation OPTIONAL_REQUIREMENT = new Explanation(){

        @Override
        public int orderValue() {
            return 6;
        }

        public String toString() {
            return Messages.Explanation_optionalDependency;
        }

        @Override
        public int shortAnswer() {
            return 100;
        }
    };
    public static final int MISSING_REQUIREMENT = 1;
    public static final int VIOLATED_SINGLETON_CONSTRAINT = 2;
    public static final int IU_INSTALLED = 3;
    public static final int IU_TO_INSTALL = 4;
    public static final int VIOLATED_HARD_REQUIREMENT = 5;
    public static final int VIOLATED_PATCHED_HARD_REQUIREMENT = 6;
    public static final int NON_INSTALLABLE_ROOT = 7;
    public static final int OTHER_REASON = 100;

    protected Explanation() {
    }

    @Override
    public int compareTo(Explanation exp) {
        if (this.orderValue() == exp.orderValue()) {
            return this.toString().compareTo(exp.toString());
        }
        return this.orderValue() - exp.orderValue();
    }

    protected abstract int orderValue();

    public abstract int shortAnswer();

    public IStatus toStatus() {
        return new Status(4, "org.eclipse.equinox.p2.director", this.toString());
    }

    protected static String getUserReadableName(IInstallableUnit iu) {
        if (iu == null) {
            return "";
        }
        String result = Explanation.getLocalized(iu);
        if (result == null) {
            return iu.toString();
        }
        return result + " " + String.valueOf(iu.getVersion()) + " (" + iu.toString() + ")";
    }

    private static String getLocalized(IInstallableUnit iu) {
        String value = iu.getProperty("org.eclipse.equinox.p2.name");
        if (value == null || value.length() <= 1 || value.charAt(0) != '%') {
            return value;
        }
        String actualKey = value.substring(1);
        return iu.getProperty("df_LT." + actualKey);
    }

    public static class HardRequirement
    extends Explanation {
        public final IInstallableUnit iu;
        public final IRequirement req;

        public HardRequirement(IInstallableUnit iu, IRequirement req) {
            this.iu = iu;
            this.req = req;
        }

        @Override
        public int orderValue() {
            return 5;
        }

        @Override
        public IStatus toStatus() {
            MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.director", 1, Messages.Explanation_unsatisfied, null);
            result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_from, (Object)HardRequirement.getUserReadableName(this.iu))));
            result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_to, (Object)this.req)));
            return result;
        }

        public String toString() {
            return NLS.bind((String)(this.req.getMax() == 0 ? Messages.Explanation_hardDependencyNegative : Messages.Explanation_hardDependency), (Object)this.iu, (Object)this.req);
        }

        @Override
        public int shortAnswer() {
            return 5;
        }
    }

    public static class IUInstalled
    extends Explanation {
        public final IInstallableUnit iu;

        public IUInstalled(IInstallableUnit iu) {
            this.iu = iu;
        }

        @Override
        public int orderValue() {
            return 2;
        }

        public String toString() {
            return NLS.bind((String)Messages.Explanation_alreadyInstalled, (Object)this.iu);
        }

        @Override
        public IStatus toStatus() {
            return new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_alreadyInstalled, (Object)IUInstalled.getUserReadableName(this.iu)));
        }

        @Override
        public int shortAnswer() {
            return 3;
        }
    }

    public static class IUToInstall
    extends Explanation {
        public final IInstallableUnit iu;

        public IUToInstall(IInstallableUnit iu) {
            this.iu = iu;
        }

        @Override
        public int orderValue() {
            return 1;
        }

        public String toString() {
            return NLS.bind((String)Messages.Explanation_toInstall, (Object)this.iu);
        }

        @Override
        public IStatus toStatus() {
            return new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_toInstall, (Object)IUToInstall.getUserReadableName(this.iu)));
        }

        @Override
        public int shortAnswer() {
            return 4;
        }
    }

    public static class MissingGreedyIU
    extends Explanation {
        public final IInstallableUnit iu;

        public MissingGreedyIU(IInstallableUnit iu) {
            this.iu = iu;
        }

        @Override
        public int orderValue() {
            return 3;
        }

        @Override
        public int shortAnswer() {
            return 1;
        }

        public String toString() {
            return NLS.bind((String)Messages.Explanation_missingNonGreedyRequired, (Object)this.iu);
        }

        @Override
        public IStatus toStatus() {
            return new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_missingNonGreedyRequired, (Object)MissingGreedyIU.getUserReadableName(this.iu)));
        }
    }

    public static class MissingIU
    extends Explanation {
        public final IInstallableUnit iu;
        public final IRequirement req;
        public boolean isEntryPoint;

        public MissingIU(IInstallableUnit iu, IRequirement req, boolean isEntryPoint) {
            this.iu = iu;
            this.req = req;
            this.isEntryPoint = isEntryPoint;
        }

        @Override
        public int orderValue() {
            return 3;
        }

        @Override
        public int shortAnswer() {
            return 1;
        }

        public String toString() {
            if (this.isEntryPoint) {
                return NLS.bind((String)Messages.Explanation_missingRootRequired, (Object)this.req);
            }
            if (this.req.getFilter() == null) {
                return NLS.bind((String)Messages.Explanation_missingRequired, (Object)this.iu, (Object)this.req);
            }
            return NLS.bind((String)Messages.Explanation_missingRequiredFilter, (Object[])new Object[]{this.req.getFilter(), this.iu, this.req});
        }

        @Override
        public IStatus toStatus() {
            if (this.isEntryPoint) {
                return new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_missingRootRequired, (Object)this.req));
            }
            if (this.req.getFilter() == null) {
                return new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_missingRequired, (Object)MissingIU.getUserReadableName(this.iu), (Object)this.req));
            }
            return new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_missingRequiredFilter, (Object[])new Object[]{this.req.getFilter(), MissingIU.getUserReadableName(this.iu), this.req}));
        }
    }

    public static class NotInstallableRoot
    extends Explanation {
        public final IRequirement req;

        public NotInstallableRoot(IRequirement req) {
            this.req = req;
        }

        public String toString() {
            return NLS.bind((String)Messages.Explanation_missingRootFilter, (Object)this.req);
        }

        @Override
        public IStatus toStatus() {
            return new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_missingRootFilter, (Object)this.req));
        }

        @Override
        protected int orderValue() {
            return 2;
        }

        @Override
        public int shortAnswer() {
            return 7;
        }
    }

    public static class PatchedHardRequirement
    extends Explanation {
        public final IInstallableUnit iu;
        public final IInstallableUnitPatch patch;
        public final IRequirement req;

        public PatchedHardRequirement(IInstallableUnit iu, IInstallableUnitPatch patch) {
            this.iu = iu;
            this.req = null;
            this.patch = patch;
        }

        public PatchedHardRequirement(IInstallableUnit iu, IRequirement req, IInstallableUnitPatch patch) {
            this.iu = iu;
            this.req = req;
            this.patch = patch;
        }

        @Override
        public int orderValue() {
            return 6;
        }

        @Override
        public IStatus toStatus() {
            MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.director", 1, Messages.Explanation_unsatisfied, null);
            String fromString = this.patch.toString() + " " + PatchedHardRequirement.getUserReadableName(this.iu);
            result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_fromPatch, (Object)fromString)));
            result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_to, (Object)this.req)));
            return result;
        }

        public String toString() {
            return NLS.bind((String)Messages.Explanation_patchedHardDependency, (Object[])new Object[]{this.patch, this.iu, this.req});
        }

        @Override
        public int shortAnswer() {
            return 6;
        }
    }

    public static class Singleton
    extends Explanation {
        public final IInstallableUnit[] ius;

        public Singleton(IInstallableUnit[] ius) {
            this.ius = ius;
        }

        @Override
        public int orderValue() {
            return 4;
        }

        @Override
        public int shortAnswer() {
            return 2;
        }

        @Override
        public IStatus toStatus() {
            MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.director", 1, NLS.bind((String)Messages.Explanation_singleton, (Object)""), null);
            IInstallableUnit[] iInstallableUnitArray = this.ius;
            int n = this.ius.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallableUnit iu = iInstallableUnitArray[n2];
                result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", Singleton.getUserReadableName(iu)));
                ++n2;
            }
            return result;
        }

        public String toString() {
            return NLS.bind((String)Messages.Explanation_singleton, Arrays.asList(this.ius));
        }
    }
}

