/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.mediawiki.internal.token;

import org.eclipse.mylyn.wikitext.mediawiki.MediaWikiLanguage;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;

public class HyperlinkInternalReplacementToken
extends PatternBasedElement {
    protected String getPattern(int groupOffset) {
        return "(?:\\[\\[([^\\]\\|]+?)\\s*(?:\\|\\s*([^\\]]*))?\\]\\])";
    }

    protected int getPatternGroupCount() {
        return 2;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new HyperlinkReplacementTokenProcessor();
    }

    private static class HyperlinkReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private HyperlinkReplacementTokenProcessor() {
        }

        public void emit() {
            String pageName = this.group(1);
            String altText = this.group(2);
            String href = ((MediaWikiLanguage)this.getMarkupLanguage()).toInternalHref(pageName.replace(' ', '_'));
            if (pageName.startsWith(":")) {
                pageName = pageName.substring(1);
            }
            if ((altText == null || altText.trim().length() == 0) && (altText = pageName).startsWith("#")) {
                altText = altText.substring(1);
            }
            if (pageName.startsWith("#")) {
                this.builder.link(href, altText);
            } else {
                LinkAttributes attributes = new LinkAttributes();
                attributes.setTitle(pageName);
                this.builder.link((Attributes)attributes, href, altText);
            }
        }
    }
}

