/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.internal.resources.InternalWorkspaceJob;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ValidateProjectEncoding
extends InternalWorkspaceJob {
    public static final String MARKER_ID = "noExplicitEncoding";
    public static final String MARKER_TYPE = ResourcesPlugin.getPlugin().getBundle().getSymbolicName() + ".noExplicitEncoding";
    public static final int SEVERITY_IGNORE = -1;
    private final IProject[] projects;

    public static void scheduleWorkspaceValidation(Workspace workspace) {
        IProject[] projects = workspace.getRoot().getProjects();
        ValidateProjectEncoding validateProjectEncoding = new ValidateProjectEncoding(workspace, projects);
        validateProjectEncoding.setRule(workspace.getRoot());
        validateProjectEncoding.schedule();
    }

    public static void scheduleProjectValidation(Workspace workspace, IProject project) {
        boolean shouldScheduleValidation = ValidateProjectEncoding.shouldScheduleValidation(project);
        if (shouldScheduleValidation) {
            ValidateProjectEncoding validateProjectEncoding = new ValidateProjectEncoding(workspace, project);
            validateProjectEncoding.setRule(project);
            validateProjectEncoding.schedule();
        }
    }

    private ValidateProjectEncoding(Workspace workspace, IProject ... projects) {
        super(Messages.resources_checkExplicitEncoding_jobName, workspace);
        this.setSystem(true);
        this.projects = projects;
    }

    public boolean belongsTo(Object family) {
        return family == ValidateProjectEncoding.class;
    }

    @Override
    public IStatus runInWorkspace(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.projects.length);
        IProject[] iProjectArray = this.projects;
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            subMonitor.checkCanceled();
            subMonitor.setTaskName(NLS.bind((String)Messages.resources_checkExplicitEncoding_taskName, (Object)project.getName()));
            ValidateProjectEncoding.updateMissingEncodingMarker(project);
            subMonitor.worked(1);
            ++n2;
        }
        return Status.OK_STATUS;
    }

    static void updateMissingEncodingMarker(IProject project) {
        try {
            if (project.isAccessible() && !project.isHidden()) {
                int severity = ValidateProjectEncoding.getSeverity();
                String defaultCharset = ValidateProjectEncoding.getDefaultCharset(project);
                if (severity != -1 && defaultCharset == null) {
                    ValidateProjectEncoding.createOrUpdateMissingEncodingMarker(project, severity);
                } else {
                    ValidateProjectEncoding.deleteEncodingMarkers(project);
                }
            }
        }
        catch (CoreException e) {
            ValidateProjectEncoding.logException(e);
        }
    }

    private static int getSeverity() {
        int severity = 1;
        severity = Platform.getPreferencesService().getInt("org.eclipse.core.resources", "missingEncodingMarkerSeverity", severity, null);
        return severity;
    }

    private static boolean shouldScheduleValidation(IProject project) {
        boolean shouldScheduleValidation = true;
        try {
            if (project.isHidden()) {
                shouldScheduleValidation = false;
            } else if (project.isAccessible()) {
                boolean hasEncodingMarkers;
                String defaultCharset = ValidateProjectEncoding.getDefaultCharset(project);
                boolean hasDefaultEncoding = defaultCharset != null;
                IMarker[] encodingMarkers = ValidateProjectEncoding.getEncodingMarkers(project);
                boolean bl = hasEncodingMarkers = encodingMarkers != null && encodingMarkers.length > 0;
                if (hasEncodingMarkers && !hasDefaultEncoding) {
                    shouldScheduleValidation = false;
                } else if (!hasEncodingMarkers && hasDefaultEncoding) {
                    shouldScheduleValidation = false;
                }
            }
        }
        catch (CoreException e) {
            ValidateProjectEncoding.logException(e);
        }
        return shouldScheduleValidation;
    }

    private static String getDefaultCharset(IProject project) throws CoreException {
        boolean checkImplicit = false;
        String defaultCharset = project.getDefaultCharset(checkImplicit);
        return defaultCharset;
    }

    private static void createOrUpdateMissingEncodingMarker(IProject project, int severity) throws CoreException {
        IMarker[] existing;
        String message = NLS.bind((String)Messages.resources_checkExplicitEncoding_problemText, (Object)project.getName());
        String[] attributeNames = new String[]{"message", "location"};
        Object[] attributevalues = new Object[]{message, project.getFullPath().toString()};
        IMarker[] iMarkerArray = existing = project.findMarkers(MARKER_TYPE, false, 1);
        int n = existing.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            Object[] markerValues = marker.getAttributes(attributeNames);
            if (Arrays.equals(attributevalues, markerValues)) {
                ValidateProjectEncoding.updateMarkerSeverity(marker, severity);
                return;
            }
            ++n2;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        int i = 0;
        while (i < attributeNames.length) {
            attributes.put(attributeNames[i], attributevalues[i]);
            ++i;
        }
        attributes.put("severity", severity);
        project.createMarker(MARKER_TYPE, attributes);
    }

    private static void updateMarkerSeverity(IMarker marker, int severity) throws CoreException {
        int currentSeverity = (Integer)marker.getAttribute("severity");
        if (currentSeverity != severity) {
            marker.setAttribute("severity", severity);
        }
    }

    private static void deleteEncodingMarkers(IProject project) throws CoreException {
        IMarker[] existing;
        IMarker[] iMarkerArray = existing = ValidateProjectEncoding.getEncodingMarkers(project);
        int n = existing.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            marker.delete();
            ++n2;
        }
    }

    private static IMarker[] getEncodingMarkers(IProject project) throws CoreException {
        IMarker[] existing = project.findMarkers(MARKER_TYPE, false, 1);
        return existing;
    }

    private static void logException(CoreException e) {
        int code;
        boolean logException = true;
        if (e instanceof ResourceException && ((code = e.getStatus().getCode()) == 368 || code == 372)) {
            logException = false;
        }
        if (logException) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
        }
    }
}

