/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.contexts;

import java.util.WeakHashMap;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.osgi.EclipseContextOSGi;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public final class EclipseContextFactory {
    private static WeakHashMap<BundleContext, IEclipseContext> serviceContexts = new WeakHashMap();

    public static IEclipseContext create() {
        return new EclipseContext(null);
    }

    public static IEclipseContext create(String name) {
        IEclipseContext result = EclipseContextFactory.create();
        result.set("debugString", name);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IEclipseContext getServiceContext(BundleContext bundleContext) {
        WeakHashMap<BundleContext, IEclipseContext> weakHashMap = serviceContexts;
        synchronized (weakHashMap) {
            IEclipseContext result = serviceContexts.get(bundleContext);
            if (result == null) {
                result = EclipseContextFactory.createServiceContext(bundleContext);
                serviceContexts.put(bundleContext, result);
            }
            return result;
        }
    }

    public static IEclipseContext getServiceContext(Class<?> contextClass) {
        Bundle bundle = FrameworkUtil.getBundle(contextClass);
        if (bundle == null) {
            throw new IllegalArgumentException("The passed context class is not loaded by an OSGI framework!");
        }
        BundleContext bundleContext = bundle.getBundleContext();
        if (bundleContext == null) {
            throw new IllegalStateException(String.format("The bundle %s is not started yet, either start it explicitly or add 'Bundle-ActivationPolicy: lazy' header to it before using this method!", bundle.getSymbolicName()));
        }
        return EclipseContextFactory.getServiceContext(bundleContext);
    }

    public static IEclipseContext createServiceContext(BundleContext bundleContext) {
        EclipseContextOSGi result = new EclipseContextOSGi(bundleContext);
        result.set("debugString", "OSGi context for bundle: " + bundleContext.getBundle().getSymbolicName());
        return result;
    }
}

