"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
const language_service_1 = require("@volar/language-service");
function register(htmlLs) {
    return (pugDoc, pos, options) => {
        const htmlPos = pugDoc.map.toGeneratedPosition(pos);
        if (!htmlPos)
            return;
        const htmlResult = htmlLs.doHover(pugDoc.map.virtualFileDocument, htmlPos, pugDoc.htmlDocument, options);
        if (!htmlResult)
            return;
        return language_service_1.transformer.asHover(htmlResult, htmlRange => pugDoc.map.toSourceRange(htmlRange));
    };
}
exports.register = register;
//# sourceMappingURL=hover.js.map