/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.rcp.nebula.grid;

import java.util.List;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.widgets.ItemInfo;
import org.eclipse.wb.internal.swt.support.RectangleSupport;

public final class GridItemInfo
extends ItemInfo {
    public GridItemInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
    }

    protected void refresh_fetch() throws Exception {
        Rectangle bounds = this.getComponentBounds();
        if (this.getParent() instanceof GridItemInfo) {
            GridItemInfo parent = (GridItemInfo)this.getParent();
            Rectangle parentBounds = parent.getComponentBounds();
            if (parent.getComponentExpanded().booleanValue()) {
                bounds.translate(-parentBounds.x, -parentBounds.y);
            } else {
                bounds = new Rectangle(parentBounds.x, parentBounds.height, parentBounds.width, 0);
            }
        }
        this.setModelBounds(bounds);
        super.refresh_fetch();
    }

    private Rectangle getComponentBounds() throws Exception {
        Rectangle bounds = this.getComponentCellsBounds();
        if (this.getComponentExpanded().booleanValue()) {
            List childItems = this.getChildren(GridItemInfo.class);
            for (GridItemInfo chilsItem : childItems) {
                bounds.union(chilsItem.getComponentBounds());
            }
        }
        return bounds;
    }

    private Rectangle getComponentCellsBounds() throws Exception {
        Object grid = ReflectionUtils.invokeMethod((Object)this.getObject(), (String)"getParent()", (Object[])new Object[0]);
        int columnCount = (Integer)ReflectionUtils.invokeMethod((Object)grid, (String)"getColumnCount()", (Object[])new Object[0]);
        Rectangle bounds = null;
        int i = 0;
        while (i < columnCount) {
            Object swtBounds = ReflectionUtils.invokeMethod((Object)this.getObject(), (String)"getBounds(int)", (Object[])new Object[]{i});
            if (bounds == null) {
                bounds = RectangleSupport.getRectangle((Object)swtBounds);
            } else {
                bounds.union(RectangleSupport.getRectangle((Object)swtBounds));
            }
            ++i;
        }
        return bounds;
    }

    private Boolean getComponentExpanded() throws Exception {
        return (Boolean)ReflectionUtils.invokeMethod((Object)this.getObject(), (String)"isExpanded()", (Object[])new Object[0]);
    }
}

