/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.tool;

import gnu.crypto.hash.HashFactory;
import gnu.crypto.hash.IMessageDigest;
import java.util.Iterator;

public final class HashSpeed {
    private HashSpeed() {
    }

    public static void main(String[] args) {
        if (args == null) {
            args = new String[]{};
        }
        switch (args.length) {
            case 0: {
                Iterator hit = HashFactory.getNames().iterator();
                while (hit.hasNext()) {
                    HashSpeed.speed((String)hit.next());
                }
                break;
            }
            default: {
                HashSpeed.speed(args[0]);
            }
        }
    }

    private static void speed(String name) {
        try {
            IMessageDigest hash = HashFactory.getInstance(name);
            HashSpeed.speed(hash);
        }
        catch (InternalError x) {
            System.out.println(name + ": Failed self-test...");
        }
    }

    private static void speed(IMessageDigest hash) {
        try {
            int iterations = 100000;
            int blocksize = 500;
            byte[] data = new byte[blocksize];
            int i = 0;
            while (i < blocksize) {
                data[i] = (byte)i;
                ++i;
            }
            System.out.print(hash.name() + ": Hashing " + String.valueOf(iterations) + " blocks of " + String.valueOf(blocksize) + " bytes each: ");
            long elapsed = -System.currentTimeMillis();
            i = 0;
            while (i < iterations) {
                hash.update(data, 0, blocksize);
                ++i;
            }
            float secs = (elapsed += System.currentTimeMillis()) > 1L ? (float)elapsed / 1000.0f : 1.0f;
            float speed = (float)iterations * (float)blocksize / 1024.0f / secs;
            System.out.println("time = " + secs + ", speed = " + speed + " KB/s");
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
        }
    }
}

