/*
 * Decompiled with CFR 0.152.
 */
package test.jce;

import gnu.crypto.hash.HashFactory;
import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.jce.GnuCrypto;
import gnu.crypto.util.Util;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOfMessageDigest
extends TestCase {
    static /* synthetic */ Class class$test$jce$TestOfMessageDigest;

    public TestOfMessageDigest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOfMessageDigest.suite());
    }

    public static Test suite() {
        return new TestSuite(class$test$jce$TestOfMessageDigest == null ? (class$test$jce$TestOfMessageDigest = TestOfMessageDigest.class$("test.jce.TestOfMessageDigest")) : class$test$jce$TestOfMessageDigest);
    }

    public void testUnknownHash() {
        try {
            MessageDigest.getInstance("Gaudot", "GNU-CRYPTO");
            Assert.fail((String)"testUnknownHash()");
        }
        catch (Exception x) {
            Assert.assertTrue((String)"testUnknownHash()", (boolean)true);
        }
    }

    public void testEquality() {
        IMessageDigest gnu = null;
        MessageDigest jce = null;
        byte[] in = ((Object)((Object)this)).getClass().getName().getBytes();
        Iterator it = HashFactory.getNames().iterator();
        while (it.hasNext()) {
            String mdName = (String)it.next();
            try {
                gnu = HashFactory.getInstance((String)mdName);
                Assert.assertNotNull((String)("HashFactory.getInstance(" + mdName + ")"), (Object)gnu);
            }
            catch (InternalError x) {
                Assert.fail((String)("HashFactory.getInstance(" + mdName + "): " + String.valueOf(x)));
            }
            try {
                jce = MessageDigest.getInstance(mdName, "GNU-CRYPTO");
                Assert.assertNotNull((String)"MessageDigest.getInstance()", (Object)jce);
            }
            catch (Exception x) {
                x.printStackTrace(System.err);
                Assert.fail((String)("MessageDigest.getInstance(" + mdName + "): " + String.valueOf(x)));
            }
            gnu.update(in, 0, in.length);
            byte[] ba1 = gnu.digest();
            byte[] ba2 = jce.digest(in);
            Assert.assertTrue((String)("testEquality(" + mdName + ")"), (boolean)Util.areEqual((byte[])ba1, (byte[])ba2));
        }
    }

    public void testCloneability() throws Exception {
        byte[] abc = "abc".getBytes();
        byte[] in = ((Object)((Object)this)).getClass().getName().getBytes();
        Iterator it = GnuCrypto.getMessageDigestNames().iterator();
        while (it.hasNext()) {
            String mdName = (String)it.next();
            MessageDigest md1 = MessageDigest.getInstance(mdName, "GNU-CRYPTO");
            md1.update(abc);
            MessageDigest md2 = (MessageDigest)md1.clone();
            byte[] ba1 = md1.digest(in);
            byte[] ba2 = md2.digest(in);
            Assert.assertTrue((String)("testCloneability(" + mdName + ")"), (boolean)Util.areEqual((byte[])ba1, (byte[])ba2));
        }
    }

    protected void setUp() {
        Security.addProvider((Provider)new GnuCrypto());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

