/*
 *  Orginal author: stigma.
 *  Rewrite: tican. (use <sys/sysinfo.h> insted of /proc/uptime)
 *
 *  Declarations for Syscriptor.
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/sysinfo.h>

void uptime(void)
{
	struct sysinfo info;
	int days, hours, minutes, seconds, uptime;

	puts("");
        printf("  UPTIME\n\n");

	if (sysinfo(&info) != -1) {
		uptime = info.uptime;
	} else {
		fprintf(stderr, "  Could not find your uptime\n");
		exit(EXIT_FAILURE);
	}

	days = (uptime / (3600*24));
	hours = (uptime%(3600*24) / 3600);
	minutes = (uptime%(3600*24) % 3600 / 60);
	seconds = (uptime%(3600*24) % 3600 % 60);

	printf("  ");
	if ( days > 0 ) {
		printf("%i day%s", days, days == 1?" ":"s ");
	}
	if ( hours > 0 ) {
		printf("%i hour%s", hours, hours == 1?" ":"s ");
	}
	if ( minutes > 0 ) {
		printf("%i minute%s", minutes, minutes == 1?" ":"s ");
	}
	if ( seconds > 0 ) {
		printf("and %i second%s", seconds, seconds == 1?" ":"s ");
	}

	puts("\n");
}

/* This file is absolute (?) */
