/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.GObject;
import org.gnu.glib.Type;
import org.gnu.glib.Handle;
import org.gnu.pango.FontDescription;

/**
 * A class that provides runtime routines for handling
 * resource files.
 */
public class RcStyle extends GObject 
{
	/**
	 * Construct a new RcStyle.
	 */
	public RcStyle() {
		super(gtk_rc_style_new());
	}
	
	/**
	 * Construct a new RcStyle from a given handle to a native resource.
	 */
	public RcStyle(Handle handle) {
		super(handle);
	}
	
    /**
     * Construct a new RcStyle from a given handle to a native resource.
     */
    public static RcStyle getRcStyle(Handle handle) {
        if (handle == null)
            return null;
        
        RcStyle obj = (RcStyle) getGObjectFromHandle(handle);
        if (obj == null)
            obj = new RcStyle(handle);
        
        return obj;
    }
    
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_rc_style_get_type());
	}
	
	public FontDescription getFontDescription() {
		return new FontDescription(getFontDesc(getHandle()));
	}
	
	public String getName(){
		return getName(getHandle());
	}
	

    native static final protected String getName (Handle cptr);
    native static final protected Handle getFontDesc (Handle cptr);
    native static final protected int getXthickness (Handle cptr);
    native static final protected int getYthickness (Handle cptr);
    native static final protected int gtk_rc_style_get_type ();
    native static final protected Handle gtk_rc_style_new ();
    native static final protected Handle gtk_rc_style_copy (Handle orig);
    native static final protected void gtk_rc_style_ref (Handle rc_style);
    native static final protected void gtk_rc_style_unref (Handle rc_style);

}

