/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <string.h>
#include "gtk_java.h"
#include <libebook/e-contact.h>
#include "org_gnu_libebook_EVCardAttributeParam.h"
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org_gnu_libebook_EVCardAttributeParam
 * Method:    e_vcard_attribute_param_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EVCardAttributeParam_e_1vcard_1attribute_1param_1new
(JNIEnv *env, jclass cls, jstring name)
{
    char* name_g = (char*)(*env)->GetStringUTFChars(env, name, 0);
    EVCardAttributeParam *evcardattribute = e_vcard_attribute_param_new(name_g);
    (*env)->ReleaseStringUTFChars(env, name, name_g);
    return getStructHandle(env, evcardattribute, (JGCopyFunc)e_vcard_attribute_param_copy, (JGFreeFunc)e_vcard_attribute_param_free);
}

/*
 * Class:     org_gnu_libebook_EVCardAttributeParam
 * Method:    e_vcard_attribute_param_copy
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EVCardAttributeParam_e_1vcard_1attribute_1param_1copy
(JNIEnv *env, jclass cls, jobject obj)
{
    //SC: test to ensure handle not same?
    EVCardAttributeParam *evcardattributeparam = e_vcard_attribute_param_copy((EVCardAttributeParam*)getPointerFromHandle(env, obj));
    return getStructHandle(env, evcardattributeparam, (JGCopyFunc)e_vcard_attribute_param_copy, (JGFreeFunc)e_vcard_attribute_param_free);
}

/*
 * Class:     org_gnu_libebook_EVCardAttributeParam
 * Method:    e_vcard_attribute_param_add_value
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EVCardAttributeParam_e_1vcard_1attribute_1param_1add_1value
(JNIEnv *env, jclass cls, jobject obj, jstring value)
{
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    EVCardAttributeParam *evcardattributeparam = (EVCardAttributeParam*)getPointerFromHandle(env, obj);
    e_vcard_attribute_param_add_value(evcardattributeparam, value_g);
    (*env)->ReleaseStringUTFChars(env, value, value_g);
}

/*
 * Class:     org_gnu_libebook_EVCardAttributeParam
 * Method:    e_vcard_attribute_param_remove_values
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EVCardAttributeParam_e_1vcard_1attribute_1param_1remove_1values
(JNIEnv *env, jclass cls, jobject obj)
{
    EVCardAttributeParam *evcardattributeparam = (EVCardAttributeParam*)getPointerFromHandle(env, obj);
    e_vcard_attribute_param_remove_values(evcardattributeparam);
}

/*
 * Class:     org_gnu_libebook_EVCardAttributeParam
 * Method:    e_vcard_attribute_param_get_name
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libebook_EVCardAttributeParam_e_1vcard_1attribute_1param_1get_1name
(JNIEnv *env, jclass cls, jobject obj)
{
    EVCardAttributeParam *evcardattributeparam = (EVCardAttributeParam*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, e_vcard_attribute_param_get_name(evcardattributeparam));
}

/*
 * Class:     org_gnu_libebook_EVCardAttributeParam
 * Method:    e_vcard_attribute_param_get_values
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_libebook_EVCardAttributeParam_e_1vcard_1attribute_1param_1get_1values
(JNIEnv *env, jclass cls, jobject obj) {
    EVCardAttributeParam *evcardattributeparam = (EVCardAttributeParam*)getPointerFromHandle(env, obj);
    GList *values = e_vcard_attribute_param_get_values(evcardattributeparam);
    GList *item;
    int i;
    gchar* value;
    jstring str;
    jobjectArray result;

    result = (*env)->NewObjectArray(env, g_list_length(values), (*env)->FindClass(env, "java/lang/String"), NULL);
    item = values;
    for (i = 0; item != NULL; item = item->next, ++i) {
        value = (gchar*)item->data;
        str = (*env)->NewStringUTF(env, value);
        (*env)->SetObjectArrayElement(env, result, i, str);
    }
    return result;
}

#ifdef __cplusplus
}

#endif
