/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 16:40:20 EDT
 */

package org.gnu.gdk;

import org.gnu.glib.Type;

/**
 *
 */
public class Pixmap extends Drawable 
{
	public Pixmap(Window window, int width, int height, int depth) {
		handle = gdk_pixmap_new(window.getHandle(), width, height, depth);
	}
	
	public Pixmap(Window window, byte[] data, int width, int height, int depth, Color fg, Color bg) {
		handle = gdk_pixmap_create_from_data(window.getHandle(), data, width, height, depth, fg.getHandle(), bg.getHandle());
	}
	
	public Pixmap(Window window, Bitmap mask, Color transparent, String filename) {
		handle = gdk_pixmap_create_from_xpm(window.getHandle(), mask.getHandle(), transparent.getHandle(), filename);
	}
	
	/**
	 * Construct a new Pixmap from a handle to a native resource.
	 * @param handle The handle to the native resource.
	 */
	public Pixmap(int handle){
		super(handle);
	}
	
	
	
	public static Type getType() {
		return new Type(gdk_pixmap_get_type());
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gdk_pixmap_get_type ();
    native static final protected int gdk_pixmap_new (int window, int width, int height, int depth);
    native static final protected int gdk_pixmap_create_from_data (int window, byte[] data, int 
        width, int height, int depth, int fg, int bg);
    native static final protected int gdk_pixmap_create_from_xpm (int window, int mask, int 
        transparentColor, String filename);
    native static final protected int gdk_pixmap_colormap_create_from_xpm (int window, int 
        colormap, int mask, int transparentColor, String filename);
    native static final protected int gdk_pixmap_create_from_xpm_d (int window, int mask, int 
        transparentColor, byte[] data);
    native static final protected int gdk_pixmap_colormap_create_from_xpm_d (int window, int 
        colormap, int mask, int transparentColor, byte[] data);
    native static final protected int gdk_pixmap_foreign_new (int anid);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

