/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_ActionGroup
#define _Included_org_gnu_gtk_ActionGroup
#ifdef __cplusplus
extern "C" {
#endif
/*
 * Class:     org_gnu_gtk_ActionGroup
 * Method:    gtk_action_group_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ActionGroup_gtk_1action_1group_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_action_group_get_type();
}

/*
 * Class:     org_gnu_gtk_ActionGroup
 * Method:    gtk_action_group_new
 * Signature: (Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ActionGroup_gtk_1action_1group_1new
  (JNIEnv *env, jclass cls, jstring name)
{
	const gchar* n = (*env)->GetStringUTFChars(env, name, NULL);
	jint ret = (jint)gtk_action_group_new(n);
	(*env)->ReleaseStringUTFChars(env, name, n);
	return ret;
}

/*
 * Class:     org_gnu_gtk_ActionGroup
 * Method:    gtk_action_group_get_name
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_ActionGroup_gtk_1action_1group_1get_1name
  (JNIEnv *env, jclass cls, jint group)
{
	const gchar* name = gtk_action_group_get_name((GtkActionGroup*)group);
	return (*env)->NewStringUTF(env, name);
}

/*
 * Class:     org_gnu_gtk_ActionGroup
 * Method:    gtk_action_group_get_action
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ActionGroup_gtk_1action_1group_1get_1action
  (JNIEnv *env, jclass cls, jint group, jstring name)
{
	const gchar* n = (*env)->GetStringUTFChars(env, name, NULL);
	jint ret = (jint)gtk_action_group_get_action((GtkActionGroup*)group, n);
	(*env)->ReleaseStringUTFChars(env, name, n);
	return ret;
}

/*
 * Class:     org_gnu_gtk_ActionGroup
 * Method:    gtk_action_group_list_actions
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_org_gnu_gtk_ActionGroup_gtk_1action_1group_1list_1actions
  (JNIEnv *env, jclass cls, jint group)
{
	GList *list = gtk_action_group_list_actions((GtkActionGroup*)group);
	if (NULL == list)
		return NULL;
	 guint len = g_list_length(list);
	 jintArray ar = (*env)->NewIntArray(env, len);
	 int i = 0;
	for (i = 0; i < len; i++) {
		GList *item = g_list_nth(list, i);
		(*env)->SetIntArrayRegion(env, ar, i, 1, (jint*)item->data);
	}
	return ar;
}

/*
 * Class:     org_gnu_gtk_ActionGroup
 * Method:    gtk_action_group_add_action
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ActionGroup_gtk_1action_1group_1add_1action
  (JNIEnv *env, jclass cls, jint group, jint action)
{
	gtk_action_group_add_action((GtkActionGroup*)group, (GtkAction*)action);
}

/*
 * Class:     org_gnu_gtk_ActionGroup
 * Method:    gtk_action_group_remove_action
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ActionGroup_gtk_1action_1group_1remove_1action
  (JNIEnv *env, jclass cls, jint group, jint action)
{
	gtk_action_group_remove_action((GtkActionGroup*)group, (GtkAction*)action);
}

/*
 * Class:     org_gnu_gtk_ActionGroup
 * Method:    gtk_action_group_add_actions
 * Signature: (I[II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ActionGroup_gtk_1action_1group_1add_1actions
  (JNIEnv *env, jclass cls, jint group, jintArray actions, jint num)
{
	GtkActionEntry* a = (GtkActionEntry*)(*env)->GetIntArrayElements(env, actions, NULL);
	gtk_action_group_add_actions((GtkActionGroup*)group, a, (guint)num, NULL);
	(*env)->ReleaseIntArrayElements (env, actions, (jint*)a, 0);
}

/*
 * Class:     org_gnu_gtk_ActionGroup
 * Method:    gtk_action_group_add_toggle_actions
 * Signature: (I[II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ActionGroup_gtk_1action_1group_1add_1toggle_1actions
  (JNIEnv *env, jclass cls, jint group, jintArray entries, jint num)
{
	GtkToggleActionEntry* e = (GtkToggleActionEntry*)(*env)->GetIntArrayElements(env, entries, NULL);
	gtk_action_group_add_toggle_actions((GtkActionGroup*)group, e, (guint)num, NULL);
	(*env)->ReleaseIntArrayElements (env, entries, (jint*)e, 0);
}

/*
 * Class:     org_gnu_gtk_ActionGroup
 * Method:    gtk_action_group_set_translation_domain
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ActionGroup_gtk_1action_1group_1set_1translation_1domain
  (JNIEnv *env, jclass cls, jint group, jstring domain)
{
	const gchar* d = (*env)->GetStringUTFChars(env, domain, NULL);
	gtk_action_group_set_translation_domain((GtkActionGroup*)group, d);
	(*env)->ReleaseStringUTFChars(env, domain, d);
}

#ifdef __cplusplus
}
#endif
#endif
