/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 11:32:42 EDT
 */

package org.gnu.gtk;
import org.gnu.glib.GObject;
import org.gnu.glib.Type;

/**
 * Class that provides the ability to group several Windows together.
 */
public class WindowGroup extends GObject 
{
	/**
	 * Construct a new WindowGroup
	 */
	public WindowGroup() {
		handle = WindowGroup.gtk_window_group_new();
	}
	
	/**
	 * Add a Window to this WindowGroup
	 * 
	 * @param window The Window to be added to this WindowGroup
	 */
	public void addWindow(Window window) {
		WindowGroup.gtk_window_group_add_window(handle, window.getHandle());
	}
	
	/**
	 * Remove a Window from this WindowGroup
	 *
	 * @param window The Window to be removed from this WindowGroup.
	 */
	public void removeWindow(Window window) {
		WindowGroup.gtk_window_group_remove_window(handle, window.getHandle());
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_window_group_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_window_group_get_type ();
    native static final protected int gtk_window_group_new ();
    native static final protected void gtk_window_group_add_window (int windowGroup, int window);
    native static final protected void gtk_window_group_remove_window (int windowGroup, int window);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

