/*
 * Java-Gnome Bindings Library
 *
 * * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

import org.gnu.glib.EventType;

/**
 * This event is used to identify when a dialog receives an event
 * 
 * @see DialogListener
 */
public class DialogEvent extends GtkEvent {

	public static class Type extends EventType {
		private Type(int id, String name) {
			super(id, name);
		}

		/**
		 * This event indicates that the source dialog has closed.
		 */
		public static final Type CLOSE = new Type(1, "CLOSE");

		/**
		 * This event is emitted when an action widget is clicked or the
		 * dialog receives a "delete" event.  On a delete event, the 
		 * response ID is RESPONSE_NONE.  Otherwise it depends on what
		 * the user selected.
		 */
		public static final Type RESPONSE = new Type(2, "RESPONSE");
	}

	/**
	 * The response ID that is returned when the RESPONSE event
	 * is emitted.
	 */
	private int response;

	/**
	 * Constructor for DialogEvent.
	 * @param source
	 * @param type
	 */
	public DialogEvent(Object source, EventType type) {
		super(source, type);
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(DialogEvent.Type aType) {
		return (type.getID() == aType.getID());
	}

	/**
	 * Return the response ID for a RESPONSE event.
	 */
	public int getResponse() {
		return response;
	}

	/**
	 * Set the response ID for this event.
	 */
	public void setResponse(int response) {
		this.response = response;
	}
}
