dnl Copyright (C) 1993-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible, Marcus Daniels.

AC_PREREQ(2.13)

AC_DEFUN([CL_SHELLARGS],
[AC_REQUIRE([AC_PROG_CC])dnl
AC_CACHE_CHECK([for broken HP/UX, A/UX, OSF/1 and NeXTstep shell], cl_cv_prog_sh_broken, [
if test $cross_compiling = no; then
# A program that outputs its argument count:
cat > conftest.c <<EOF
#include "confdefs.h"
#include <stdio.h>
#ifdef __cplusplus
extern "C" void exit(int);
#endif
#if defined(__STDC__) || defined(__cplusplus)
int main (int argc, char** argv)
#else
int main (argc,argv) int argc; char** argv;
#endif
{ printf("%d\n",argc); exit(0); }
EOF
AC_TRY_EVAL(ac_link)
# How can a shell script forward its arguments to another program?
#                                    $ * "$ *" "$ @"
# conftest.sh                         1    2     1 (*)
# conftest.sh foo                     2    2     2
# conftest.sh foo bar                 3    2     3
# conftest.sh "foo bar"               3    2     2
# (*): 2 with HP-UX /bin/sh. We must use /bin/ksh instead.
#      2 as well with NeXTstep /bin/sh. No /bin/ksh. Examine $# first.
psubs='"$''@"'
cat > conftest.sh <<EOF
#!/bin/sh
exec ./conftest $psubs
EOF
chmod a+x conftest.sh
if test `./conftest.sh` = "1"; then
  cl_cv_prog_sh_broken=no
  cl_cv_prog_sh_good='/bin/sh'
else
  cl_cv_prog_sh_broken=yes
  if test -x /bin/ksh; then
    cl_cv_prog_sh_good='/bin/ksh'
  else
    cl_cv_prog_sh_good=''
  fi
fi
else
cl_cv_prog_sh_broken="guessing no"
cl_cv_prog_sh_good='/bin/sh'
fi
rm -f conftest*
])
GOOD_SH="$cl_cv_prog_sh_good"
if test "$GOOD_SH" = '/bin/ksh'; then
  AC_DEFINE(UNIX_USE_KSH)
fi
if test "$GOOD_SH" = ''; then
  AC_DEFINE(UNIX_BROKEN_SH)
fi
AC_SUBST(GOOD_SH)dnl
])
