/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.bool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PointsSorter {
    private static final int LIMIT_TO_SAVE = 0x1000000;
    private static final int LIMIT_TO_SPLIT = 0x2000000;
    int pointsOut;
    long[] points = new long[1];
    int pointsInFiles;
    List<File> files = new ArrayList<File>();
    DataInputStream[] inps;
    long[] inpH;
    int curPoint;
    int[] outA = new int[2];
    int outC;
    ScanLine outS = new ScanLine();
    boolean fixed;

    public void put(int lx, int ly, int hx, int hy) {
        this.put(lx, ly, true);
        this.put(lx, hy, false);
        this.put(hx, ly, false);
        this.put(hx, hy, true);
    }

    public void put(int x, int y, boolean positive) {
        this.fixed = false;
        if (this.pointsOut >= this.points.length) {
            if (this.pointsOut >= 0x2000000) {
                this.saveToFile();
                assert (this.pointsOut == 0);
            } else {
                long[] newPoints = new long[this.points.length * 2];
                System.arraycopy(this.points, 0, newPoints, 0, this.points.length);
                this.points = newPoints;
            }
        }
        if (x == Integer.MAX_VALUE || y < -1073741824 || y > 0x3FFFFFFF) {
            throw new IllegalArgumentException();
        }
        long p = (long)x << 32 | (long)(y + 0x40000000 << 1) & 0xFFFFFFFEL;
        if (positive) {
            p |= 1L;
        }
        this.points[this.pointsOut] = p;
        ++this.pointsOut;
    }

    public ScanLine fix() {
        if (!this.fixed) {
            if (!(this.pointsOut == 0 || this.files.isEmpty() && this.pointsOut <= 0x1000000)) {
                this.saveToFile();
            } else {
                Arrays.sort(this.points, 0, this.pointsOut);
            }
            this.fixed = true;
        }
        try {
            return this.files.isEmpty() ? this.getFromArray() : this.getFromStreams();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void saveToFile() {
        try {
            Arrays.sort(this.points, 0, this.pointsOut);
            File file = File.createTempFile("Electric", "DRC");
            file.deleteOnExit();
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            for (int i = 0; i < this.pointsOut; ++i) {
                out.writeLong(this.points[i]);
            }
            out.writeLong(Long.MAX_VALUE);
            out.close();
            this.files.add(file);
            this.pointsInFiles += this.pointsOut;
            this.pointsOut = 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int size() {
        return this.pointsInFiles + this.pointsOut;
    }

    void putOutBuf(int y, int d) {
        if (d == 0) {
            return;
        }
        if (this.outC * 2 >= this.outA.length) {
            int[] newOutA = new int[this.outA.length * 2];
            System.arraycopy(this.outA, 0, newOutA, 0, this.outA.length);
            this.outA = newOutA;
        }
        this.outA[this.outC * 2 + 0] = y;
        this.outA[this.outC * 2 + 1] = d;
        ++this.outC;
    }

    void reset() {
        this.curPoint = 0;
    }

    ScanLine getFromArray() {
        this.outC = 0;
        int curX = 0;
        int curY = 0;
        int curD = 0;
        while (this.curPoint < this.pointsOut) {
            int d;
            long p = this.points[this.curPoint];
            int x = (int)(p >> 32);
            int y = Integer.MIN_VALUE + (int)p >> 1;
            int n = d = (p & 1L) != 0L ? 1 : -1;
            if (this.outC == 0 && curD == 0) {
                curX = x;
                curY = y;
                curD = d;
            } else {
                if (x != curX) {
                    this.putOutBuf(curY, curD);
                    assert (this.outC != 0);
                    this.outS.x = curX;
                    this.outS.y = this.outA;
                    this.outS.len = this.outC;
                    return this.outS;
                }
                if (y != curY) {
                    this.putOutBuf(curY, curD);
                    curY = y;
                    curD = d;
                } else {
                    curD += d;
                }
            }
            ++this.curPoint;
        }
        if (this.outC == 0 && curD == 0) {
            return null;
        }
        this.putOutBuf(curY, curD);
        assert (this.outC != 0);
        this.outS.x = curX;
        this.outS.y = this.outA;
        this.outS.len = this.outC;
        return this.outS;
    }

    ScanLine getFromStreams() throws IOException {
        if (this.inps == null) {
            this.inps = new DataInputStream[this.files.size()];
            this.inpH = new long[this.files.size()];
            for (int i = 0; i < this.files.size(); ++i) {
                DataInputStream inp;
                this.inps[i] = inp = new DataInputStream(new BufferedInputStream(new FileInputStream(this.files.get(i))));
                this.inpH[i] = inp.readLong();
                inp.close();
            }
        }
        this.outC = 0;
        int curX = 0;
        int curY = 0;
        int curD = 0;
        long minL = Long.MAX_VALUE;
        int minI = -1;
        for (int i = 0; i < this.inpH.length; ++i) {
            if (this.inpH[i] >= minL) continue;
            minL = this.inpH[i];
            minI = i;
        }
        while (minL != Long.MAX_VALUE) {
            long l;
            int d;
            long p = minL;
            int x = (int)(p >> 32);
            int y = Integer.MIN_VALUE + (int)p >> 1;
            int n = d = (p & 1L) != 0L ? 1 : -1;
            if (this.outC == 0 && curD == 0) {
                curX = x;
                curY = y;
                curD = d;
            } else {
                if (x != curX) {
                    this.putOutBuf(curY, curD);
                    assert (this.outC != 0);
                    this.outS.x = curX;
                    this.outS.y = this.outA;
                    this.outS.len = this.outC;
                    return this.outS;
                }
                if (y != curY) {
                    this.putOutBuf(curY, curD);
                    curY = y;
                    curD = d;
                } else {
                    curD += d;
                }
            }
            ++this.curPoint;
            this.inpH[minI] = l = this.inps[minI].readLong();
            if (l == Long.MAX_VALUE) {
                this.inps[minI].close();
                this.files.get(minI).delete();
                this.inps[minI] = null;
            }
            minL = Long.MAX_VALUE;
            minI = -1;
            for (int i = 0; i < this.inpH.length; ++i) {
                if (this.inpH[i] >= minL) continue;
                minL = this.inpH[i];
                minI = i;
            }
        }
        if (this.outC == 0 && curD == 0) {
            return null;
        }
        this.putOutBuf(curY, curD);
        assert (this.outC != 0);
        this.outS.x = curX;
        this.outS.y = this.outA;
        this.outS.len = this.outC;
        return this.outS;
    }

    public static class ScanLine {
        public int x;
        public int[] y;
        public int len;
    }
}

