/***************************************************************************
 *   Copyright (C) 2011 by Francesco Nwokeka <francesco.nwokeka@gmail.com> *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA            *
 ***************************************************************************/

/**
  This component shows text that, when clicked, can be edited
  */

import Qt 4.7
import org.kde.plasma.core 0.1 as PlasmaCore
import org.kde.plasma.graphicswidgets 0.1 as PlasmaWidgets

Item {
    id: textEditItem;

    property bool boldText: false;
    property bool italicText: false;
    property string editableText;

    signal textChanged(variant newText);

    // get color from current plasma theme
    property QtObject theme: PlasmaCore.Theme {}

    // show & edit
    state: "show";

    Text {
        id: shownText;
        color: theme.textColor;
        elide: "ElideRight";
        wrapMode: Text.WrapAnywhere;

        font {
            bold: boldText;
            italic: italicText;
            pixelSize: textEditItem.height/2;
        }

        text: editableText;
        anchors.fill: parent;

        MouseArea {
            anchors.fill: parent;

            onClicked: {
                editText.text = editableText;
                textEditItem.state = "edit";
            }
        }
    }

    PlasmaWidgets.LineEdit {
        id: editText;
        width: parent.width - 30;
        anchors.left: parent.left;
        clearButtonShown: true;

        onReturnPressed: {
            editableText = editText.text;
            textEditItem.state = "show";

            // emit "new text" signal
            textEditItem.textChanged(editableText);
        }
    }

    // cancel "edit" button
    PlasmaWidgets.IconWidget {
        id: editCancelButton;
        height: parent.height;
        width: parent.height;

        anchors {
            left: editText.right;
            leftMargin: 2;
            right: parent.right;
        }

        Component.onCompleted: {
            setIcon("edit-delete");
        }

        onClicked: {
            editText.text = editableText;
            textEditItem.state = "show";
        }
    }

    states: [
        State {
            name: "show";
            PropertyChanges {
                target: editText;
                opacity: 0;
            }
            PropertyChanges {
                target: shownText;
                opacity: 1;
            }
            PropertyChanges {
                target: editCancelButton;
                opacity: 0;
            }
        },
        State {
            name: "edit";
            PropertyChanges {
                target: editText;
                opacity: 1;
                focus: true;
            }
            PropertyChanges {
                target: shownText;
                opacity: 0;
            }
            PropertyChanges {
                target: editCancelButton;
                opacity: 1;
            }
        }
    ]

    transitions: [
        Transition {
            PropertyAnimation {
                    properties: "color,opacity";
                    duration: 400;
                }
            }
    ]
}
