/***************************************************************************
 *   Copyright (C) 2011 by Francesco Nwokeka <francesco.nwokeka@gmail.com> *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA            *
 ***************************************************************************/

import Qt 4.7
import org.kde.plasma.core 0.1 as PlasmaCore
import org.kde.plasma.graphicswidgets 0.1 as PlasmaWidgets

Item {
    id: presenceIcon;

    height: 22;
    width: 22;

    property int presenceId;
    property string presenceStatusText;
    property string iconName;

    signal clicked();

    // get color from current plasma theme
    property QtObject theme: PlasmaCore.Theme {}

    Item {
        id: iconContainer;

        anchors.fill: parent;

        PlasmaWidgets.IconWidget {
            id: presencePlasmaIconWidget
            anchors.fill: parent;
            Component.onCompleted: {
                setPresenceIcon(iconName);
            }
        }

        MouseArea {
            anchors.fill: parent;
            onClicked: {
                // emit clicked signal
                presenceIcon.clicked();
            }
        }
    }

    Text {
        id: presenceText;
        text:  presenceStatusText;
        anchors.left: iconContainer.right;
        anchors.leftMargin: 5;
        color: theme.textColor;
    }

    function setPresenceIcon(presenceType)
    {
        iconName = presenceType;

        // special case. DataEngine gives me "available" but kde icon is "user-online"
        if (iconName == "available") {
            presencePlasmaIconWidget.setIcon("user-online");
        } else {
            presencePlasmaIconWidget.setIcon("user-" + iconName);
        }
    }
}
