/* $PostgreSQL: pgsql/contrib/pgstattuple/pgstattuple.sql.in,v 1.15 2007/11/13 04:24:28 momjian Exp $ */

-- Adjust this setting to control where the objects get created.
SET search_path = public;

CREATE OR REPLACE FUNCTION pgstattuple(IN relname text,
    OUT table_len BIGINT,		-- physical table length in bytes
    OUT tuple_count BIGINT,		-- number of live tuples
    OUT tuple_len BIGINT,		-- total tuples length in bytes
    OUT tuple_percent FLOAT,		-- live tuples in %
    OUT dead_tuple_count BIGINT,	-- number of dead tuples
    OUT dead_tuple_len BIGINT,		-- total dead tuples length in bytes
    OUT dead_tuple_percent FLOAT,	-- dead tuples in %
    OUT free_space BIGINT,		-- free space in bytes
    OUT free_percent FLOAT)		-- free space in %
AS '$libdir/pgstattuple', 'pgstattuple'
LANGUAGE C STRICT;

CREATE OR REPLACE FUNCTION pgstattuple(IN reloid oid,
    OUT table_len BIGINT,		-- physical table length in bytes
    OUT tuple_count BIGINT,		-- number of live tuples
    OUT tuple_len BIGINT,		-- total tuples length in bytes
    OUT tuple_percent FLOAT,		-- live tuples in %
    OUT dead_tuple_count BIGINT,	-- number of dead tuples
    OUT dead_tuple_len BIGINT,		-- total dead tuples length in bytes
    OUT dead_tuple_percent FLOAT,	-- dead tuples in %
    OUT free_space BIGINT,		-- free space in bytes
    OUT free_percent FLOAT)		-- free space in %
AS '$libdir/pgstattuple', 'pgstattuplebyid'
LANGUAGE C STRICT;

--
-- pgstatindex
--
CREATE OR REPLACE FUNCTION pgstatindex(IN relname text,
    OUT version int4,
    OUT tree_level int4,
    OUT index_size int4,
    OUT root_block_no int4,
    OUT internal_pages int4,
    OUT leaf_pages int4,
    OUT empty_pages int4,
    OUT deleted_pages int4,
    OUT avg_leaf_density float8,
    OUT leaf_fragmentation float8)
AS '$libdir/pgstattuple', 'pgstatindex'
LANGUAGE C STRICT;

--
-- pg_relpages()
--
CREATE OR REPLACE FUNCTION pg_relpages(text)
RETURNS int
AS '$libdir/pgstattuple', 'pg_relpages'
LANGUAGE C STRICT;
