import QtQuick
import QtQuick3D
import Generated.QtQuick3D.AdasPlane 1.0
Model {
    id: adasBase
    property bool night: false
    property color nightColor: "#0a430f"
    property color dayColor: "#63c173"
    rotation: Qt.quaternion(0.707107, -0.707107, 0, 0)
    scale.x: 100
    scale.y: 100
    scale.z: 100
    source: "meshes/plane.mesh"

    DefaultMaterial {
        id: green_material

        lighting: DefaultMaterial.NoLighting
        diffuseColor: "#2fc74a"
    }

    DefaultMaterial {
        id: white_material

        lighting: DefaultMaterial.NoLighting
        diffuseColor: "white"
        opacity: mainScreen.state === "Adas2" ? 1.0 : 0.0
        Behavior on opacity { NumberAnimation { duration: 1000 } }
    }
    materials: [
        green_material,
        white_material
    ]
    states: [
        State {
            name: "night"
            when: night == true

            PropertyChanges {
                target: green_material
                diffuseColor: nightColor
            }
        },
        State {
            name: "day"
            when: night == false

            PropertyChanges {
                target: green_material
                diffuseColor: dayColor
            }
        }
    ]
    transitions: Transition {
                    ColorAnimation {
                        properties: "diffuseColor"
                        easing.type: Easing.InOutQuad
                        duration: 2000
                    }
                }
}
