import QtQuick
import QtQuick3D
import Generated.QtQuick3D.Car2 1.0
import Generated.QtQuick3D.Tire_for_dummy_car 1.0
Node {
    id: rootNode
    property bool nightmode: false
    property Texture specularRefletionTexture
    property real tireRotation: 0
    property real tireRotationLeftover: 0
    property bool charge: false
    property real batteryCharge: 1

    Model {
        id: car
        y: 68.4602
        z: 122.956
        rotation: Qt.quaternion(0.717703, -0.69635, 0, 0)
        source: "../Car2/meshes/car.mesh"

        DefaultMaterial {
            id: defaultMaterial1
            specularReflectionMap: automotive4
            diffuseColor: "#2a3939"

            Texture {
                id: automotive4
                source: "../../../images/automotive4.hdr"
                mappingMode: Texture.LightProbe
            }
        }
        materials: [defaultMaterial1,defaultMaterial1]
    }
    Model {
        id: car_Shadow
        x: -0.609
        y: -0
        rotation: Qt.quaternion(0.707107, -0.707107, 0, 0)
        source: "meshes/car_Shadow.mesh"
        z: -12.65171
        scale.z: 1
        scale.y: 0.78578
        scale.x: 0.89803

        DefaultMaterial {
            id: defaultMaterial_material
            opacity: 0.7
            opacityMap: glowdot
            diffuseColor: "#101010"

            Texture {
                id: glowdot
                source: "../../../images/groundshadow.png"
            }
        }
        materials: [
            defaultMaterial_material
        ]
    }

    Model {
        id: wheel1
        x: 67.566
        y: 24
        source: "../Tire_for_dummy_car/meshes/tire_for_dummy_car.mesh"
        materials: defaultMaterial1
        eulerRotation.z: 0
        eulerRotation.y: 180
        eulerRotation.x: (mainScreen.state != "chargeUp"
                          && mainScreen.state != "chargeSide"
                          && mainScreen.state != "chargeBehind")
                         ? (car_Optimized_2.tireRotation + car_Optimized_2.tireRotationLeftover) : 0
        z: 69.03677

        DefaultMaterial {
            id: defaultMaterial
            specularTint: "#dddddd"
            specularRoughness: 1
            indexOfRefraction: 3
            diffuseColor: "#5d5d5d"
        }
    }

    Model {
        id: wheel2
        x: 65.436
        y: 24
        source: "../Tire_for_dummy_car/meshes/tire_for_dummy_car.mesh"
        materials: defaultMaterial1
        eulerRotation.y: 180
        eulerRotation.x: (mainScreen.state != "chargeUp"
                          && mainScreen.state != "chargeSide"
                          && mainScreen.state != "chargeBehind")
                         ? (car_Optimized_2.tireRotation + car_Optimized_2.tireRotationLeftover) : 0
        z: -89.49499
    }

    Model {
        id: wheel3
        x: -70.488
        y: 24
        source: "../Tire_for_dummy_car/meshes/tire_for_dummy_car.mesh"
        materials: defaultMaterial1
        eulerRotation.x: (mainScreen.state != "chargeUp"
                          && mainScreen.state != "chargeSide"
                          && mainScreen.state != "chargeBehind")
                         ? -(car_Optimized_2.tireRotation + car_Optimized_2.tireRotationLeftover) : 0
        z: -89.49498
    }

    Model {
        id: wheel4
        x: -68.693
        y: 24
        source: "../Tire_for_dummy_car/meshes/tire_for_dummy_car.mesh"
        materials: defaultMaterial1
        eulerRotation.z: 0
        eulerRotation.x: (mainScreen.state != "chargeUp"
                          && mainScreen.state != "chargeSide"
                          && mainScreen.state != "chargeBehind")
                         ? -(car_Optimized_2.tireRotation + car_Optimized_2.tireRotationLeftover) : 0
        eulerRotation.y: 0
        z: 69.01599
    }
    states: [
        State {
            name: "day"
            when: nightmode == false

            PropertyChanges {
                target: defaultMaterial1
                diffuseColor: "#3d4c4c"
            }

            PropertyChanges {
                target: car_Shadow
                receivesShadows: false
                castsShadows: false
            }
        },
        State {
            name: "night"
            when: nightmode == true

            PropertyChanges {
                target: automotive4
                source: "../../../images/automotive4.hdr"
            }

            PropertyChanges {
                target: car
                materials: defaultMaterial1
            }

            PropertyChanges {
                target: defaultMaterial1
                diffuseColor: "#362c5b"
            }
        }
    ]

}
