import QtQuick
import QtQuick3D
import Generated.QtQuick3D.Demo_City_Ground_new 1.0
Node {
    id: rootNode
    property bool night: false
    Model {
        id: demo_City_Ground
        y: -24.2705
        opacity: 1
        rotation: Qt.quaternion(0.707107, -0.707107, 0, 0)
        scale.x: 100
        scale.y: 721.27802
        scale.z: 100
        source: "../Demo_City_Ground_new/meshes/demo_City_Ground_new.mesh"

        DefaultMaterial {
            id: material_002_material
            opacity: 1
            specularReflectionMap: car_ref1
            opacityChannel: Material.A
            lighting: DefaultMaterial.FragmentLighting
            blendMode: DefaultMaterial.SourceOver
            depthDrawMode: Material.NeverDepthDraw
            specularTint: "#d49d9d"
            specularAmount: 1
            diffuseColor: "#bc91d1"

            Texture {
                id: car_ref1
                source: "../../../images/pulse.jpg"
                mappingMode: Texture.LightProbe
            }
        }
        materials: [
            material_002_material
        ]
    }
    states: [
        State {
            name: "day"
            when: !globalNightMode

            PropertyChanges {
                target: material_002_material
                depthDrawMode: Material.AlwaysDepthDraw
                cullMode: Material.BackFaceCulling
            }

            PropertyChanges {
                target: demo_City_Ground
                opacity: 0.6
            }

            PropertyChanges {
                target: car_ref1
                mappingMode: Texture.LightProbe
            }
        },
        State {
            name: "night"
            when: globalNightMode

            PropertyChanges {
                target: material_002_material
                emissiveFactor: "0"
                specularRoughness: 0.001
                fresnelPower: 0
                specularAmount: 1
                specularTint: "#120c21"
                depthDrawMode: Material.AlwaysDepthDraw
                cullMode: Material.BackFaceCulling
                diffuseColor: "#040406"
            }

            PropertyChanges {
                target: demo_City_Ground
                opacity: 0.6
                visible: true
            }
        }
    ]
    transitions: Transition {
                        ColorAnimation {
                            properties: "diffuseColor"
                            easing.type: Easing.InOutQuad
                            duration: 2000
                        }
                    }
}
