/*
 * Decompiled with CFR 0.152.
 */
package rath.msnm;

import rath.msnm.BuddyList;
import rath.msnm.GroupList;

public class BuddyGroup {
    public static final int FORWARD = 1;
    public static final int ALLOW = 2;
    public static final int BLOCK = 4;
    public static final int REVERSE = 8;
    public static final int NEWBIE = 16;
    private final BuddyList listForward = new BuddyList("FL");
    private final BuddyList listAllow = new BuddyList("AL");
    private final BuddyList listBlock = new BuddyList("BL");
    private final BuddyList listReverse = new BuddyList("RL");
    private final BuddyList listAll = new BuddyList("LST");
    private final GroupList groupList = new GroupList();

    protected BuddyGroup() {
    }

    public GroupList getGroupList() {
        return this.groupList;
    }

    public BuddyList getAllList() {
        return this.listAll;
    }

    public BuddyList getForwardList() {
        return this.listForward;
    }

    public BuddyList getAllowList() {
        return this.listAllow;
    }

    public BuddyList getBlockList() {
        return this.listBlock;
    }

    public BuddyList getReverseList() {
        return this.listReverse;
    }

    public static boolean isListForward(int id) {
        return (id & 1) == 1;
    }

    public static boolean isListAllow(int id) {
        return (id & 2) == 2;
    }

    public static boolean isListBlock(int id) {
        return (id & 4) == 4;
    }

    public static boolean isListReverse(int id) {
        return (id & 8) == 8;
    }

    public static boolean isNewbie(int id) {
        return (id & 0x10) == 16;
    }

    public BuddyList getListAsCode(String code) {
        if (code.equals("FL")) {
            return this.listForward;
        }
        if (code.equals("AL")) {
            return this.listAllow;
        }
        if (code.equals("BL")) {
            return this.listBlock;
        }
        if (code.equals("RL")) {
            return this.listReverse;
        }
        return null;
    }

    public void clear() {
        this.listAllow.clear();
        this.listBlock.clear();
        this.listForward.clear();
        this.listReverse.clear();
    }

    public static BuddyGroup getInstance() {
        return new BuddyGroup();
    }
}

