/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdOpener;
import org.jrobin.graph.ChartPanel;
import org.jrobin.graph.ExportData;
import org.jrobin.graph.GifEncoder;
import org.jrobin.graph.Grapher;
import org.jrobin.graph.JpegImageWriteParam;
import org.jrobin.graph.RrdGraphDef;

public class RrdGraph
extends RrdOpener
implements Serializable {
    private Grapher grapher;
    private BufferedImage img;
    private boolean useImageSize = false;

    public RrdGraph() {
        super(false, true);
    }

    public RrdGraph(boolean bl) {
        super(bl, true);
    }

    public RrdGraph(RrdGraphDef rrdGraphDef) {
        this(rrdGraphDef, false);
    }

    public RrdGraph(RrdGraphDef rrdGraphDef, boolean bl) {
        super(bl, true);
        this.grapher = new Grapher(rrdGraphDef, this);
    }

    public void specifyImageSize(boolean bl) {
        this.useImageSize = bl;
    }

    public void setGraphDef(RrdGraphDef rrdGraphDef) {
        this.img = null;
        this.grapher = new Grapher(rrdGraphDef, this);
    }

    public void saveAsPNG(String string) throws RrdException, IOException {
        this.saveAsPNG(string, 0, 0);
    }

    public void saveAsPNG(String string, int n, int n2) throws RrdException, IOException {
        File file = new File(string);
        if (this.shouldGenerate(file)) {
            ImageIO.write((RenderedImage)this.getBufferedImage(n, n2, 1), "png", file);
        }
    }

    public void saveAsGIF(String string) throws RrdException, IOException {
        this.saveAsGIF(string, 0, 0);
    }

    public void saveAsGIF(String string, int n, int n2) throws RrdException, IOException {
        File file = new File(string);
        if (this.shouldGenerate(file)) {
            GifEncoder gifEncoder = new GifEncoder(this.getBufferedImage(n, n2, 13));
            FileOutputStream fileOutputStream = new FileOutputStream(string, false);
            gifEncoder.encode(fileOutputStream);
            fileOutputStream.close();
        }
    }

    public void saveAsJPEG(String string, float f) throws RrdException, IOException {
        this.saveAsJPEG(string, 0, 0, f);
    }

    public void saveAsJPEG(String string, int n, int n2, float f) throws RrdException, IOException {
        File file = new File(string);
        if (!this.shouldGenerate(file)) {
            return;
        }
        BufferedImage bufferedImage = this.getBufferedImage(n, n2, 1);
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpg");
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(new File(string));
        imageWriter.setOutput(imageOutputStream);
        JpegImageWriteParam jpegImageWriteParam = new JpegImageWriteParam();
        jpegImageWriteParam.setCompressionMode(2);
        ((ImageWriteParam)jpegImageWriteParam).setCompressionQuality(f);
        imageWriter.write(null, new IIOImage(bufferedImage, null, null), jpegImageWriteParam);
        imageOutputStream.flush();
        imageWriter.dispose();
        imageOutputStream.close();
    }

    public byte[] getPNGBytes() throws IOException, RrdException {
        return this.getPNGBytes(0, 0);
    }

    public byte[] getPNGBytes(int n, int n2) throws IOException, RrdException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)this.getBufferedImage(n, n2, 1), "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getJPEGBytes(float f) throws IOException, RrdException {
        return this.getJPEGBytes(0, 0, f);
    }

    public byte[] getJPEGBytes(int n, int n2, float f) throws IOException, RrdException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedImage bufferedImage = this.getBufferedImage(n, n2, 1);
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpg");
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
        imageWriter.setOutput(imageOutputStream);
        JpegImageWriteParam jpegImageWriteParam = new JpegImageWriteParam();
        jpegImageWriteParam.setCompressionMode(2);
        ((ImageWriteParam)jpegImageWriteParam).setCompressionQuality(f);
        imageWriter.write(null, new IIOImage(bufferedImage, null, null), jpegImageWriteParam);
        imageOutputStream.flush();
        imageWriter.dispose();
        imageOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getGIFBytes() throws RrdException, IOException {
        return this.getGIFBytes(0, 0);
    }

    public byte[] getGIFBytes(int n, int n2) throws RrdException, IOException {
        BufferedImage bufferedImage = this.getBufferedImage(n, n2, 13);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GifEncoder gifEncoder = new GifEncoder(bufferedImage);
        gifEncoder.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public BufferedImage getBufferedImage(int n, int n2) throws IOException, RrdException {
        return this.getBufferedImage(n, n2, 1);
    }

    public ChartPanel getChartPanel() throws RrdException, IOException {
        ChartPanel chartPanel = new ChartPanel();
        chartPanel.setChart(this.getBufferedImage(0, 0, 1));
        return chartPanel;
    }

    public void renderImage(Graphics2D graphics2D, int n, int n2) throws RrdException, IOException {
        if (this.useImageSize) {
            this.grapher.renderImage(n, n2, graphics2D, true);
        } else {
            this.grapher.renderImage(n, n2, graphics2D, false);
        }
    }

    public ExportData getExportData() throws RrdException {
        return this.grapher.createExportData();
    }

    public ExportData fetchExportData() throws RrdException, IOException {
        return this.grapher.fetch(400);
    }

    public ExportData fetchExportData(int n) throws RrdException, IOException {
        return this.grapher.fetch(n);
    }

    private boolean shouldGenerate(File file) throws RrdException, IOException {
        if (!file.exists()) {
            return true;
        }
        return this.grapher.shouldGenerate(file.lastModified());
    }

    private BufferedImage getBufferedImage(int n, int n2, int n3) throws RrdException, IOException {
        this.img = this.useImageSize ? this.grapher.createImageGlobal(n, n2, n3) : this.grapher.createImage(n, n2, n3);
        return this.img;
    }
}

