/**
 * Autogenerated by Thrift Compiler (0.19.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#include "parquet_types.h"

#include <algorithm>
#include <ostream>

#include <thrift/TToString.h>

namespace parquet { namespace format {

int _kTypeValues[] = {
  Type::BOOLEAN,
  Type::INT32,
  Type::INT64,
  Type::INT96,
  Type::FLOAT,
  Type::DOUBLE,
  Type::BYTE_ARRAY,
  Type::FIXED_LEN_BYTE_ARRAY
};
const char* _kTypeNames[] = {
  "BOOLEAN",
  "INT32",
  "INT64",
  "INT96",
  "FLOAT",
  "DOUBLE",
  "BYTE_ARRAY",
  "FIXED_LEN_BYTE_ARRAY"
};
const std::map<int, const char*> _Type_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(8, _kTypeValues, _kTypeNames), ::apache::thrift::TEnumIterator(-1, nullptr, nullptr));

std::ostream& operator<<(std::ostream& out, const Type::type& val) {
  std::map<int, const char*>::const_iterator it = _Type_VALUES_TO_NAMES.find(val);
  if (it != _Type_VALUES_TO_NAMES.end()) {
    out << it->second;
  } else {
    out << static_cast<int>(val);
  }
  return out;
}

std::string to_string(const Type::type& val) {
  std::map<int, const char*>::const_iterator it = _Type_VALUES_TO_NAMES.find(val);
  if (it != _Type_VALUES_TO_NAMES.end()) {
    return std::string(it->second);
  } else {
    return std::to_string(static_cast<int>(val));
  }
}

int _kConvertedTypeValues[] = {
  /**
   * a BYTE_ARRAY actually contains UTF8 encoded chars
   */
  ConvertedType::UTF8,
  /**
   * a map is converted as an optional field containing a repeated key/value pair
   */
  ConvertedType::MAP,
  /**
   * a key/value pair is converted into a group of two fields
   */
  ConvertedType::MAP_KEY_VALUE,
  /**
   * a list is converted into an optional field containing a repeated field for its
   * values
   */
  ConvertedType::LIST,
  /**
   * an enum is converted into a binary field
   */
  ConvertedType::ENUM,
  /**
   * A decimal value.
   * 
   * This may be used to annotate binary or fixed primitive types. The
   * underlying byte array stores the unscaled value encoded as two's
   * complement using big-endian byte order (the most significant byte is the
   * zeroth element). The value of the decimal is the value * 10^{-scale}.
   * 
   * This must be accompanied by a (maximum) precision and a scale in the
   * SchemaElement. The precision specifies the number of digits in the decimal
   * and the scale stores the location of the decimal point. For example 1.23
   * would have precision 3 (3 total digits) and scale 2 (the decimal point is
   * 2 digits over).
   */
  ConvertedType::DECIMAL,
  /**
   * A Date
   * 
   * Stored as days since Unix epoch, encoded as the INT32 physical type.
   * 
   */
  ConvertedType::DATE,
  /**
   * A time
   * 
   * The total number of milliseconds since midnight.  The value is stored
   * as an INT32 physical type.
   */
  ConvertedType::TIME_MILLIS,
  /**
   * A time.
   * 
   * The total number of microseconds since midnight.  The value is stored as
   * an INT64 physical type.
   */
  ConvertedType::TIME_MICROS,
  /**
   * A date/time combination
   * 
   * Date and time recorded as milliseconds since the Unix epoch.  Recorded as
   * a physical type of INT64.
   */
  ConvertedType::TIMESTAMP_MILLIS,
  /**
   * A date/time combination
   * 
   * Date and time recorded as microseconds since the Unix epoch.  The value is
   * stored as an INT64 physical type.
   */
  ConvertedType::TIMESTAMP_MICROS,
  /**
   * An unsigned integer value.
   * 
   * The number describes the maximum number of meaningful data bits in
   * the stored value. 8, 16 and 32 bit values are stored using the
   * INT32 physical type.  64 bit values are stored using the INT64
   * physical type.
   * 
   */
  ConvertedType::UINT_8,
  ConvertedType::UINT_16,
  ConvertedType::UINT_32,
  ConvertedType::UINT_64,
  /**
   * A signed integer value.
   * 
   * The number describes the maximum number of meaningful data bits in
   * the stored value. 8, 16 and 32 bit values are stored using the
   * INT32 physical type.  64 bit values are stored using the INT64
   * physical type.
   * 
   */
  ConvertedType::INT_8,
  ConvertedType::INT_16,
  ConvertedType::INT_32,
  ConvertedType::INT_64,
  /**
   * An embedded JSON document
   * 
   * A JSON document embedded within a single UTF8 column.
   */
  ConvertedType::JSON,
  /**
   * An embedded BSON document
   * 
   * A BSON document embedded within a single BINARY column.
   */
  ConvertedType::BSON,
  /**
   * An interval of time
   * 
   * This type annotates data stored as a FIXED_LEN_BYTE_ARRAY of length 12
   * This data is composed of three separate little endian unsigned
   * integers.  Each stores a component of a duration of time.  The first
   * integer identifies the number of months associated with the duration,
   * the second identifies the number of days associated with the duration
   * and the third identifies the number of milliseconds associated with
   * the provided duration.  This duration of time is independent of any
   * particular timezone or date.
   */
  ConvertedType::INTERVAL
};
const char* _kConvertedTypeNames[] = {
  /**
   * a BYTE_ARRAY actually contains UTF8 encoded chars
   */
  "UTF8",
  /**
   * a map is converted as an optional field containing a repeated key/value pair
   */
  "MAP",
  /**
   * a key/value pair is converted into a group of two fields
   */
  "MAP_KEY_VALUE",
  /**
   * a list is converted into an optional field containing a repeated field for its
   * values
   */
  "LIST",
  /**
   * an enum is converted into a binary field
   */
  "ENUM",
  /**
   * A decimal value.
   * 
   * This may be used to annotate binary or fixed primitive types. The
   * underlying byte array stores the unscaled value encoded as two's
   * complement using big-endian byte order (the most significant byte is the
   * zeroth element). The value of the decimal is the value * 10^{-scale}.
   * 
   * This must be accompanied by a (maximum) precision and a scale in the
   * SchemaElement. The precision specifies the number of digits in the decimal
   * and the scale stores the location of the decimal point. For example 1.23
   * would have precision 3 (3 total digits) and scale 2 (the decimal point is
   * 2 digits over).
   */
  "DECIMAL",
  /**
   * A Date
   * 
   * Stored as days since Unix epoch, encoded as the INT32 physical type.
   * 
   */
  "DATE",
  /**
   * A time
   * 
   * The total number of milliseconds since midnight.  The value is stored
   * as an INT32 physical type.
   */
  "TIME_MILLIS",
  /**
   * A time.
   * 
   * The total number of microseconds since midnight.  The value is stored as
   * an INT64 physical type.
   */
  "TIME_MICROS",
  /**
   * A date/time combination
   * 
   * Date and time recorded as milliseconds since the Unix epoch.  Recorded as
   * a physical type of INT64.
   */
  "TIMESTAMP_MILLIS",
  /**
   * A date/time combination
   * 
   * Date and time recorded as microseconds since the Unix epoch.  The value is
   * stored as an INT64 physical type.
   */
  "TIMESTAMP_MICROS",
  /**
   * An unsigned integer value.
   * 
   * The number describes the maximum number of meaningful data bits in
   * the stored value. 8, 16 and 32 bit values are stored using the
   * INT32 physical type.  64 bit values are stored using the INT64
   * physical type.
   * 
   */
  "UINT_8",
  "UINT_16",
  "UINT_32",
  "UINT_64",
  /**
   * A signed integer value.
   * 
   * The number describes the maximum number of meaningful data bits in
   * the stored value. 8, 16 and 32 bit values are stored using the
   * INT32 physical type.  64 bit values are stored using the INT64
   * physical type.
   * 
   */
  "INT_8",
  "INT_16",
  "INT_32",
  "INT_64",
  /**
   * An embedded JSON document
   * 
   * A JSON document embedded within a single UTF8 column.
   */
  "JSON",
  /**
   * An embedded BSON document
   * 
   * A BSON document embedded within a single BINARY column.
   */
  "BSON",
  /**
   * An interval of time
   * 
   * This type annotates data stored as a FIXED_LEN_BYTE_ARRAY of length 12
   * This data is composed of three separate little endian unsigned
   * integers.  Each stores a component of a duration of time.  The first
   * integer identifies the number of months associated with the duration,
   * the second identifies the number of days associated with the duration
   * and the third identifies the number of milliseconds associated with
   * the provided duration.  This duration of time is independent of any
   * particular timezone or date.
   */
  "INTERVAL"
};
const std::map<int, const char*> _ConvertedType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(22, _kConvertedTypeValues, _kConvertedTypeNames), ::apache::thrift::TEnumIterator(-1, nullptr, nullptr));

std::ostream& operator<<(std::ostream& out, const ConvertedType::type& val) {
  std::map<int, const char*>::const_iterator it = _ConvertedType_VALUES_TO_NAMES.find(val);
  if (it != _ConvertedType_VALUES_TO_NAMES.end()) {
    out << it->second;
  } else {
    out << static_cast<int>(val);
  }
  return out;
}

std::string to_string(const ConvertedType::type& val) {
  std::map<int, const char*>::const_iterator it = _ConvertedType_VALUES_TO_NAMES.find(val);
  if (it != _ConvertedType_VALUES_TO_NAMES.end()) {
    return std::string(it->second);
  } else {
    return std::to_string(static_cast<int>(val));
  }
}

int _kFieldRepetitionTypeValues[] = {
  /**
   * This field is required (can not be null) and each record has exactly 1 value.
   */
  FieldRepetitionType::REQUIRED,
  /**
   * The field is optional (can be null) and each record has 0 or 1 values.
   */
  FieldRepetitionType::OPTIONAL,
  /**
   * The field is repeated and can contain 0 or more values
   */
  FieldRepetitionType::REPEATED
};
const char* _kFieldRepetitionTypeNames[] = {
  /**
   * This field is required (can not be null) and each record has exactly 1 value.
   */
  "REQUIRED",
  /**
   * The field is optional (can be null) and each record has 0 or 1 values.
   */
  "OPTIONAL",
  /**
   * The field is repeated and can contain 0 or more values
   */
  "REPEATED"
};
const std::map<int, const char*> _FieldRepetitionType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(3, _kFieldRepetitionTypeValues, _kFieldRepetitionTypeNames), ::apache::thrift::TEnumIterator(-1, nullptr, nullptr));

std::ostream& operator<<(std::ostream& out, const FieldRepetitionType::type& val) {
  std::map<int, const char*>::const_iterator it = _FieldRepetitionType_VALUES_TO_NAMES.find(val);
  if (it != _FieldRepetitionType_VALUES_TO_NAMES.end()) {
    out << it->second;
  } else {
    out << static_cast<int>(val);
  }
  return out;
}

std::string to_string(const FieldRepetitionType::type& val) {
  std::map<int, const char*>::const_iterator it = _FieldRepetitionType_VALUES_TO_NAMES.find(val);
  if (it != _FieldRepetitionType_VALUES_TO_NAMES.end()) {
    return std::string(it->second);
  } else {
    return std::to_string(static_cast<int>(val));
  }
}

int _kEncodingValues[] = {
  /**
   * Default encoding.
   * BOOLEAN - 1 bit per value. 0 is false; 1 is true.
   * INT32 - 4 bytes per value.  Stored as little-endian.
   * INT64 - 8 bytes per value.  Stored as little-endian.
   * FLOAT - 4 bytes per value.  IEEE. Stored as little-endian.
   * DOUBLE - 8 bytes per value.  IEEE. Stored as little-endian.
   * BYTE_ARRAY - 4 byte length stored as little endian, followed by bytes.
   * FIXED_LEN_BYTE_ARRAY - Just the bytes.
   */
  Encoding::PLAIN,
  /**
   * Deprecated: Dictionary encoding. The values in the dictionary are encoded in the
   * plain type.
   * in a data page use RLE_DICTIONARY instead.
   * in a Dictionary page use PLAIN instead
   */
  Encoding::PLAIN_DICTIONARY,
  /**
   * Group packed run length encoding. Usable for definition/repetition levels
   * encoding and Booleans (on one bit: 0 is false; 1 is true.)
   */
  Encoding::RLE,
  /**
   * Bit packed encoding.  This can only be used if the data has a known max
   * width.  Usable for definition/repetition levels encoding.
   */
  Encoding::BIT_PACKED,
  /**
   * Delta encoding for integers. This can be used for int columns and works best
   * on sorted data
   */
  Encoding::DELTA_BINARY_PACKED,
  /**
   * Encoding for byte arrays to separate the length values and the data. The lengths
   * are encoded using DELTA_BINARY_PACKED
   */
  Encoding::DELTA_LENGTH_BYTE_ARRAY,
  /**
   * Incremental-encoded byte array. Prefix lengths are encoded using DELTA_BINARY_PACKED.
   * Suffixes are stored as delta length byte arrays.
   */
  Encoding::DELTA_BYTE_ARRAY,
  /**
   * Dictionary encoding: the ids are encoded using the RLE encoding
   */
  Encoding::RLE_DICTIONARY,
  /**
   * Encoding for floating-point data.
   * K byte-streams are created where K is the size in bytes of the data type.
   * The individual bytes of an FP value are scattered to the corresponding stream and
   * the streams are concatenated.
   * This itself does not reduce the size of the data but can lead to better compression
   * afterwards.
   */
  Encoding::BYTE_STREAM_SPLIT
};
const char* _kEncodingNames[] = {
  /**
   * Default encoding.
   * BOOLEAN - 1 bit per value. 0 is false; 1 is true.
   * INT32 - 4 bytes per value.  Stored as little-endian.
   * INT64 - 8 bytes per value.  Stored as little-endian.
   * FLOAT - 4 bytes per value.  IEEE. Stored as little-endian.
   * DOUBLE - 8 bytes per value.  IEEE. Stored as little-endian.
   * BYTE_ARRAY - 4 byte length stored as little endian, followed by bytes.
   * FIXED_LEN_BYTE_ARRAY - Just the bytes.
   */
  "PLAIN",
  /**
   * Deprecated: Dictionary encoding. The values in the dictionary are encoded in the
   * plain type.
   * in a data page use RLE_DICTIONARY instead.
   * in a Dictionary page use PLAIN instead
   */
  "PLAIN_DICTIONARY",
  /**
   * Group packed run length encoding. Usable for definition/repetition levels
   * encoding and Booleans (on one bit: 0 is false; 1 is true.)
   */
  "RLE",
  /**
   * Bit packed encoding.  This can only be used if the data has a known max
   * width.  Usable for definition/repetition levels encoding.
   */
  "BIT_PACKED",
  /**
   * Delta encoding for integers. This can be used for int columns and works best
   * on sorted data
   */
  "DELTA_BINARY_PACKED",
  /**
   * Encoding for byte arrays to separate the length values and the data. The lengths
   * are encoded using DELTA_BINARY_PACKED
   */
  "DELTA_LENGTH_BYTE_ARRAY",
  /**
   * Incremental-encoded byte array. Prefix lengths are encoded using DELTA_BINARY_PACKED.
   * Suffixes are stored as delta length byte arrays.
   */
  "DELTA_BYTE_ARRAY",
  /**
   * Dictionary encoding: the ids are encoded using the RLE encoding
   */
  "RLE_DICTIONARY",
  /**
   * Encoding for floating-point data.
   * K byte-streams are created where K is the size in bytes of the data type.
   * The individual bytes of an FP value are scattered to the corresponding stream and
   * the streams are concatenated.
   * This itself does not reduce the size of the data but can lead to better compression
   * afterwards.
   */
  "BYTE_STREAM_SPLIT"
};
const std::map<int, const char*> _Encoding_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(9, _kEncodingValues, _kEncodingNames), ::apache::thrift::TEnumIterator(-1, nullptr, nullptr));

std::ostream& operator<<(std::ostream& out, const Encoding::type& val) {
  std::map<int, const char*>::const_iterator it = _Encoding_VALUES_TO_NAMES.find(val);
  if (it != _Encoding_VALUES_TO_NAMES.end()) {
    out << it->second;
  } else {
    out << static_cast<int>(val);
  }
  return out;
}

std::string to_string(const Encoding::type& val) {
  std::map<int, const char*>::const_iterator it = _Encoding_VALUES_TO_NAMES.find(val);
  if (it != _Encoding_VALUES_TO_NAMES.end()) {
    return std::string(it->second);
  } else {
    return std::to_string(static_cast<int>(val));
  }
}

int _kCompressionCodecValues[] = {
  CompressionCodec::UNCOMPRESSED,
  CompressionCodec::SNAPPY,
  CompressionCodec::GZIP,
  CompressionCodec::LZO,
  CompressionCodec::BROTLI,
  CompressionCodec::LZ4,
  CompressionCodec::ZSTD,
  CompressionCodec::LZ4_RAW
};
const char* _kCompressionCodecNames[] = {
  "UNCOMPRESSED",
  "SNAPPY",
  "GZIP",
  "LZO",
  "BROTLI",
  "LZ4",
  "ZSTD",
  "LZ4_RAW"
};
const std::map<int, const char*> _CompressionCodec_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(8, _kCompressionCodecValues, _kCompressionCodecNames), ::apache::thrift::TEnumIterator(-1, nullptr, nullptr));

std::ostream& operator<<(std::ostream& out, const CompressionCodec::type& val) {
  std::map<int, const char*>::const_iterator it = _CompressionCodec_VALUES_TO_NAMES.find(val);
  if (it != _CompressionCodec_VALUES_TO_NAMES.end()) {
    out << it->second;
  } else {
    out << static_cast<int>(val);
  }
  return out;
}

std::string to_string(const CompressionCodec::type& val) {
  std::map<int, const char*>::const_iterator it = _CompressionCodec_VALUES_TO_NAMES.find(val);
  if (it != _CompressionCodec_VALUES_TO_NAMES.end()) {
    return std::string(it->second);
  } else {
    return std::to_string(static_cast<int>(val));
  }
}

int _kPageTypeValues[] = {
  PageType::DATA_PAGE,
  PageType::INDEX_PAGE,
  PageType::DICTIONARY_PAGE,
  PageType::DATA_PAGE_V2
};
const char* _kPageTypeNames[] = {
  "DATA_PAGE",
  "INDEX_PAGE",
  "DICTIONARY_PAGE",
  "DATA_PAGE_V2"
};
const std::map<int, const char*> _PageType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(4, _kPageTypeValues, _kPageTypeNames), ::apache::thrift::TEnumIterator(-1, nullptr, nullptr));

std::ostream& operator<<(std::ostream& out, const PageType::type& val) {
  std::map<int, const char*>::const_iterator it = _PageType_VALUES_TO_NAMES.find(val);
  if (it != _PageType_VALUES_TO_NAMES.end()) {
    out << it->second;
  } else {
    out << static_cast<int>(val);
  }
  return out;
}

std::string to_string(const PageType::type& val) {
  std::map<int, const char*>::const_iterator it = _PageType_VALUES_TO_NAMES.find(val);
  if (it != _PageType_VALUES_TO_NAMES.end()) {
    return std::string(it->second);
  } else {
    return std::to_string(static_cast<int>(val));
  }
}

int _kBoundaryOrderValues[] = {
  BoundaryOrder::UNORDERED,
  BoundaryOrder::ASCENDING,
  BoundaryOrder::DESCENDING
};
const char* _kBoundaryOrderNames[] = {
  "UNORDERED",
  "ASCENDING",
  "DESCENDING"
};
const std::map<int, const char*> _BoundaryOrder_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(3, _kBoundaryOrderValues, _kBoundaryOrderNames), ::apache::thrift::TEnumIterator(-1, nullptr, nullptr));

std::ostream& operator<<(std::ostream& out, const BoundaryOrder::type& val) {
  std::map<int, const char*>::const_iterator it = _BoundaryOrder_VALUES_TO_NAMES.find(val);
  if (it != _BoundaryOrder_VALUES_TO_NAMES.end()) {
    out << it->second;
  } else {
    out << static_cast<int>(val);
  }
  return out;
}

std::string to_string(const BoundaryOrder::type& val) {
  std::map<int, const char*>::const_iterator it = _BoundaryOrder_VALUES_TO_NAMES.find(val);
  if (it != _BoundaryOrder_VALUES_TO_NAMES.end()) {
    return std::string(it->second);
  } else {
    return std::to_string(static_cast<int>(val));
  }
}


SizeStatistics::~SizeStatistics() noexcept {
}


void SizeStatistics::__set_unencoded_byte_array_data_bytes(const int64_t val) {
  this->unencoded_byte_array_data_bytes = val;
__isset.unencoded_byte_array_data_bytes = true;
}

void SizeStatistics::__set_repetition_level_histogram(const std::vector<int64_t> & val) {
  this->repetition_level_histogram = val;
__isset.repetition_level_histogram = true;
}

void SizeStatistics::__set_definition_level_histogram(const std::vector<int64_t> & val) {
  this->definition_level_histogram = val;
__isset.definition_level_histogram = true;
}
std::ostream& operator<<(std::ostream& out, const SizeStatistics& obj)
{
  obj.printTo(out);
  return out;
}


void swap(SizeStatistics &a, SizeStatistics &b) {
  using ::std::swap;
  swap(a.unencoded_byte_array_data_bytes, b.unencoded_byte_array_data_bytes);
  swap(a.repetition_level_histogram, b.repetition_level_histogram);
  swap(a.definition_level_histogram, b.definition_level_histogram);
  swap(a.__isset, b.__isset);
}

SizeStatistics::SizeStatistics(const SizeStatistics& other12) {
  unencoded_byte_array_data_bytes = other12.unencoded_byte_array_data_bytes;
  repetition_level_histogram = other12.repetition_level_histogram;
  definition_level_histogram = other12.definition_level_histogram;
  __isset = other12.__isset;
}
SizeStatistics::SizeStatistics(SizeStatistics&& other13) noexcept {
  unencoded_byte_array_data_bytes = other13.unencoded_byte_array_data_bytes;
  repetition_level_histogram = std::move(other13.repetition_level_histogram);
  definition_level_histogram = std::move(other13.definition_level_histogram);
  __isset = other13.__isset;
}
SizeStatistics& SizeStatistics::operator=(const SizeStatistics& other14) {
  unencoded_byte_array_data_bytes = other14.unencoded_byte_array_data_bytes;
  repetition_level_histogram = other14.repetition_level_histogram;
  definition_level_histogram = other14.definition_level_histogram;
  __isset = other14.__isset;
  return *this;
}
SizeStatistics& SizeStatistics::operator=(SizeStatistics&& other15) noexcept {
  unencoded_byte_array_data_bytes = other15.unencoded_byte_array_data_bytes;
  repetition_level_histogram = std::move(other15.repetition_level_histogram);
  definition_level_histogram = std::move(other15.definition_level_histogram);
  __isset = other15.__isset;
  return *this;
}
void SizeStatistics::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "SizeStatistics(";
  out << "unencoded_byte_array_data_bytes="; (__isset.unencoded_byte_array_data_bytes ? (out << to_string(unencoded_byte_array_data_bytes)) : (out << "<null>"));
  out << ", " << "repetition_level_histogram="; (__isset.repetition_level_histogram ? (out << to_string(repetition_level_histogram)) : (out << "<null>"));
  out << ", " << "definition_level_histogram="; (__isset.definition_level_histogram ? (out << to_string(definition_level_histogram)) : (out << "<null>"));
  out << ")";
}


Statistics::~Statistics() noexcept {
}


void Statistics::__set_max(const std::string& val) {
  this->max = val;
__isset.max = true;
}

void Statistics::__set_min(const std::string& val) {
  this->min = val;
__isset.min = true;
}

void Statistics::__set_null_count(const int64_t val) {
  this->null_count = val;
__isset.null_count = true;
}

void Statistics::__set_distinct_count(const int64_t val) {
  this->distinct_count = val;
__isset.distinct_count = true;
}

void Statistics::__set_max_value(const std::string& val) {
  this->max_value = val;
__isset.max_value = true;
}

void Statistics::__set_min_value(const std::string& val) {
  this->min_value = val;
__isset.min_value = true;
}

void Statistics::__set_is_max_value_exact(const bool val) {
  this->is_max_value_exact = val;
__isset.is_max_value_exact = true;
}

void Statistics::__set_is_min_value_exact(const bool val) {
  this->is_min_value_exact = val;
__isset.is_min_value_exact = true;
}
std::ostream& operator<<(std::ostream& out, const Statistics& obj)
{
  obj.printTo(out);
  return out;
}


void swap(Statistics &a, Statistics &b) {
  using ::std::swap;
  swap(a.max, b.max);
  swap(a.min, b.min);
  swap(a.null_count, b.null_count);
  swap(a.distinct_count, b.distinct_count);
  swap(a.max_value, b.max_value);
  swap(a.min_value, b.min_value);
  swap(a.is_max_value_exact, b.is_max_value_exact);
  swap(a.is_min_value_exact, b.is_min_value_exact);
  swap(a.__isset, b.__isset);
}

Statistics::Statistics(const Statistics& other16) {
  max = other16.max;
  min = other16.min;
  null_count = other16.null_count;
  distinct_count = other16.distinct_count;
  max_value = other16.max_value;
  min_value = other16.min_value;
  is_max_value_exact = other16.is_max_value_exact;
  is_min_value_exact = other16.is_min_value_exact;
  __isset = other16.__isset;
}
Statistics::Statistics(Statistics&& other17) noexcept {
  max = std::move(other17.max);
  min = std::move(other17.min);
  null_count = other17.null_count;
  distinct_count = other17.distinct_count;
  max_value = std::move(other17.max_value);
  min_value = std::move(other17.min_value);
  is_max_value_exact = other17.is_max_value_exact;
  is_min_value_exact = other17.is_min_value_exact;
  __isset = other17.__isset;
}
Statistics& Statistics::operator=(const Statistics& other18) {
  max = other18.max;
  min = other18.min;
  null_count = other18.null_count;
  distinct_count = other18.distinct_count;
  max_value = other18.max_value;
  min_value = other18.min_value;
  is_max_value_exact = other18.is_max_value_exact;
  is_min_value_exact = other18.is_min_value_exact;
  __isset = other18.__isset;
  return *this;
}
Statistics& Statistics::operator=(Statistics&& other19) noexcept {
  max = std::move(other19.max);
  min = std::move(other19.min);
  null_count = other19.null_count;
  distinct_count = other19.distinct_count;
  max_value = std::move(other19.max_value);
  min_value = std::move(other19.min_value);
  is_max_value_exact = other19.is_max_value_exact;
  is_min_value_exact = other19.is_min_value_exact;
  __isset = other19.__isset;
  return *this;
}
void Statistics::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "Statistics(";
  out << "max="; (__isset.max ? (out << to_string(max)) : (out << "<null>"));
  out << ", " << "min="; (__isset.min ? (out << to_string(min)) : (out << "<null>"));
  out << ", " << "null_count="; (__isset.null_count ? (out << to_string(null_count)) : (out << "<null>"));
  out << ", " << "distinct_count="; (__isset.distinct_count ? (out << to_string(distinct_count)) : (out << "<null>"));
  out << ", " << "max_value="; (__isset.max_value ? (out << to_string(max_value)) : (out << "<null>"));
  out << ", " << "min_value="; (__isset.min_value ? (out << to_string(min_value)) : (out << "<null>"));
  out << ", " << "is_max_value_exact="; (__isset.is_max_value_exact ? (out << to_string(is_max_value_exact)) : (out << "<null>"));
  out << ", " << "is_min_value_exact="; (__isset.is_min_value_exact ? (out << to_string(is_min_value_exact)) : (out << "<null>"));
  out << ")";
}


StringType::~StringType() noexcept {
}

std::ostream& operator<<(std::ostream& out, const StringType& obj)
{
  obj.printTo(out);
  return out;
}


void swap(StringType &a, StringType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

StringType::StringType(const StringType& other20) noexcept {
  (void) other20;
}
StringType::StringType(StringType&& other21) noexcept {
  (void) other21;
}
StringType& StringType::operator=(const StringType& other22) noexcept {
  (void) other22;
  return *this;
}
StringType& StringType::operator=(StringType&& other23) noexcept {
  (void) other23;
  return *this;
}
void StringType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "StringType(";
  out << ")";
}


UUIDType::~UUIDType() noexcept {
}

std::ostream& operator<<(std::ostream& out, const UUIDType& obj)
{
  obj.printTo(out);
  return out;
}


void swap(UUIDType &a, UUIDType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

UUIDType::UUIDType(const UUIDType& other24) noexcept {
  (void) other24;
}
UUIDType::UUIDType(UUIDType&& other25) noexcept {
  (void) other25;
}
UUIDType& UUIDType::operator=(const UUIDType& other26) noexcept {
  (void) other26;
  return *this;
}
UUIDType& UUIDType::operator=(UUIDType&& other27) noexcept {
  (void) other27;
  return *this;
}
void UUIDType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "UUIDType(";
  out << ")";
}


MapType::~MapType() noexcept {
}

std::ostream& operator<<(std::ostream& out, const MapType& obj)
{
  obj.printTo(out);
  return out;
}


void swap(MapType &a, MapType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

MapType::MapType(const MapType& other28) noexcept {
  (void) other28;
}
MapType::MapType(MapType&& other29) noexcept {
  (void) other29;
}
MapType& MapType::operator=(const MapType& other30) noexcept {
  (void) other30;
  return *this;
}
MapType& MapType::operator=(MapType&& other31) noexcept {
  (void) other31;
  return *this;
}
void MapType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "MapType(";
  out << ")";
}


ListType::~ListType() noexcept {
}

std::ostream& operator<<(std::ostream& out, const ListType& obj)
{
  obj.printTo(out);
  return out;
}


void swap(ListType &a, ListType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

ListType::ListType(const ListType& other32) noexcept {
  (void) other32;
}
ListType::ListType(ListType&& other33) noexcept {
  (void) other33;
}
ListType& ListType::operator=(const ListType& other34) noexcept {
  (void) other34;
  return *this;
}
ListType& ListType::operator=(ListType&& other35) noexcept {
  (void) other35;
  return *this;
}
void ListType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ListType(";
  out << ")";
}


EnumType::~EnumType() noexcept {
}

std::ostream& operator<<(std::ostream& out, const EnumType& obj)
{
  obj.printTo(out);
  return out;
}


void swap(EnumType &a, EnumType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

EnumType::EnumType(const EnumType& other36) noexcept {
  (void) other36;
}
EnumType::EnumType(EnumType&& other37) noexcept {
  (void) other37;
}
EnumType& EnumType::operator=(const EnumType& other38) noexcept {
  (void) other38;
  return *this;
}
EnumType& EnumType::operator=(EnumType&& other39) noexcept {
  (void) other39;
  return *this;
}
void EnumType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "EnumType(";
  out << ")";
}


DateType::~DateType() noexcept {
}

std::ostream& operator<<(std::ostream& out, const DateType& obj)
{
  obj.printTo(out);
  return out;
}


void swap(DateType &a, DateType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

DateType::DateType(const DateType& other40) noexcept {
  (void) other40;
}
DateType::DateType(DateType&& other41) noexcept {
  (void) other41;
}
DateType& DateType::operator=(const DateType& other42) noexcept {
  (void) other42;
  return *this;
}
DateType& DateType::operator=(DateType&& other43) noexcept {
  (void) other43;
  return *this;
}
void DateType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "DateType(";
  out << ")";
}


Float16Type::~Float16Type() noexcept {
}

std::ostream& operator<<(std::ostream& out, const Float16Type& obj)
{
  obj.printTo(out);
  return out;
}


void swap(Float16Type &a, Float16Type &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

Float16Type::Float16Type(const Float16Type& other44) noexcept {
  (void) other44;
}
Float16Type::Float16Type(Float16Type&& other45) noexcept {
  (void) other45;
}
Float16Type& Float16Type::operator=(const Float16Type& other46) noexcept {
  (void) other46;
  return *this;
}
Float16Type& Float16Type::operator=(Float16Type&& other47) noexcept {
  (void) other47;
  return *this;
}
void Float16Type::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "Float16Type(";
  out << ")";
}


NullType::~NullType() noexcept {
}

std::ostream& operator<<(std::ostream& out, const NullType& obj)
{
  obj.printTo(out);
  return out;
}


void swap(NullType &a, NullType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

NullType::NullType(const NullType& other48) noexcept {
  (void) other48;
}
NullType::NullType(NullType&& other49) noexcept {
  (void) other49;
}
NullType& NullType::operator=(const NullType& other50) noexcept {
  (void) other50;
  return *this;
}
NullType& NullType::operator=(NullType&& other51) noexcept {
  (void) other51;
  return *this;
}
void NullType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "NullType(";
  out << ")";
}


DecimalType::~DecimalType() noexcept {
}


void DecimalType::__set_scale(const int32_t val) {
  this->scale = val;
}

void DecimalType::__set_precision(const int32_t val) {
  this->precision = val;
}
std::ostream& operator<<(std::ostream& out, const DecimalType& obj)
{
  obj.printTo(out);
  return out;
}


void swap(DecimalType &a, DecimalType &b) {
  using ::std::swap;
  swap(a.scale, b.scale);
  swap(a.precision, b.precision);
}

DecimalType::DecimalType(const DecimalType& other52) noexcept {
  scale = other52.scale;
  precision = other52.precision;
}
DecimalType::DecimalType(DecimalType&& other53) noexcept {
  scale = other53.scale;
  precision = other53.precision;
}
DecimalType& DecimalType::operator=(const DecimalType& other54) noexcept {
  scale = other54.scale;
  precision = other54.precision;
  return *this;
}
DecimalType& DecimalType::operator=(DecimalType&& other55) noexcept {
  scale = other55.scale;
  precision = other55.precision;
  return *this;
}
void DecimalType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "DecimalType(";
  out << "scale=" << to_string(scale);
  out << ", " << "precision=" << to_string(precision);
  out << ")";
}


MilliSeconds::~MilliSeconds() noexcept {
}

std::ostream& operator<<(std::ostream& out, const MilliSeconds& obj)
{
  obj.printTo(out);
  return out;
}


void swap(MilliSeconds &a, MilliSeconds &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

MilliSeconds::MilliSeconds(const MilliSeconds& other56) noexcept {
  (void) other56;
}
MilliSeconds::MilliSeconds(MilliSeconds&& other57) noexcept {
  (void) other57;
}
MilliSeconds& MilliSeconds::operator=(const MilliSeconds& other58) noexcept {
  (void) other58;
  return *this;
}
MilliSeconds& MilliSeconds::operator=(MilliSeconds&& other59) noexcept {
  (void) other59;
  return *this;
}
void MilliSeconds::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "MilliSeconds(";
  out << ")";
}


MicroSeconds::~MicroSeconds() noexcept {
}

std::ostream& operator<<(std::ostream& out, const MicroSeconds& obj)
{
  obj.printTo(out);
  return out;
}


void swap(MicroSeconds &a, MicroSeconds &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

MicroSeconds::MicroSeconds(const MicroSeconds& other60) noexcept {
  (void) other60;
}
MicroSeconds::MicroSeconds(MicroSeconds&& other61) noexcept {
  (void) other61;
}
MicroSeconds& MicroSeconds::operator=(const MicroSeconds& other62) noexcept {
  (void) other62;
  return *this;
}
MicroSeconds& MicroSeconds::operator=(MicroSeconds&& other63) noexcept {
  (void) other63;
  return *this;
}
void MicroSeconds::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "MicroSeconds(";
  out << ")";
}


NanoSeconds::~NanoSeconds() noexcept {
}

std::ostream& operator<<(std::ostream& out, const NanoSeconds& obj)
{
  obj.printTo(out);
  return out;
}


void swap(NanoSeconds &a, NanoSeconds &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

NanoSeconds::NanoSeconds(const NanoSeconds& other64) noexcept {
  (void) other64;
}
NanoSeconds::NanoSeconds(NanoSeconds&& other65) noexcept {
  (void) other65;
}
NanoSeconds& NanoSeconds::operator=(const NanoSeconds& other66) noexcept {
  (void) other66;
  return *this;
}
NanoSeconds& NanoSeconds::operator=(NanoSeconds&& other67) noexcept {
  (void) other67;
  return *this;
}
void NanoSeconds::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "NanoSeconds(";
  out << ")";
}


TimeUnit::~TimeUnit() noexcept {
}


void TimeUnit::__set_MILLIS(const MilliSeconds& val) {
  this->MILLIS = val;
__isset.MILLIS = true;
}

void TimeUnit::__set_MICROS(const MicroSeconds& val) {
  this->MICROS = val;
__isset.MICROS = true;
}

void TimeUnit::__set_NANOS(const NanoSeconds& val) {
  this->NANOS = val;
__isset.NANOS = true;
}
std::ostream& operator<<(std::ostream& out, const TimeUnit& obj)
{
  obj.printTo(out);
  return out;
}


void swap(TimeUnit &a, TimeUnit &b) {
  using ::std::swap;
  swap(a.MILLIS, b.MILLIS);
  swap(a.MICROS, b.MICROS);
  swap(a.NANOS, b.NANOS);
  swap(a.__isset, b.__isset);
}

TimeUnit::TimeUnit(const TimeUnit& other68) noexcept {
  MILLIS = other68.MILLIS;
  MICROS = other68.MICROS;
  NANOS = other68.NANOS;
  __isset = other68.__isset;
}
TimeUnit::TimeUnit(TimeUnit&& other69) noexcept {
  MILLIS = std::move(other69.MILLIS);
  MICROS = std::move(other69.MICROS);
  NANOS = std::move(other69.NANOS);
  __isset = other69.__isset;
}
TimeUnit& TimeUnit::operator=(const TimeUnit& other70) noexcept {
  MILLIS = other70.MILLIS;
  MICROS = other70.MICROS;
  NANOS = other70.NANOS;
  __isset = other70.__isset;
  return *this;
}
TimeUnit& TimeUnit::operator=(TimeUnit&& other71) noexcept {
  MILLIS = std::move(other71.MILLIS);
  MICROS = std::move(other71.MICROS);
  NANOS = std::move(other71.NANOS);
  __isset = other71.__isset;
  return *this;
}
void TimeUnit::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "TimeUnit(";
  out << "MILLIS="; (__isset.MILLIS ? (out << to_string(MILLIS)) : (out << "<null>"));
  out << ", " << "MICROS="; (__isset.MICROS ? (out << to_string(MICROS)) : (out << "<null>"));
  out << ", " << "NANOS="; (__isset.NANOS ? (out << to_string(NANOS)) : (out << "<null>"));
  out << ")";
}


TimestampType::~TimestampType() noexcept {
}


void TimestampType::__set_isAdjustedToUTC(const bool val) {
  this->isAdjustedToUTC = val;
}

void TimestampType::__set_unit(const TimeUnit& val) {
  this->unit = val;
}
std::ostream& operator<<(std::ostream& out, const TimestampType& obj)
{
  obj.printTo(out);
  return out;
}


void swap(TimestampType &a, TimestampType &b) {
  using ::std::swap;
  swap(a.isAdjustedToUTC, b.isAdjustedToUTC);
  swap(a.unit, b.unit);
}

TimestampType::TimestampType(const TimestampType& other72) noexcept {
  isAdjustedToUTC = other72.isAdjustedToUTC;
  unit = other72.unit;
}
TimestampType::TimestampType(TimestampType&& other73) noexcept {
  isAdjustedToUTC = other73.isAdjustedToUTC;
  unit = std::move(other73.unit);
}
TimestampType& TimestampType::operator=(const TimestampType& other74) noexcept {
  isAdjustedToUTC = other74.isAdjustedToUTC;
  unit = other74.unit;
  return *this;
}
TimestampType& TimestampType::operator=(TimestampType&& other75) noexcept {
  isAdjustedToUTC = other75.isAdjustedToUTC;
  unit = std::move(other75.unit);
  return *this;
}
void TimestampType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "TimestampType(";
  out << "isAdjustedToUTC=" << to_string(isAdjustedToUTC);
  out << ", " << "unit=" << to_string(unit);
  out << ")";
}


TimeType::~TimeType() noexcept {
}


void TimeType::__set_isAdjustedToUTC(const bool val) {
  this->isAdjustedToUTC = val;
}

void TimeType::__set_unit(const TimeUnit& val) {
  this->unit = val;
}
std::ostream& operator<<(std::ostream& out, const TimeType& obj)
{
  obj.printTo(out);
  return out;
}


void swap(TimeType &a, TimeType &b) {
  using ::std::swap;
  swap(a.isAdjustedToUTC, b.isAdjustedToUTC);
  swap(a.unit, b.unit);
}

TimeType::TimeType(const TimeType& other76) noexcept {
  isAdjustedToUTC = other76.isAdjustedToUTC;
  unit = other76.unit;
}
TimeType::TimeType(TimeType&& other77) noexcept {
  isAdjustedToUTC = other77.isAdjustedToUTC;
  unit = std::move(other77.unit);
}
TimeType& TimeType::operator=(const TimeType& other78) noexcept {
  isAdjustedToUTC = other78.isAdjustedToUTC;
  unit = other78.unit;
  return *this;
}
TimeType& TimeType::operator=(TimeType&& other79) noexcept {
  isAdjustedToUTC = other79.isAdjustedToUTC;
  unit = std::move(other79.unit);
  return *this;
}
void TimeType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "TimeType(";
  out << "isAdjustedToUTC=" << to_string(isAdjustedToUTC);
  out << ", " << "unit=" << to_string(unit);
  out << ")";
}


IntType::~IntType() noexcept {
}


void IntType::__set_bitWidth(const int8_t val) {
  this->bitWidth = val;
}

void IntType::__set_isSigned(const bool val) {
  this->isSigned = val;
}
std::ostream& operator<<(std::ostream& out, const IntType& obj)
{
  obj.printTo(out);
  return out;
}


void swap(IntType &a, IntType &b) {
  using ::std::swap;
  swap(a.bitWidth, b.bitWidth);
  swap(a.isSigned, b.isSigned);
}

IntType::IntType(const IntType& other80) noexcept {
  bitWidth = other80.bitWidth;
  isSigned = other80.isSigned;
}
IntType::IntType(IntType&& other81) noexcept {
  bitWidth = other81.bitWidth;
  isSigned = other81.isSigned;
}
IntType& IntType::operator=(const IntType& other82) noexcept {
  bitWidth = other82.bitWidth;
  isSigned = other82.isSigned;
  return *this;
}
IntType& IntType::operator=(IntType&& other83) noexcept {
  bitWidth = other83.bitWidth;
  isSigned = other83.isSigned;
  return *this;
}
void IntType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "IntType(";
  out << "bitWidth=" << to_string(bitWidth);
  out << ", " << "isSigned=" << to_string(isSigned);
  out << ")";
}


JsonType::~JsonType() noexcept {
}

std::ostream& operator<<(std::ostream& out, const JsonType& obj)
{
  obj.printTo(out);
  return out;
}


void swap(JsonType &a, JsonType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

JsonType::JsonType(const JsonType& other84) noexcept {
  (void) other84;
}
JsonType::JsonType(JsonType&& other85) noexcept {
  (void) other85;
}
JsonType& JsonType::operator=(const JsonType& other86) noexcept {
  (void) other86;
  return *this;
}
JsonType& JsonType::operator=(JsonType&& other87) noexcept {
  (void) other87;
  return *this;
}
void JsonType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "JsonType(";
  out << ")";
}


BsonType::~BsonType() noexcept {
}

std::ostream& operator<<(std::ostream& out, const BsonType& obj)
{
  obj.printTo(out);
  return out;
}


void swap(BsonType &a, BsonType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

BsonType::BsonType(const BsonType& other88) noexcept {
  (void) other88;
}
BsonType::BsonType(BsonType&& other89) noexcept {
  (void) other89;
}
BsonType& BsonType::operator=(const BsonType& other90) noexcept {
  (void) other90;
  return *this;
}
BsonType& BsonType::operator=(BsonType&& other91) noexcept {
  (void) other91;
  return *this;
}
void BsonType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "BsonType(";
  out << ")";
}


LogicalType::~LogicalType() noexcept {
}


void LogicalType::__set_STRING(const StringType& val) {
  this->STRING = val;
__isset.STRING = true;
}

void LogicalType::__set_MAP(const MapType& val) {
  this->MAP = val;
__isset.MAP = true;
}

void LogicalType::__set_LIST(const ListType& val) {
  this->LIST = val;
__isset.LIST = true;
}

void LogicalType::__set_ENUM(const EnumType& val) {
  this->ENUM = val;
__isset.ENUM = true;
}

void LogicalType::__set_DECIMAL(const DecimalType& val) {
  this->DECIMAL = val;
__isset.DECIMAL = true;
}

void LogicalType::__set_DATE(const DateType& val) {
  this->DATE = val;
__isset.DATE = true;
}

void LogicalType::__set_TIME(const TimeType& val) {
  this->TIME = val;
__isset.TIME = true;
}

void LogicalType::__set_TIMESTAMP(const TimestampType& val) {
  this->TIMESTAMP = val;
__isset.TIMESTAMP = true;
}

void LogicalType::__set_INTEGER(const IntType& val) {
  this->INTEGER = val;
__isset.INTEGER = true;
}

void LogicalType::__set_UNKNOWN(const NullType& val) {
  this->UNKNOWN = val;
__isset.UNKNOWN = true;
}

void LogicalType::__set_JSON(const JsonType& val) {
  this->JSON = val;
__isset.JSON = true;
}

void LogicalType::__set_BSON(const BsonType& val) {
  this->BSON = val;
__isset.BSON = true;
}

void LogicalType::__set_UUID(const UUIDType& val) {
  this->UUID = val;
__isset.UUID = true;
}

void LogicalType::__set_FLOAT16(const Float16Type& val) {
  this->FLOAT16 = val;
__isset.FLOAT16 = true;
}
std::ostream& operator<<(std::ostream& out, const LogicalType& obj)
{
  obj.printTo(out);
  return out;
}


void swap(LogicalType &a, LogicalType &b) {
  using ::std::swap;
  swap(a.STRING, b.STRING);
  swap(a.MAP, b.MAP);
  swap(a.LIST, b.LIST);
  swap(a.ENUM, b.ENUM);
  swap(a.DECIMAL, b.DECIMAL);
  swap(a.DATE, b.DATE);
  swap(a.TIME, b.TIME);
  swap(a.TIMESTAMP, b.TIMESTAMP);
  swap(a.INTEGER, b.INTEGER);
  swap(a.UNKNOWN, b.UNKNOWN);
  swap(a.JSON, b.JSON);
  swap(a.BSON, b.BSON);
  swap(a.UUID, b.UUID);
  swap(a.FLOAT16, b.FLOAT16);
  swap(a.__isset, b.__isset);
}

LogicalType::LogicalType(const LogicalType& other92) noexcept {
  STRING = other92.STRING;
  MAP = other92.MAP;
  LIST = other92.LIST;
  ENUM = other92.ENUM;
  DECIMAL = other92.DECIMAL;
  DATE = other92.DATE;
  TIME = other92.TIME;
  TIMESTAMP = other92.TIMESTAMP;
  INTEGER = other92.INTEGER;
  UNKNOWN = other92.UNKNOWN;
  JSON = other92.JSON;
  BSON = other92.BSON;
  UUID = other92.UUID;
  FLOAT16 = other92.FLOAT16;
  __isset = other92.__isset;
}
LogicalType::LogicalType(LogicalType&& other93) noexcept {
  STRING = std::move(other93.STRING);
  MAP = std::move(other93.MAP);
  LIST = std::move(other93.LIST);
  ENUM = std::move(other93.ENUM);
  DECIMAL = std::move(other93.DECIMAL);
  DATE = std::move(other93.DATE);
  TIME = std::move(other93.TIME);
  TIMESTAMP = std::move(other93.TIMESTAMP);
  INTEGER = std::move(other93.INTEGER);
  UNKNOWN = std::move(other93.UNKNOWN);
  JSON = std::move(other93.JSON);
  BSON = std::move(other93.BSON);
  UUID = std::move(other93.UUID);
  FLOAT16 = std::move(other93.FLOAT16);
  __isset = other93.__isset;
}
LogicalType& LogicalType::operator=(const LogicalType& other94) noexcept {
  STRING = other94.STRING;
  MAP = other94.MAP;
  LIST = other94.LIST;
  ENUM = other94.ENUM;
  DECIMAL = other94.DECIMAL;
  DATE = other94.DATE;
  TIME = other94.TIME;
  TIMESTAMP = other94.TIMESTAMP;
  INTEGER = other94.INTEGER;
  UNKNOWN = other94.UNKNOWN;
  JSON = other94.JSON;
  BSON = other94.BSON;
  UUID = other94.UUID;
  FLOAT16 = other94.FLOAT16;
  __isset = other94.__isset;
  return *this;
}
LogicalType& LogicalType::operator=(LogicalType&& other95) noexcept {
  STRING = std::move(other95.STRING);
  MAP = std::move(other95.MAP);
  LIST = std::move(other95.LIST);
  ENUM = std::move(other95.ENUM);
  DECIMAL = std::move(other95.DECIMAL);
  DATE = std::move(other95.DATE);
  TIME = std::move(other95.TIME);
  TIMESTAMP = std::move(other95.TIMESTAMP);
  INTEGER = std::move(other95.INTEGER);
  UNKNOWN = std::move(other95.UNKNOWN);
  JSON = std::move(other95.JSON);
  BSON = std::move(other95.BSON);
  UUID = std::move(other95.UUID);
  FLOAT16 = std::move(other95.FLOAT16);
  __isset = other95.__isset;
  return *this;
}
void LogicalType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "LogicalType(";
  out << "STRING="; (__isset.STRING ? (out << to_string(STRING)) : (out << "<null>"));
  out << ", " << "MAP="; (__isset.MAP ? (out << to_string(MAP)) : (out << "<null>"));
  out << ", " << "LIST="; (__isset.LIST ? (out << to_string(LIST)) : (out << "<null>"));
  out << ", " << "ENUM="; (__isset.ENUM ? (out << to_string(ENUM)) : (out << "<null>"));
  out << ", " << "DECIMAL="; (__isset.DECIMAL ? (out << to_string(DECIMAL)) : (out << "<null>"));
  out << ", " << "DATE="; (__isset.DATE ? (out << to_string(DATE)) : (out << "<null>"));
  out << ", " << "TIME="; (__isset.TIME ? (out << to_string(TIME)) : (out << "<null>"));
  out << ", " << "TIMESTAMP="; (__isset.TIMESTAMP ? (out << to_string(TIMESTAMP)) : (out << "<null>"));
  out << ", " << "INTEGER="; (__isset.INTEGER ? (out << to_string(INTEGER)) : (out << "<null>"));
  out << ", " << "UNKNOWN="; (__isset.UNKNOWN ? (out << to_string(UNKNOWN)) : (out << "<null>"));
  out << ", " << "JSON="; (__isset.JSON ? (out << to_string(JSON)) : (out << "<null>"));
  out << ", " << "BSON="; (__isset.BSON ? (out << to_string(BSON)) : (out << "<null>"));
  out << ", " << "UUID="; (__isset.UUID ? (out << to_string(UUID)) : (out << "<null>"));
  out << ", " << "FLOAT16="; (__isset.FLOAT16 ? (out << to_string(FLOAT16)) : (out << "<null>"));
  out << ")";
}


SchemaElement::~SchemaElement() noexcept {
}


void SchemaElement::__set_type(const Type::type val) {
  this->type = val;
__isset.type = true;
}

void SchemaElement::__set_type_length(const int32_t val) {
  this->type_length = val;
__isset.type_length = true;
}

void SchemaElement::__set_repetition_type(const FieldRepetitionType::type val) {
  this->repetition_type = val;
__isset.repetition_type = true;
}

void SchemaElement::__set_name(const std::string& val) {
  this->name = val;
}

void SchemaElement::__set_num_children(const int32_t val) {
  this->num_children = val;
__isset.num_children = true;
}

void SchemaElement::__set_converted_type(const ConvertedType::type val) {
  this->converted_type = val;
__isset.converted_type = true;
}

void SchemaElement::__set_scale(const int32_t val) {
  this->scale = val;
__isset.scale = true;
}

void SchemaElement::__set_precision(const int32_t val) {
  this->precision = val;
__isset.precision = true;
}

void SchemaElement::__set_field_id(const int32_t val) {
  this->field_id = val;
__isset.field_id = true;
}

void SchemaElement::__set_logicalType(const LogicalType& val) {
  this->logicalType = val;
__isset.logicalType = true;
}
std::ostream& operator<<(std::ostream& out, const SchemaElement& obj)
{
  obj.printTo(out);
  return out;
}


void swap(SchemaElement &a, SchemaElement &b) {
  using ::std::swap;
  swap(a.type, b.type);
  swap(a.type_length, b.type_length);
  swap(a.repetition_type, b.repetition_type);
  swap(a.name, b.name);
  swap(a.num_children, b.num_children);
  swap(a.converted_type, b.converted_type);
  swap(a.scale, b.scale);
  swap(a.precision, b.precision);
  swap(a.field_id, b.field_id);
  swap(a.logicalType, b.logicalType);
  swap(a.__isset, b.__isset);
}

SchemaElement::SchemaElement(const SchemaElement& other99) {
  type = other99.type;
  type_length = other99.type_length;
  repetition_type = other99.repetition_type;
  name = other99.name;
  num_children = other99.num_children;
  converted_type = other99.converted_type;
  scale = other99.scale;
  precision = other99.precision;
  field_id = other99.field_id;
  logicalType = other99.logicalType;
  __isset = other99.__isset;
}
SchemaElement::SchemaElement(SchemaElement&& other100) noexcept {
  type = other100.type;
  type_length = other100.type_length;
  repetition_type = other100.repetition_type;
  name = std::move(other100.name);
  num_children = other100.num_children;
  converted_type = other100.converted_type;
  scale = other100.scale;
  precision = other100.precision;
  field_id = other100.field_id;
  logicalType = std::move(other100.logicalType);
  __isset = other100.__isset;
}
SchemaElement& SchemaElement::operator=(const SchemaElement& other101) {
  type = other101.type;
  type_length = other101.type_length;
  repetition_type = other101.repetition_type;
  name = other101.name;
  num_children = other101.num_children;
  converted_type = other101.converted_type;
  scale = other101.scale;
  precision = other101.precision;
  field_id = other101.field_id;
  logicalType = other101.logicalType;
  __isset = other101.__isset;
  return *this;
}
SchemaElement& SchemaElement::operator=(SchemaElement&& other102) noexcept {
  type = other102.type;
  type_length = other102.type_length;
  repetition_type = other102.repetition_type;
  name = std::move(other102.name);
  num_children = other102.num_children;
  converted_type = other102.converted_type;
  scale = other102.scale;
  precision = other102.precision;
  field_id = other102.field_id;
  logicalType = std::move(other102.logicalType);
  __isset = other102.__isset;
  return *this;
}
void SchemaElement::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "SchemaElement(";
  out << "type="; (__isset.type ? (out << to_string(type)) : (out << "<null>"));
  out << ", " << "type_length="; (__isset.type_length ? (out << to_string(type_length)) : (out << "<null>"));
  out << ", " << "repetition_type="; (__isset.repetition_type ? (out << to_string(repetition_type)) : (out << "<null>"));
  out << ", " << "name=" << to_string(name);
  out << ", " << "num_children="; (__isset.num_children ? (out << to_string(num_children)) : (out << "<null>"));
  out << ", " << "converted_type="; (__isset.converted_type ? (out << to_string(converted_type)) : (out << "<null>"));
  out << ", " << "scale="; (__isset.scale ? (out << to_string(scale)) : (out << "<null>"));
  out << ", " << "precision="; (__isset.precision ? (out << to_string(precision)) : (out << "<null>"));
  out << ", " << "field_id="; (__isset.field_id ? (out << to_string(field_id)) : (out << "<null>"));
  out << ", " << "logicalType="; (__isset.logicalType ? (out << to_string(logicalType)) : (out << "<null>"));
  out << ")";
}


DataPageHeader::~DataPageHeader() noexcept {
}


void DataPageHeader::__set_num_values(const int32_t val) {
  this->num_values = val;
}

void DataPageHeader::__set_encoding(const Encoding::type val) {
  this->encoding = val;
}

void DataPageHeader::__set_definition_level_encoding(const Encoding::type val) {
  this->definition_level_encoding = val;
}

void DataPageHeader::__set_repetition_level_encoding(const Encoding::type val) {
  this->repetition_level_encoding = val;
}

void DataPageHeader::__set_statistics(const Statistics& val) {
  this->statistics = val;
__isset.statistics = true;
}
std::ostream& operator<<(std::ostream& out, const DataPageHeader& obj)
{
  obj.printTo(out);
  return out;
}


void swap(DataPageHeader &a, DataPageHeader &b) {
  using ::std::swap;
  swap(a.num_values, b.num_values);
  swap(a.encoding, b.encoding);
  swap(a.definition_level_encoding, b.definition_level_encoding);
  swap(a.repetition_level_encoding, b.repetition_level_encoding);
  swap(a.statistics, b.statistics);
  swap(a.__isset, b.__isset);
}

DataPageHeader::DataPageHeader(const DataPageHeader& other106) {
  num_values = other106.num_values;
  encoding = other106.encoding;
  definition_level_encoding = other106.definition_level_encoding;
  repetition_level_encoding = other106.repetition_level_encoding;
  statistics = other106.statistics;
  __isset = other106.__isset;
}
DataPageHeader::DataPageHeader(DataPageHeader&& other107) noexcept {
  num_values = other107.num_values;
  encoding = other107.encoding;
  definition_level_encoding = other107.definition_level_encoding;
  repetition_level_encoding = other107.repetition_level_encoding;
  statistics = std::move(other107.statistics);
  __isset = other107.__isset;
}
DataPageHeader& DataPageHeader::operator=(const DataPageHeader& other108) {
  num_values = other108.num_values;
  encoding = other108.encoding;
  definition_level_encoding = other108.definition_level_encoding;
  repetition_level_encoding = other108.repetition_level_encoding;
  statistics = other108.statistics;
  __isset = other108.__isset;
  return *this;
}
DataPageHeader& DataPageHeader::operator=(DataPageHeader&& other109) noexcept {
  num_values = other109.num_values;
  encoding = other109.encoding;
  definition_level_encoding = other109.definition_level_encoding;
  repetition_level_encoding = other109.repetition_level_encoding;
  statistics = std::move(other109.statistics);
  __isset = other109.__isset;
  return *this;
}
void DataPageHeader::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "DataPageHeader(";
  out << "num_values=" << to_string(num_values);
  out << ", " << "encoding=" << to_string(encoding);
  out << ", " << "definition_level_encoding=" << to_string(definition_level_encoding);
  out << ", " << "repetition_level_encoding=" << to_string(repetition_level_encoding);
  out << ", " << "statistics="; (__isset.statistics ? (out << to_string(statistics)) : (out << "<null>"));
  out << ")";
}


IndexPageHeader::~IndexPageHeader() noexcept {
}

std::ostream& operator<<(std::ostream& out, const IndexPageHeader& obj)
{
  obj.printTo(out);
  return out;
}


void swap(IndexPageHeader &a, IndexPageHeader &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

IndexPageHeader::IndexPageHeader(const IndexPageHeader& other110) noexcept {
  (void) other110;
}
IndexPageHeader::IndexPageHeader(IndexPageHeader&& other111) noexcept {
  (void) other111;
}
IndexPageHeader& IndexPageHeader::operator=(const IndexPageHeader& other112) noexcept {
  (void) other112;
  return *this;
}
IndexPageHeader& IndexPageHeader::operator=(IndexPageHeader&& other113) noexcept {
  (void) other113;
  return *this;
}
void IndexPageHeader::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "IndexPageHeader(";
  out << ")";
}


DictionaryPageHeader::~DictionaryPageHeader() noexcept {
}


void DictionaryPageHeader::__set_num_values(const int32_t val) {
  this->num_values = val;
}

void DictionaryPageHeader::__set_encoding(const Encoding::type val) {
  this->encoding = val;
}

void DictionaryPageHeader::__set_is_sorted(const bool val) {
  this->is_sorted = val;
__isset.is_sorted = true;
}
std::ostream& operator<<(std::ostream& out, const DictionaryPageHeader& obj)
{
  obj.printTo(out);
  return out;
}


void swap(DictionaryPageHeader &a, DictionaryPageHeader &b) {
  using ::std::swap;
  swap(a.num_values, b.num_values);
  swap(a.encoding, b.encoding);
  swap(a.is_sorted, b.is_sorted);
  swap(a.__isset, b.__isset);
}

DictionaryPageHeader::DictionaryPageHeader(const DictionaryPageHeader& other115) noexcept {
  num_values = other115.num_values;
  encoding = other115.encoding;
  is_sorted = other115.is_sorted;
  __isset = other115.__isset;
}
DictionaryPageHeader::DictionaryPageHeader(DictionaryPageHeader&& other116) noexcept {
  num_values = other116.num_values;
  encoding = other116.encoding;
  is_sorted = other116.is_sorted;
  __isset = other116.__isset;
}
DictionaryPageHeader& DictionaryPageHeader::operator=(const DictionaryPageHeader& other117) noexcept {
  num_values = other117.num_values;
  encoding = other117.encoding;
  is_sorted = other117.is_sorted;
  __isset = other117.__isset;
  return *this;
}
DictionaryPageHeader& DictionaryPageHeader::operator=(DictionaryPageHeader&& other118) noexcept {
  num_values = other118.num_values;
  encoding = other118.encoding;
  is_sorted = other118.is_sorted;
  __isset = other118.__isset;
  return *this;
}
void DictionaryPageHeader::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "DictionaryPageHeader(";
  out << "num_values=" << to_string(num_values);
  out << ", " << "encoding=" << to_string(encoding);
  out << ", " << "is_sorted="; (__isset.is_sorted ? (out << to_string(is_sorted)) : (out << "<null>"));
  out << ")";
}


DataPageHeaderV2::~DataPageHeaderV2() noexcept {
}


void DataPageHeaderV2::__set_num_values(const int32_t val) {
  this->num_values = val;
}

void DataPageHeaderV2::__set_num_nulls(const int32_t val) {
  this->num_nulls = val;
}

void DataPageHeaderV2::__set_num_rows(const int32_t val) {
  this->num_rows = val;
}

void DataPageHeaderV2::__set_encoding(const Encoding::type val) {
  this->encoding = val;
}

void DataPageHeaderV2::__set_definition_levels_byte_length(const int32_t val) {
  this->definition_levels_byte_length = val;
}

void DataPageHeaderV2::__set_repetition_levels_byte_length(const int32_t val) {
  this->repetition_levels_byte_length = val;
}

void DataPageHeaderV2::__set_is_compressed(const bool val) {
  this->is_compressed = val;
__isset.is_compressed = true;
}

void DataPageHeaderV2::__set_statistics(const Statistics& val) {
  this->statistics = val;
__isset.statistics = true;
}
std::ostream& operator<<(std::ostream& out, const DataPageHeaderV2& obj)
{
  obj.printTo(out);
  return out;
}


void swap(DataPageHeaderV2 &a, DataPageHeaderV2 &b) {
  using ::std::swap;
  swap(a.num_values, b.num_values);
  swap(a.num_nulls, b.num_nulls);
  swap(a.num_rows, b.num_rows);
  swap(a.encoding, b.encoding);
  swap(a.definition_levels_byte_length, b.definition_levels_byte_length);
  swap(a.repetition_levels_byte_length, b.repetition_levels_byte_length);
  swap(a.is_compressed, b.is_compressed);
  swap(a.statistics, b.statistics);
  swap(a.__isset, b.__isset);
}

DataPageHeaderV2::DataPageHeaderV2(const DataPageHeaderV2& other120) {
  num_values = other120.num_values;
  num_nulls = other120.num_nulls;
  num_rows = other120.num_rows;
  encoding = other120.encoding;
  definition_levels_byte_length = other120.definition_levels_byte_length;
  repetition_levels_byte_length = other120.repetition_levels_byte_length;
  is_compressed = other120.is_compressed;
  statistics = other120.statistics;
  __isset = other120.__isset;
}
DataPageHeaderV2::DataPageHeaderV2(DataPageHeaderV2&& other121) noexcept {
  num_values = other121.num_values;
  num_nulls = other121.num_nulls;
  num_rows = other121.num_rows;
  encoding = other121.encoding;
  definition_levels_byte_length = other121.definition_levels_byte_length;
  repetition_levels_byte_length = other121.repetition_levels_byte_length;
  is_compressed = other121.is_compressed;
  statistics = std::move(other121.statistics);
  __isset = other121.__isset;
}
DataPageHeaderV2& DataPageHeaderV2::operator=(const DataPageHeaderV2& other122) {
  num_values = other122.num_values;
  num_nulls = other122.num_nulls;
  num_rows = other122.num_rows;
  encoding = other122.encoding;
  definition_levels_byte_length = other122.definition_levels_byte_length;
  repetition_levels_byte_length = other122.repetition_levels_byte_length;
  is_compressed = other122.is_compressed;
  statistics = other122.statistics;
  __isset = other122.__isset;
  return *this;
}
DataPageHeaderV2& DataPageHeaderV2::operator=(DataPageHeaderV2&& other123) noexcept {
  num_values = other123.num_values;
  num_nulls = other123.num_nulls;
  num_rows = other123.num_rows;
  encoding = other123.encoding;
  definition_levels_byte_length = other123.definition_levels_byte_length;
  repetition_levels_byte_length = other123.repetition_levels_byte_length;
  is_compressed = other123.is_compressed;
  statistics = std::move(other123.statistics);
  __isset = other123.__isset;
  return *this;
}
void DataPageHeaderV2::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "DataPageHeaderV2(";
  out << "num_values=" << to_string(num_values);
  out << ", " << "num_nulls=" << to_string(num_nulls);
  out << ", " << "num_rows=" << to_string(num_rows);
  out << ", " << "encoding=" << to_string(encoding);
  out << ", " << "definition_levels_byte_length=" << to_string(definition_levels_byte_length);
  out << ", " << "repetition_levels_byte_length=" << to_string(repetition_levels_byte_length);
  out << ", " << "is_compressed="; (__isset.is_compressed ? (out << to_string(is_compressed)) : (out << "<null>"));
  out << ", " << "statistics="; (__isset.statistics ? (out << to_string(statistics)) : (out << "<null>"));
  out << ")";
}


SplitBlockAlgorithm::~SplitBlockAlgorithm() noexcept {
}

std::ostream& operator<<(std::ostream& out, const SplitBlockAlgorithm& obj)
{
  obj.printTo(out);
  return out;
}


void swap(SplitBlockAlgorithm &a, SplitBlockAlgorithm &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

SplitBlockAlgorithm::SplitBlockAlgorithm(const SplitBlockAlgorithm& other124) noexcept {
  (void) other124;
}
SplitBlockAlgorithm::SplitBlockAlgorithm(SplitBlockAlgorithm&& other125) noexcept {
  (void) other125;
}
SplitBlockAlgorithm& SplitBlockAlgorithm::operator=(const SplitBlockAlgorithm& other126) noexcept {
  (void) other126;
  return *this;
}
SplitBlockAlgorithm& SplitBlockAlgorithm::operator=(SplitBlockAlgorithm&& other127) noexcept {
  (void) other127;
  return *this;
}
void SplitBlockAlgorithm::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "SplitBlockAlgorithm(";
  out << ")";
}


BloomFilterAlgorithm::~BloomFilterAlgorithm() noexcept {
}


void BloomFilterAlgorithm::__set_BLOCK(const SplitBlockAlgorithm& val) {
  this->BLOCK = val;
__isset.BLOCK = true;
}
std::ostream& operator<<(std::ostream& out, const BloomFilterAlgorithm& obj)
{
  obj.printTo(out);
  return out;
}


void swap(BloomFilterAlgorithm &a, BloomFilterAlgorithm &b) {
  using ::std::swap;
  swap(a.BLOCK, b.BLOCK);
  swap(a.__isset, b.__isset);
}

BloomFilterAlgorithm::BloomFilterAlgorithm(const BloomFilterAlgorithm& other128) noexcept {
  BLOCK = other128.BLOCK;
  __isset = other128.__isset;
}
BloomFilterAlgorithm::BloomFilterAlgorithm(BloomFilterAlgorithm&& other129) noexcept {
  BLOCK = std::move(other129.BLOCK);
  __isset = other129.__isset;
}
BloomFilterAlgorithm& BloomFilterAlgorithm::operator=(const BloomFilterAlgorithm& other130) noexcept {
  BLOCK = other130.BLOCK;
  __isset = other130.__isset;
  return *this;
}
BloomFilterAlgorithm& BloomFilterAlgorithm::operator=(BloomFilterAlgorithm&& other131) noexcept {
  BLOCK = std::move(other131.BLOCK);
  __isset = other131.__isset;
  return *this;
}
void BloomFilterAlgorithm::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "BloomFilterAlgorithm(";
  out << "BLOCK="; (__isset.BLOCK ? (out << to_string(BLOCK)) : (out << "<null>"));
  out << ")";
}


XxHash::~XxHash() noexcept {
}

std::ostream& operator<<(std::ostream& out, const XxHash& obj)
{
  obj.printTo(out);
  return out;
}


void swap(XxHash &a, XxHash &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

XxHash::XxHash(const XxHash& other132) noexcept {
  (void) other132;
}
XxHash::XxHash(XxHash&& other133) noexcept {
  (void) other133;
}
XxHash& XxHash::operator=(const XxHash& other134) noexcept {
  (void) other134;
  return *this;
}
XxHash& XxHash::operator=(XxHash&& other135) noexcept {
  (void) other135;
  return *this;
}
void XxHash::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "XxHash(";
  out << ")";
}


BloomFilterHash::~BloomFilterHash() noexcept {
}


void BloomFilterHash::__set_XXHASH(const XxHash& val) {
  this->XXHASH = val;
__isset.XXHASH = true;
}
std::ostream& operator<<(std::ostream& out, const BloomFilterHash& obj)
{
  obj.printTo(out);
  return out;
}


void swap(BloomFilterHash &a, BloomFilterHash &b) {
  using ::std::swap;
  swap(a.XXHASH, b.XXHASH);
  swap(a.__isset, b.__isset);
}

BloomFilterHash::BloomFilterHash(const BloomFilterHash& other136) noexcept {
  XXHASH = other136.XXHASH;
  __isset = other136.__isset;
}
BloomFilterHash::BloomFilterHash(BloomFilterHash&& other137) noexcept {
  XXHASH = std::move(other137.XXHASH);
  __isset = other137.__isset;
}
BloomFilterHash& BloomFilterHash::operator=(const BloomFilterHash& other138) noexcept {
  XXHASH = other138.XXHASH;
  __isset = other138.__isset;
  return *this;
}
BloomFilterHash& BloomFilterHash::operator=(BloomFilterHash&& other139) noexcept {
  XXHASH = std::move(other139.XXHASH);
  __isset = other139.__isset;
  return *this;
}
void BloomFilterHash::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "BloomFilterHash(";
  out << "XXHASH="; (__isset.XXHASH ? (out << to_string(XXHASH)) : (out << "<null>"));
  out << ")";
}


Uncompressed::~Uncompressed() noexcept {
}

std::ostream& operator<<(std::ostream& out, const Uncompressed& obj)
{
  obj.printTo(out);
  return out;
}


void swap(Uncompressed &a, Uncompressed &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

Uncompressed::Uncompressed(const Uncompressed& other140) noexcept {
  (void) other140;
}
Uncompressed::Uncompressed(Uncompressed&& other141) noexcept {
  (void) other141;
}
Uncompressed& Uncompressed::operator=(const Uncompressed& other142) noexcept {
  (void) other142;
  return *this;
}
Uncompressed& Uncompressed::operator=(Uncompressed&& other143) noexcept {
  (void) other143;
  return *this;
}
void Uncompressed::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "Uncompressed(";
  out << ")";
}


BloomFilterCompression::~BloomFilterCompression() noexcept {
}


void BloomFilterCompression::__set_UNCOMPRESSED(const Uncompressed& val) {
  this->UNCOMPRESSED = val;
__isset.UNCOMPRESSED = true;
}
std::ostream& operator<<(std::ostream& out, const BloomFilterCompression& obj)
{
  obj.printTo(out);
  return out;
}


void swap(BloomFilterCompression &a, BloomFilterCompression &b) {
  using ::std::swap;
  swap(a.UNCOMPRESSED, b.UNCOMPRESSED);
  swap(a.__isset, b.__isset);
}

BloomFilterCompression::BloomFilterCompression(const BloomFilterCompression& other144) noexcept {
  UNCOMPRESSED = other144.UNCOMPRESSED;
  __isset = other144.__isset;
}
BloomFilterCompression::BloomFilterCompression(BloomFilterCompression&& other145) noexcept {
  UNCOMPRESSED = std::move(other145.UNCOMPRESSED);
  __isset = other145.__isset;
}
BloomFilterCompression& BloomFilterCompression::operator=(const BloomFilterCompression& other146) noexcept {
  UNCOMPRESSED = other146.UNCOMPRESSED;
  __isset = other146.__isset;
  return *this;
}
BloomFilterCompression& BloomFilterCompression::operator=(BloomFilterCompression&& other147) noexcept {
  UNCOMPRESSED = std::move(other147.UNCOMPRESSED);
  __isset = other147.__isset;
  return *this;
}
void BloomFilterCompression::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "BloomFilterCompression(";
  out << "UNCOMPRESSED="; (__isset.UNCOMPRESSED ? (out << to_string(UNCOMPRESSED)) : (out << "<null>"));
  out << ")";
}


BloomFilterHeader::~BloomFilterHeader() noexcept {
}


void BloomFilterHeader::__set_numBytes(const int32_t val) {
  this->numBytes = val;
}

void BloomFilterHeader::__set_algorithm(const BloomFilterAlgorithm& val) {
  this->algorithm = val;
}

void BloomFilterHeader::__set_hash(const BloomFilterHash& val) {
  this->hash = val;
}

void BloomFilterHeader::__set_compression(const BloomFilterCompression& val) {
  this->compression = val;
}
std::ostream& operator<<(std::ostream& out, const BloomFilterHeader& obj)
{
  obj.printTo(out);
  return out;
}


void swap(BloomFilterHeader &a, BloomFilterHeader &b) {
  using ::std::swap;
  swap(a.numBytes, b.numBytes);
  swap(a.algorithm, b.algorithm);
  swap(a.hash, b.hash);
  swap(a.compression, b.compression);
}

BloomFilterHeader::BloomFilterHeader(const BloomFilterHeader& other148) noexcept {
  numBytes = other148.numBytes;
  algorithm = other148.algorithm;
  hash = other148.hash;
  compression = other148.compression;
}
BloomFilterHeader::BloomFilterHeader(BloomFilterHeader&& other149) noexcept {
  numBytes = other149.numBytes;
  algorithm = std::move(other149.algorithm);
  hash = std::move(other149.hash);
  compression = std::move(other149.compression);
}
BloomFilterHeader& BloomFilterHeader::operator=(const BloomFilterHeader& other150) noexcept {
  numBytes = other150.numBytes;
  algorithm = other150.algorithm;
  hash = other150.hash;
  compression = other150.compression;
  return *this;
}
BloomFilterHeader& BloomFilterHeader::operator=(BloomFilterHeader&& other151) noexcept {
  numBytes = other151.numBytes;
  algorithm = std::move(other151.algorithm);
  hash = std::move(other151.hash);
  compression = std::move(other151.compression);
  return *this;
}
void BloomFilterHeader::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "BloomFilterHeader(";
  out << "numBytes=" << to_string(numBytes);
  out << ", " << "algorithm=" << to_string(algorithm);
  out << ", " << "hash=" << to_string(hash);
  out << ", " << "compression=" << to_string(compression);
  out << ")";
}


PageHeader::~PageHeader() noexcept {
}


void PageHeader::__set_type(const PageType::type val) {
  this->type = val;
}

void PageHeader::__set_uncompressed_page_size(const int32_t val) {
  this->uncompressed_page_size = val;
}

void PageHeader::__set_compressed_page_size(const int32_t val) {
  this->compressed_page_size = val;
}

void PageHeader::__set_crc(const int32_t val) {
  this->crc = val;
__isset.crc = true;
}

void PageHeader::__set_data_page_header(const DataPageHeader& val) {
  this->data_page_header = val;
__isset.data_page_header = true;
}

void PageHeader::__set_index_page_header(const IndexPageHeader& val) {
  this->index_page_header = val;
__isset.index_page_header = true;
}

void PageHeader::__set_dictionary_page_header(const DictionaryPageHeader& val) {
  this->dictionary_page_header = val;
__isset.dictionary_page_header = true;
}

void PageHeader::__set_data_page_header_v2(const DataPageHeaderV2& val) {
  this->data_page_header_v2 = val;
__isset.data_page_header_v2 = true;
}
std::ostream& operator<<(std::ostream& out, const PageHeader& obj)
{
  obj.printTo(out);
  return out;
}


void swap(PageHeader &a, PageHeader &b) {
  using ::std::swap;
  swap(a.type, b.type);
  swap(a.uncompressed_page_size, b.uncompressed_page_size);
  swap(a.compressed_page_size, b.compressed_page_size);
  swap(a.crc, b.crc);
  swap(a.data_page_header, b.data_page_header);
  swap(a.index_page_header, b.index_page_header);
  swap(a.dictionary_page_header, b.dictionary_page_header);
  swap(a.data_page_header_v2, b.data_page_header_v2);
  swap(a.__isset, b.__isset);
}

PageHeader::PageHeader(const PageHeader& other153) {
  type = other153.type;
  uncompressed_page_size = other153.uncompressed_page_size;
  compressed_page_size = other153.compressed_page_size;
  crc = other153.crc;
  data_page_header = other153.data_page_header;
  index_page_header = other153.index_page_header;
  dictionary_page_header = other153.dictionary_page_header;
  data_page_header_v2 = other153.data_page_header_v2;
  __isset = other153.__isset;
}
PageHeader::PageHeader(PageHeader&& other154) noexcept {
  type = other154.type;
  uncompressed_page_size = other154.uncompressed_page_size;
  compressed_page_size = other154.compressed_page_size;
  crc = other154.crc;
  data_page_header = std::move(other154.data_page_header);
  index_page_header = std::move(other154.index_page_header);
  dictionary_page_header = std::move(other154.dictionary_page_header);
  data_page_header_v2 = std::move(other154.data_page_header_v2);
  __isset = other154.__isset;
}
PageHeader& PageHeader::operator=(const PageHeader& other155) {
  type = other155.type;
  uncompressed_page_size = other155.uncompressed_page_size;
  compressed_page_size = other155.compressed_page_size;
  crc = other155.crc;
  data_page_header = other155.data_page_header;
  index_page_header = other155.index_page_header;
  dictionary_page_header = other155.dictionary_page_header;
  data_page_header_v2 = other155.data_page_header_v2;
  __isset = other155.__isset;
  return *this;
}
PageHeader& PageHeader::operator=(PageHeader&& other156) noexcept {
  type = other156.type;
  uncompressed_page_size = other156.uncompressed_page_size;
  compressed_page_size = other156.compressed_page_size;
  crc = other156.crc;
  data_page_header = std::move(other156.data_page_header);
  index_page_header = std::move(other156.index_page_header);
  dictionary_page_header = std::move(other156.dictionary_page_header);
  data_page_header_v2 = std::move(other156.data_page_header_v2);
  __isset = other156.__isset;
  return *this;
}
void PageHeader::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "PageHeader(";
  out << "type=" << to_string(type);
  out << ", " << "uncompressed_page_size=" << to_string(uncompressed_page_size);
  out << ", " << "compressed_page_size=" << to_string(compressed_page_size);
  out << ", " << "crc="; (__isset.crc ? (out << to_string(crc)) : (out << "<null>"));
  out << ", " << "data_page_header="; (__isset.data_page_header ? (out << to_string(data_page_header)) : (out << "<null>"));
  out << ", " << "index_page_header="; (__isset.index_page_header ? (out << to_string(index_page_header)) : (out << "<null>"));
  out << ", " << "dictionary_page_header="; (__isset.dictionary_page_header ? (out << to_string(dictionary_page_header)) : (out << "<null>"));
  out << ", " << "data_page_header_v2="; (__isset.data_page_header_v2 ? (out << to_string(data_page_header_v2)) : (out << "<null>"));
  out << ")";
}


KeyValue::~KeyValue() noexcept {
}


void KeyValue::__set_key(const std::string& val) {
  this->key = val;
}

void KeyValue::__set_value(const std::string& val) {
  this->value = val;
__isset.value = true;
}
std::ostream& operator<<(std::ostream& out, const KeyValue& obj)
{
  obj.printTo(out);
  return out;
}


void swap(KeyValue &a, KeyValue &b) {
  using ::std::swap;
  swap(a.key, b.key);
  swap(a.value, b.value);
  swap(a.__isset, b.__isset);
}

KeyValue::KeyValue(const KeyValue& other157) {
  key = other157.key;
  value = other157.value;
  __isset = other157.__isset;
}
KeyValue::KeyValue(KeyValue&& other158) noexcept {
  key = std::move(other158.key);
  value = std::move(other158.value);
  __isset = other158.__isset;
}
KeyValue& KeyValue::operator=(const KeyValue& other159) {
  key = other159.key;
  value = other159.value;
  __isset = other159.__isset;
  return *this;
}
KeyValue& KeyValue::operator=(KeyValue&& other160) noexcept {
  key = std::move(other160.key);
  value = std::move(other160.value);
  __isset = other160.__isset;
  return *this;
}
void KeyValue::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "KeyValue(";
  out << "key=" << to_string(key);
  out << ", " << "value="; (__isset.value ? (out << to_string(value)) : (out << "<null>"));
  out << ")";
}


SortingColumn::~SortingColumn() noexcept {
}


void SortingColumn::__set_column_idx(const int32_t val) {
  this->column_idx = val;
}

void SortingColumn::__set_descending(const bool val) {
  this->descending = val;
}

void SortingColumn::__set_nulls_first(const bool val) {
  this->nulls_first = val;
}
std::ostream& operator<<(std::ostream& out, const SortingColumn& obj)
{
  obj.printTo(out);
  return out;
}


void swap(SortingColumn &a, SortingColumn &b) {
  using ::std::swap;
  swap(a.column_idx, b.column_idx);
  swap(a.descending, b.descending);
  swap(a.nulls_first, b.nulls_first);
}

SortingColumn::SortingColumn(const SortingColumn& other161) noexcept {
  column_idx = other161.column_idx;
  descending = other161.descending;
  nulls_first = other161.nulls_first;
}
SortingColumn::SortingColumn(SortingColumn&& other162) noexcept {
  column_idx = other162.column_idx;
  descending = other162.descending;
  nulls_first = other162.nulls_first;
}
SortingColumn& SortingColumn::operator=(const SortingColumn& other163) noexcept {
  column_idx = other163.column_idx;
  descending = other163.descending;
  nulls_first = other163.nulls_first;
  return *this;
}
SortingColumn& SortingColumn::operator=(SortingColumn&& other164) noexcept {
  column_idx = other164.column_idx;
  descending = other164.descending;
  nulls_first = other164.nulls_first;
  return *this;
}
void SortingColumn::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "SortingColumn(";
  out << "column_idx=" << to_string(column_idx);
  out << ", " << "descending=" << to_string(descending);
  out << ", " << "nulls_first=" << to_string(nulls_first);
  out << ")";
}


PageEncodingStats::~PageEncodingStats() noexcept {
}


void PageEncodingStats::__set_page_type(const PageType::type val) {
  this->page_type = val;
}

void PageEncodingStats::__set_encoding(const Encoding::type val) {
  this->encoding = val;
}

void PageEncodingStats::__set_count(const int32_t val) {
  this->count = val;
}
std::ostream& operator<<(std::ostream& out, const PageEncodingStats& obj)
{
  obj.printTo(out);
  return out;
}


void swap(PageEncodingStats &a, PageEncodingStats &b) {
  using ::std::swap;
  swap(a.page_type, b.page_type);
  swap(a.encoding, b.encoding);
  swap(a.count, b.count);
}

PageEncodingStats::PageEncodingStats(const PageEncodingStats& other167) noexcept {
  page_type = other167.page_type;
  encoding = other167.encoding;
  count = other167.count;
}
PageEncodingStats::PageEncodingStats(PageEncodingStats&& other168) noexcept {
  page_type = other168.page_type;
  encoding = other168.encoding;
  count = other168.count;
}
PageEncodingStats& PageEncodingStats::operator=(const PageEncodingStats& other169) noexcept {
  page_type = other169.page_type;
  encoding = other169.encoding;
  count = other169.count;
  return *this;
}
PageEncodingStats& PageEncodingStats::operator=(PageEncodingStats&& other170) noexcept {
  page_type = other170.page_type;
  encoding = other170.encoding;
  count = other170.count;
  return *this;
}
void PageEncodingStats::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "PageEncodingStats(";
  out << "page_type=" << to_string(page_type);
  out << ", " << "encoding=" << to_string(encoding);
  out << ", " << "count=" << to_string(count);
  out << ")";
}


ColumnMetaData::~ColumnMetaData() noexcept {
}


void ColumnMetaData::__set_type(const Type::type val) {
  this->type = val;
}

void ColumnMetaData::__set_encodings(const std::vector<Encoding::type> & val) {
  this->encodings = val;
}

void ColumnMetaData::__set_path_in_schema(const std::vector<std::string> & val) {
  this->path_in_schema = val;
}

void ColumnMetaData::__set_codec(const CompressionCodec::type val) {
  this->codec = val;
}

void ColumnMetaData::__set_num_values(const int64_t val) {
  this->num_values = val;
}

void ColumnMetaData::__set_total_uncompressed_size(const int64_t val) {
  this->total_uncompressed_size = val;
}

void ColumnMetaData::__set_total_compressed_size(const int64_t val) {
  this->total_compressed_size = val;
}

void ColumnMetaData::__set_key_value_metadata(const std::vector<KeyValue> & val) {
  this->key_value_metadata = val;
__isset.key_value_metadata = true;
}

void ColumnMetaData::__set_data_page_offset(const int64_t val) {
  this->data_page_offset = val;
}

void ColumnMetaData::__set_index_page_offset(const int64_t val) {
  this->index_page_offset = val;
__isset.index_page_offset = true;
}

void ColumnMetaData::__set_dictionary_page_offset(const int64_t val) {
  this->dictionary_page_offset = val;
__isset.dictionary_page_offset = true;
}

void ColumnMetaData::__set_statistics(const Statistics& val) {
  this->statistics = val;
__isset.statistics = true;
}

void ColumnMetaData::__set_encoding_stats(const std::vector<PageEncodingStats> & val) {
  this->encoding_stats = val;
__isset.encoding_stats = true;
}

void ColumnMetaData::__set_bloom_filter_offset(const int64_t val) {
  this->bloom_filter_offset = val;
__isset.bloom_filter_offset = true;
}

void ColumnMetaData::__set_bloom_filter_length(const int32_t val) {
  this->bloom_filter_length = val;
__isset.bloom_filter_length = true;
}

void ColumnMetaData::__set_size_statistics(const SizeStatistics& val) {
  this->size_statistics = val;
__isset.size_statistics = true;
}
std::ostream& operator<<(std::ostream& out, const ColumnMetaData& obj)
{
  obj.printTo(out);
  return out;
}


void swap(ColumnMetaData &a, ColumnMetaData &b) {
  using ::std::swap;
  swap(a.type, b.type);
  swap(a.encodings, b.encodings);
  swap(a.path_in_schema, b.path_in_schema);
  swap(a.codec, b.codec);
  swap(a.num_values, b.num_values);
  swap(a.total_uncompressed_size, b.total_uncompressed_size);
  swap(a.total_compressed_size, b.total_compressed_size);
  swap(a.key_value_metadata, b.key_value_metadata);
  swap(a.data_page_offset, b.data_page_offset);
  swap(a.index_page_offset, b.index_page_offset);
  swap(a.dictionary_page_offset, b.dictionary_page_offset);
  swap(a.statistics, b.statistics);
  swap(a.encoding_stats, b.encoding_stats);
  swap(a.bloom_filter_offset, b.bloom_filter_offset);
  swap(a.bloom_filter_length, b.bloom_filter_length);
  swap(a.size_statistics, b.size_statistics);
  swap(a.__isset, b.__isset);
}

ColumnMetaData::ColumnMetaData(const ColumnMetaData& other198) {
  type = other198.type;
  encodings = other198.encodings;
  path_in_schema = other198.path_in_schema;
  codec = other198.codec;
  num_values = other198.num_values;
  total_uncompressed_size = other198.total_uncompressed_size;
  total_compressed_size = other198.total_compressed_size;
  key_value_metadata = other198.key_value_metadata;
  data_page_offset = other198.data_page_offset;
  index_page_offset = other198.index_page_offset;
  dictionary_page_offset = other198.dictionary_page_offset;
  statistics = other198.statistics;
  encoding_stats = other198.encoding_stats;
  bloom_filter_offset = other198.bloom_filter_offset;
  bloom_filter_length = other198.bloom_filter_length;
  size_statistics = other198.size_statistics;
  __isset = other198.__isset;
}
ColumnMetaData::ColumnMetaData(ColumnMetaData&& other199) noexcept {
  type = other199.type;
  encodings = std::move(other199.encodings);
  path_in_schema = std::move(other199.path_in_schema);
  codec = other199.codec;
  num_values = other199.num_values;
  total_uncompressed_size = other199.total_uncompressed_size;
  total_compressed_size = other199.total_compressed_size;
  key_value_metadata = std::move(other199.key_value_metadata);
  data_page_offset = other199.data_page_offset;
  index_page_offset = other199.index_page_offset;
  dictionary_page_offset = other199.dictionary_page_offset;
  statistics = std::move(other199.statistics);
  encoding_stats = std::move(other199.encoding_stats);
  bloom_filter_offset = other199.bloom_filter_offset;
  bloom_filter_length = other199.bloom_filter_length;
  size_statistics = std::move(other199.size_statistics);
  __isset = other199.__isset;
}
ColumnMetaData& ColumnMetaData::operator=(const ColumnMetaData& other200) {
  type = other200.type;
  encodings = other200.encodings;
  path_in_schema = other200.path_in_schema;
  codec = other200.codec;
  num_values = other200.num_values;
  total_uncompressed_size = other200.total_uncompressed_size;
  total_compressed_size = other200.total_compressed_size;
  key_value_metadata = other200.key_value_metadata;
  data_page_offset = other200.data_page_offset;
  index_page_offset = other200.index_page_offset;
  dictionary_page_offset = other200.dictionary_page_offset;
  statistics = other200.statistics;
  encoding_stats = other200.encoding_stats;
  bloom_filter_offset = other200.bloom_filter_offset;
  bloom_filter_length = other200.bloom_filter_length;
  size_statistics = other200.size_statistics;
  __isset = other200.__isset;
  return *this;
}
ColumnMetaData& ColumnMetaData::operator=(ColumnMetaData&& other201) noexcept {
  type = other201.type;
  encodings = std::move(other201.encodings);
  path_in_schema = std::move(other201.path_in_schema);
  codec = other201.codec;
  num_values = other201.num_values;
  total_uncompressed_size = other201.total_uncompressed_size;
  total_compressed_size = other201.total_compressed_size;
  key_value_metadata = std::move(other201.key_value_metadata);
  data_page_offset = other201.data_page_offset;
  index_page_offset = other201.index_page_offset;
  dictionary_page_offset = other201.dictionary_page_offset;
  statistics = std::move(other201.statistics);
  encoding_stats = std::move(other201.encoding_stats);
  bloom_filter_offset = other201.bloom_filter_offset;
  bloom_filter_length = other201.bloom_filter_length;
  size_statistics = std::move(other201.size_statistics);
  __isset = other201.__isset;
  return *this;
}
void ColumnMetaData::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ColumnMetaData(";
  out << "type=" << to_string(type);
  out << ", " << "encodings=" << to_string(encodings);
  out << ", " << "path_in_schema=" << to_string(path_in_schema);
  out << ", " << "codec=" << to_string(codec);
  out << ", " << "num_values=" << to_string(num_values);
  out << ", " << "total_uncompressed_size=" << to_string(total_uncompressed_size);
  out << ", " << "total_compressed_size=" << to_string(total_compressed_size);
  out << ", " << "key_value_metadata="; (__isset.key_value_metadata ? (out << to_string(key_value_metadata)) : (out << "<null>"));
  out << ", " << "data_page_offset=" << to_string(data_page_offset);
  out << ", " << "index_page_offset="; (__isset.index_page_offset ? (out << to_string(index_page_offset)) : (out << "<null>"));
  out << ", " << "dictionary_page_offset="; (__isset.dictionary_page_offset ? (out << to_string(dictionary_page_offset)) : (out << "<null>"));
  out << ", " << "statistics="; (__isset.statistics ? (out << to_string(statistics)) : (out << "<null>"));
  out << ", " << "encoding_stats="; (__isset.encoding_stats ? (out << to_string(encoding_stats)) : (out << "<null>"));
  out << ", " << "bloom_filter_offset="; (__isset.bloom_filter_offset ? (out << to_string(bloom_filter_offset)) : (out << "<null>"));
  out << ", " << "bloom_filter_length="; (__isset.bloom_filter_length ? (out << to_string(bloom_filter_length)) : (out << "<null>"));
  out << ", " << "size_statistics="; (__isset.size_statistics ? (out << to_string(size_statistics)) : (out << "<null>"));
  out << ")";
}


EncryptionWithFooterKey::~EncryptionWithFooterKey() noexcept {
}

std::ostream& operator<<(std::ostream& out, const EncryptionWithFooterKey& obj)
{
  obj.printTo(out);
  return out;
}


void swap(EncryptionWithFooterKey &a, EncryptionWithFooterKey &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

EncryptionWithFooterKey::EncryptionWithFooterKey(const EncryptionWithFooterKey& other202) noexcept {
  (void) other202;
}
EncryptionWithFooterKey::EncryptionWithFooterKey(EncryptionWithFooterKey&& other203) noexcept {
  (void) other203;
}
EncryptionWithFooterKey& EncryptionWithFooterKey::operator=(const EncryptionWithFooterKey& other204) noexcept {
  (void) other204;
  return *this;
}
EncryptionWithFooterKey& EncryptionWithFooterKey::operator=(EncryptionWithFooterKey&& other205) noexcept {
  (void) other205;
  return *this;
}
void EncryptionWithFooterKey::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "EncryptionWithFooterKey(";
  out << ")";
}


EncryptionWithColumnKey::~EncryptionWithColumnKey() noexcept {
}


void EncryptionWithColumnKey::__set_path_in_schema(const std::vector<std::string> & val) {
  this->path_in_schema = val;
}

void EncryptionWithColumnKey::__set_key_metadata(const std::string& val) {
  this->key_metadata = val;
__isset.key_metadata = true;
}
std::ostream& operator<<(std::ostream& out, const EncryptionWithColumnKey& obj)
{
  obj.printTo(out);
  return out;
}


void swap(EncryptionWithColumnKey &a, EncryptionWithColumnKey &b) {
  using ::std::swap;
  swap(a.path_in_schema, b.path_in_schema);
  swap(a.key_metadata, b.key_metadata);
  swap(a.__isset, b.__isset);
}

EncryptionWithColumnKey::EncryptionWithColumnKey(const EncryptionWithColumnKey& other212) {
  path_in_schema = other212.path_in_schema;
  key_metadata = other212.key_metadata;
  __isset = other212.__isset;
}
EncryptionWithColumnKey::EncryptionWithColumnKey(EncryptionWithColumnKey&& other213) noexcept {
  path_in_schema = std::move(other213.path_in_schema);
  key_metadata = std::move(other213.key_metadata);
  __isset = other213.__isset;
}
EncryptionWithColumnKey& EncryptionWithColumnKey::operator=(const EncryptionWithColumnKey& other214) {
  path_in_schema = other214.path_in_schema;
  key_metadata = other214.key_metadata;
  __isset = other214.__isset;
  return *this;
}
EncryptionWithColumnKey& EncryptionWithColumnKey::operator=(EncryptionWithColumnKey&& other215) noexcept {
  path_in_schema = std::move(other215.path_in_schema);
  key_metadata = std::move(other215.key_metadata);
  __isset = other215.__isset;
  return *this;
}
void EncryptionWithColumnKey::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "EncryptionWithColumnKey(";
  out << "path_in_schema=" << to_string(path_in_schema);
  out << ", " << "key_metadata="; (__isset.key_metadata ? (out << to_string(key_metadata)) : (out << "<null>"));
  out << ")";
}


ColumnCryptoMetaData::~ColumnCryptoMetaData() noexcept {
}


void ColumnCryptoMetaData::__set_ENCRYPTION_WITH_FOOTER_KEY(const EncryptionWithFooterKey& val) {
  this->ENCRYPTION_WITH_FOOTER_KEY = val;
__isset.ENCRYPTION_WITH_FOOTER_KEY = true;
}

void ColumnCryptoMetaData::__set_ENCRYPTION_WITH_COLUMN_KEY(const EncryptionWithColumnKey& val) {
  this->ENCRYPTION_WITH_COLUMN_KEY = val;
__isset.ENCRYPTION_WITH_COLUMN_KEY = true;
}
std::ostream& operator<<(std::ostream& out, const ColumnCryptoMetaData& obj)
{
  obj.printTo(out);
  return out;
}


void swap(ColumnCryptoMetaData &a, ColumnCryptoMetaData &b) {
  using ::std::swap;
  swap(a.ENCRYPTION_WITH_FOOTER_KEY, b.ENCRYPTION_WITH_FOOTER_KEY);
  swap(a.ENCRYPTION_WITH_COLUMN_KEY, b.ENCRYPTION_WITH_COLUMN_KEY);
  swap(a.__isset, b.__isset);
}

ColumnCryptoMetaData::ColumnCryptoMetaData(const ColumnCryptoMetaData& other216) {
  ENCRYPTION_WITH_FOOTER_KEY = other216.ENCRYPTION_WITH_FOOTER_KEY;
  ENCRYPTION_WITH_COLUMN_KEY = other216.ENCRYPTION_WITH_COLUMN_KEY;
  __isset = other216.__isset;
}
ColumnCryptoMetaData::ColumnCryptoMetaData(ColumnCryptoMetaData&& other217) noexcept {
  ENCRYPTION_WITH_FOOTER_KEY = std::move(other217.ENCRYPTION_WITH_FOOTER_KEY);
  ENCRYPTION_WITH_COLUMN_KEY = std::move(other217.ENCRYPTION_WITH_COLUMN_KEY);
  __isset = other217.__isset;
}
ColumnCryptoMetaData& ColumnCryptoMetaData::operator=(const ColumnCryptoMetaData& other218) {
  ENCRYPTION_WITH_FOOTER_KEY = other218.ENCRYPTION_WITH_FOOTER_KEY;
  ENCRYPTION_WITH_COLUMN_KEY = other218.ENCRYPTION_WITH_COLUMN_KEY;
  __isset = other218.__isset;
  return *this;
}
ColumnCryptoMetaData& ColumnCryptoMetaData::operator=(ColumnCryptoMetaData&& other219) noexcept {
  ENCRYPTION_WITH_FOOTER_KEY = std::move(other219.ENCRYPTION_WITH_FOOTER_KEY);
  ENCRYPTION_WITH_COLUMN_KEY = std::move(other219.ENCRYPTION_WITH_COLUMN_KEY);
  __isset = other219.__isset;
  return *this;
}
void ColumnCryptoMetaData::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ColumnCryptoMetaData(";
  out << "ENCRYPTION_WITH_FOOTER_KEY="; (__isset.ENCRYPTION_WITH_FOOTER_KEY ? (out << to_string(ENCRYPTION_WITH_FOOTER_KEY)) : (out << "<null>"));
  out << ", " << "ENCRYPTION_WITH_COLUMN_KEY="; (__isset.ENCRYPTION_WITH_COLUMN_KEY ? (out << to_string(ENCRYPTION_WITH_COLUMN_KEY)) : (out << "<null>"));
  out << ")";
}


ColumnChunk::~ColumnChunk() noexcept {
}


void ColumnChunk::__set_file_path(const std::string& val) {
  this->file_path = val;
__isset.file_path = true;
}

void ColumnChunk::__set_file_offset(const int64_t val) {
  this->file_offset = val;
}

void ColumnChunk::__set_meta_data(const ColumnMetaData& val) {
  this->meta_data = val;
__isset.meta_data = true;
}

void ColumnChunk::__set_offset_index_offset(const int64_t val) {
  this->offset_index_offset = val;
__isset.offset_index_offset = true;
}

void ColumnChunk::__set_offset_index_length(const int32_t val) {
  this->offset_index_length = val;
__isset.offset_index_length = true;
}

void ColumnChunk::__set_column_index_offset(const int64_t val) {
  this->column_index_offset = val;
__isset.column_index_offset = true;
}

void ColumnChunk::__set_column_index_length(const int32_t val) {
  this->column_index_length = val;
__isset.column_index_length = true;
}

void ColumnChunk::__set_crypto_metadata(const ColumnCryptoMetaData& val) {
  this->crypto_metadata = val;
__isset.crypto_metadata = true;
}

void ColumnChunk::__set_encrypted_column_metadata(const std::string& val) {
  this->encrypted_column_metadata = val;
__isset.encrypted_column_metadata = true;
}
std::ostream& operator<<(std::ostream& out, const ColumnChunk& obj)
{
  obj.printTo(out);
  return out;
}


void swap(ColumnChunk &a, ColumnChunk &b) {
  using ::std::swap;
  swap(a.file_path, b.file_path);
  swap(a.file_offset, b.file_offset);
  swap(a.meta_data, b.meta_data);
  swap(a.offset_index_offset, b.offset_index_offset);
  swap(a.offset_index_length, b.offset_index_length);
  swap(a.column_index_offset, b.column_index_offset);
  swap(a.column_index_length, b.column_index_length);
  swap(a.crypto_metadata, b.crypto_metadata);
  swap(a.encrypted_column_metadata, b.encrypted_column_metadata);
  swap(a.__isset, b.__isset);
}

ColumnChunk::ColumnChunk(const ColumnChunk& other220) {
  file_path = other220.file_path;
  file_offset = other220.file_offset;
  meta_data = other220.meta_data;
  offset_index_offset = other220.offset_index_offset;
  offset_index_length = other220.offset_index_length;
  column_index_offset = other220.column_index_offset;
  column_index_length = other220.column_index_length;
  crypto_metadata = other220.crypto_metadata;
  encrypted_column_metadata = other220.encrypted_column_metadata;
  __isset = other220.__isset;
}
ColumnChunk::ColumnChunk(ColumnChunk&& other221) noexcept {
  file_path = std::move(other221.file_path);
  file_offset = other221.file_offset;
  meta_data = std::move(other221.meta_data);
  offset_index_offset = other221.offset_index_offset;
  offset_index_length = other221.offset_index_length;
  column_index_offset = other221.column_index_offset;
  column_index_length = other221.column_index_length;
  crypto_metadata = std::move(other221.crypto_metadata);
  encrypted_column_metadata = std::move(other221.encrypted_column_metadata);
  __isset = other221.__isset;
}
ColumnChunk& ColumnChunk::operator=(const ColumnChunk& other222) {
  file_path = other222.file_path;
  file_offset = other222.file_offset;
  meta_data = other222.meta_data;
  offset_index_offset = other222.offset_index_offset;
  offset_index_length = other222.offset_index_length;
  column_index_offset = other222.column_index_offset;
  column_index_length = other222.column_index_length;
  crypto_metadata = other222.crypto_metadata;
  encrypted_column_metadata = other222.encrypted_column_metadata;
  __isset = other222.__isset;
  return *this;
}
ColumnChunk& ColumnChunk::operator=(ColumnChunk&& other223) noexcept {
  file_path = std::move(other223.file_path);
  file_offset = other223.file_offset;
  meta_data = std::move(other223.meta_data);
  offset_index_offset = other223.offset_index_offset;
  offset_index_length = other223.offset_index_length;
  column_index_offset = other223.column_index_offset;
  column_index_length = other223.column_index_length;
  crypto_metadata = std::move(other223.crypto_metadata);
  encrypted_column_metadata = std::move(other223.encrypted_column_metadata);
  __isset = other223.__isset;
  return *this;
}
void ColumnChunk::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ColumnChunk(";
  out << "file_path="; (__isset.file_path ? (out << to_string(file_path)) : (out << "<null>"));
  out << ", " << "file_offset=" << to_string(file_offset);
  out << ", " << "meta_data="; (__isset.meta_data ? (out << to_string(meta_data)) : (out << "<null>"));
  out << ", " << "offset_index_offset="; (__isset.offset_index_offset ? (out << to_string(offset_index_offset)) : (out << "<null>"));
  out << ", " << "offset_index_length="; (__isset.offset_index_length ? (out << to_string(offset_index_length)) : (out << "<null>"));
  out << ", " << "column_index_offset="; (__isset.column_index_offset ? (out << to_string(column_index_offset)) : (out << "<null>"));
  out << ", " << "column_index_length="; (__isset.column_index_length ? (out << to_string(column_index_length)) : (out << "<null>"));
  out << ", " << "crypto_metadata="; (__isset.crypto_metadata ? (out << to_string(crypto_metadata)) : (out << "<null>"));
  out << ", " << "encrypted_column_metadata="; (__isset.encrypted_column_metadata ? (out << to_string(encrypted_column_metadata)) : (out << "<null>"));
  out << ")";
}


RowGroup::~RowGroup() noexcept {
}


void RowGroup::__set_columns(const std::vector<ColumnChunk> & val) {
  this->columns = val;
}

void RowGroup::__set_total_byte_size(const int64_t val) {
  this->total_byte_size = val;
}

void RowGroup::__set_num_rows(const int64_t val) {
  this->num_rows = val;
}

void RowGroup::__set_sorting_columns(const std::vector<SortingColumn> & val) {
  this->sorting_columns = val;
__isset.sorting_columns = true;
}

void RowGroup::__set_file_offset(const int64_t val) {
  this->file_offset = val;
__isset.file_offset = true;
}

void RowGroup::__set_total_compressed_size(const int64_t val) {
  this->total_compressed_size = val;
__isset.total_compressed_size = true;
}

void RowGroup::__set_ordinal(const int16_t val) {
  this->ordinal = val;
__isset.ordinal = true;
}
std::ostream& operator<<(std::ostream& out, const RowGroup& obj)
{
  obj.printTo(out);
  return out;
}


void swap(RowGroup &a, RowGroup &b) {
  using ::std::swap;
  swap(a.columns, b.columns);
  swap(a.total_byte_size, b.total_byte_size);
  swap(a.num_rows, b.num_rows);
  swap(a.sorting_columns, b.sorting_columns);
  swap(a.file_offset, b.file_offset);
  swap(a.total_compressed_size, b.total_compressed_size);
  swap(a.ordinal, b.ordinal);
  swap(a.__isset, b.__isset);
}

RowGroup::RowGroup(const RowGroup& other236) {
  columns = other236.columns;
  total_byte_size = other236.total_byte_size;
  num_rows = other236.num_rows;
  sorting_columns = other236.sorting_columns;
  file_offset = other236.file_offset;
  total_compressed_size = other236.total_compressed_size;
  ordinal = other236.ordinal;
  __isset = other236.__isset;
}
RowGroup::RowGroup(RowGroup&& other237) noexcept {
  columns = std::move(other237.columns);
  total_byte_size = other237.total_byte_size;
  num_rows = other237.num_rows;
  sorting_columns = std::move(other237.sorting_columns);
  file_offset = other237.file_offset;
  total_compressed_size = other237.total_compressed_size;
  ordinal = other237.ordinal;
  __isset = other237.__isset;
}
RowGroup& RowGroup::operator=(const RowGroup& other238) {
  columns = other238.columns;
  total_byte_size = other238.total_byte_size;
  num_rows = other238.num_rows;
  sorting_columns = other238.sorting_columns;
  file_offset = other238.file_offset;
  total_compressed_size = other238.total_compressed_size;
  ordinal = other238.ordinal;
  __isset = other238.__isset;
  return *this;
}
RowGroup& RowGroup::operator=(RowGroup&& other239) noexcept {
  columns = std::move(other239.columns);
  total_byte_size = other239.total_byte_size;
  num_rows = other239.num_rows;
  sorting_columns = std::move(other239.sorting_columns);
  file_offset = other239.file_offset;
  total_compressed_size = other239.total_compressed_size;
  ordinal = other239.ordinal;
  __isset = other239.__isset;
  return *this;
}
void RowGroup::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "RowGroup(";
  out << "columns=" << to_string(columns);
  out << ", " << "total_byte_size=" << to_string(total_byte_size);
  out << ", " << "num_rows=" << to_string(num_rows);
  out << ", " << "sorting_columns="; (__isset.sorting_columns ? (out << to_string(sorting_columns)) : (out << "<null>"));
  out << ", " << "file_offset="; (__isset.file_offset ? (out << to_string(file_offset)) : (out << "<null>"));
  out << ", " << "total_compressed_size="; (__isset.total_compressed_size ? (out << to_string(total_compressed_size)) : (out << "<null>"));
  out << ", " << "ordinal="; (__isset.ordinal ? (out << to_string(ordinal)) : (out << "<null>"));
  out << ")";
}


TypeDefinedOrder::~TypeDefinedOrder() noexcept {
}

std::ostream& operator<<(std::ostream& out, const TypeDefinedOrder& obj)
{
  obj.printTo(out);
  return out;
}


void swap(TypeDefinedOrder &a, TypeDefinedOrder &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

TypeDefinedOrder::TypeDefinedOrder(const TypeDefinedOrder& other240) noexcept {
  (void) other240;
}
TypeDefinedOrder::TypeDefinedOrder(TypeDefinedOrder&& other241) noexcept {
  (void) other241;
}
TypeDefinedOrder& TypeDefinedOrder::operator=(const TypeDefinedOrder& other242) noexcept {
  (void) other242;
  return *this;
}
TypeDefinedOrder& TypeDefinedOrder::operator=(TypeDefinedOrder&& other243) noexcept {
  (void) other243;
  return *this;
}
void TypeDefinedOrder::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "TypeDefinedOrder(";
  out << ")";
}


ColumnOrder::~ColumnOrder() noexcept {
}


void ColumnOrder::__set_TYPE_ORDER(const TypeDefinedOrder& val) {
  this->TYPE_ORDER = val;
__isset.TYPE_ORDER = true;
}
std::ostream& operator<<(std::ostream& out, const ColumnOrder& obj)
{
  obj.printTo(out);
  return out;
}


void swap(ColumnOrder &a, ColumnOrder &b) {
  using ::std::swap;
  swap(a.TYPE_ORDER, b.TYPE_ORDER);
  swap(a.__isset, b.__isset);
}

ColumnOrder::ColumnOrder(const ColumnOrder& other244) noexcept {
  TYPE_ORDER = other244.TYPE_ORDER;
  __isset = other244.__isset;
}
ColumnOrder::ColumnOrder(ColumnOrder&& other245) noexcept {
  TYPE_ORDER = std::move(other245.TYPE_ORDER);
  __isset = other245.__isset;
}
ColumnOrder& ColumnOrder::operator=(const ColumnOrder& other246) noexcept {
  TYPE_ORDER = other246.TYPE_ORDER;
  __isset = other246.__isset;
  return *this;
}
ColumnOrder& ColumnOrder::operator=(ColumnOrder&& other247) noexcept {
  TYPE_ORDER = std::move(other247.TYPE_ORDER);
  __isset = other247.__isset;
  return *this;
}
void ColumnOrder::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ColumnOrder(";
  out << "TYPE_ORDER="; (__isset.TYPE_ORDER ? (out << to_string(TYPE_ORDER)) : (out << "<null>"));
  out << ")";
}


PageLocation::~PageLocation() noexcept {
}


void PageLocation::__set_offset(const int64_t val) {
  this->offset = val;
}

void PageLocation::__set_compressed_page_size(const int32_t val) {
  this->compressed_page_size = val;
}

void PageLocation::__set_first_row_index(const int64_t val) {
  this->first_row_index = val;
}
std::ostream& operator<<(std::ostream& out, const PageLocation& obj)
{
  obj.printTo(out);
  return out;
}


void swap(PageLocation &a, PageLocation &b) {
  using ::std::swap;
  swap(a.offset, b.offset);
  swap(a.compressed_page_size, b.compressed_page_size);
  swap(a.first_row_index, b.first_row_index);
}

PageLocation::PageLocation(const PageLocation& other248) noexcept {
  offset = other248.offset;
  compressed_page_size = other248.compressed_page_size;
  first_row_index = other248.first_row_index;
}
PageLocation::PageLocation(PageLocation&& other249) noexcept {
  offset = other249.offset;
  compressed_page_size = other249.compressed_page_size;
  first_row_index = other249.first_row_index;
}
PageLocation& PageLocation::operator=(const PageLocation& other250) noexcept {
  offset = other250.offset;
  compressed_page_size = other250.compressed_page_size;
  first_row_index = other250.first_row_index;
  return *this;
}
PageLocation& PageLocation::operator=(PageLocation&& other251) noexcept {
  offset = other251.offset;
  compressed_page_size = other251.compressed_page_size;
  first_row_index = other251.first_row_index;
  return *this;
}
void PageLocation::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "PageLocation(";
  out << "offset=" << to_string(offset);
  out << ", " << "compressed_page_size=" << to_string(compressed_page_size);
  out << ", " << "first_row_index=" << to_string(first_row_index);
  out << ")";
}


OffsetIndex::~OffsetIndex() noexcept {
}


void OffsetIndex::__set_page_locations(const std::vector<PageLocation> & val) {
  this->page_locations = val;
}

void OffsetIndex::__set_unencoded_byte_array_data_bytes(const std::vector<int64_t> & val) {
  this->unencoded_byte_array_data_bytes = val;
__isset.unencoded_byte_array_data_bytes = true;
}
std::ostream& operator<<(std::ostream& out, const OffsetIndex& obj)
{
  obj.printTo(out);
  return out;
}


void swap(OffsetIndex &a, OffsetIndex &b) {
  using ::std::swap;
  swap(a.page_locations, b.page_locations);
  swap(a.unencoded_byte_array_data_bytes, b.unencoded_byte_array_data_bytes);
  swap(a.__isset, b.__isset);
}

OffsetIndex::OffsetIndex(const OffsetIndex& other264) {
  page_locations = other264.page_locations;
  unencoded_byte_array_data_bytes = other264.unencoded_byte_array_data_bytes;
  __isset = other264.__isset;
}
OffsetIndex::OffsetIndex(OffsetIndex&& other265) noexcept {
  page_locations = std::move(other265.page_locations);
  unencoded_byte_array_data_bytes = std::move(other265.unencoded_byte_array_data_bytes);
  __isset = other265.__isset;
}
OffsetIndex& OffsetIndex::operator=(const OffsetIndex& other266) {
  page_locations = other266.page_locations;
  unencoded_byte_array_data_bytes = other266.unencoded_byte_array_data_bytes;
  __isset = other266.__isset;
  return *this;
}
OffsetIndex& OffsetIndex::operator=(OffsetIndex&& other267) noexcept {
  page_locations = std::move(other267.page_locations);
  unencoded_byte_array_data_bytes = std::move(other267.unencoded_byte_array_data_bytes);
  __isset = other267.__isset;
  return *this;
}
void OffsetIndex::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "OffsetIndex(";
  out << "page_locations=" << to_string(page_locations);
  out << ", " << "unencoded_byte_array_data_bytes="; (__isset.unencoded_byte_array_data_bytes ? (out << to_string(unencoded_byte_array_data_bytes)) : (out << "<null>"));
  out << ")";
}


ColumnIndex::~ColumnIndex() noexcept {
}


void ColumnIndex::__set_null_pages(const std::vector<bool> & val) {
  this->null_pages = val;
}

void ColumnIndex::__set_min_values(const std::vector<std::string> & val) {
  this->min_values = val;
}

void ColumnIndex::__set_max_values(const std::vector<std::string> & val) {
  this->max_values = val;
}

void ColumnIndex::__set_boundary_order(const BoundaryOrder::type val) {
  this->boundary_order = val;
}

void ColumnIndex::__set_null_counts(const std::vector<int64_t> & val) {
  this->null_counts = val;
__isset.null_counts = true;
}

void ColumnIndex::__set_repetition_level_histograms(const std::vector<int64_t> & val) {
  this->repetition_level_histograms = val;
__isset.repetition_level_histograms = true;
}

void ColumnIndex::__set_definition_level_histograms(const std::vector<int64_t> & val) {
  this->definition_level_histograms = val;
__isset.definition_level_histograms = true;
}
std::ostream& operator<<(std::ostream& out, const ColumnIndex& obj)
{
  obj.printTo(out);
  return out;
}


void swap(ColumnIndex &a, ColumnIndex &b) {
  using ::std::swap;
  swap(a.null_pages, b.null_pages);
  swap(a.min_values, b.min_values);
  swap(a.max_values, b.max_values);
  swap(a.boundary_order, b.boundary_order);
  swap(a.null_counts, b.null_counts);
  swap(a.repetition_level_histograms, b.repetition_level_histograms);
  swap(a.definition_level_histograms, b.definition_level_histograms);
  swap(a.__isset, b.__isset);
}

ColumnIndex::ColumnIndex(const ColumnIndex& other305) {
  null_pages = other305.null_pages;
  min_values = other305.min_values;
  max_values = other305.max_values;
  boundary_order = other305.boundary_order;
  null_counts = other305.null_counts;
  repetition_level_histograms = other305.repetition_level_histograms;
  definition_level_histograms = other305.definition_level_histograms;
  __isset = other305.__isset;
}
ColumnIndex::ColumnIndex(ColumnIndex&& other306) noexcept {
  null_pages = std::move(other306.null_pages);
  min_values = std::move(other306.min_values);
  max_values = std::move(other306.max_values);
  boundary_order = other306.boundary_order;
  null_counts = std::move(other306.null_counts);
  repetition_level_histograms = std::move(other306.repetition_level_histograms);
  definition_level_histograms = std::move(other306.definition_level_histograms);
  __isset = other306.__isset;
}
ColumnIndex& ColumnIndex::operator=(const ColumnIndex& other307) {
  null_pages = other307.null_pages;
  min_values = other307.min_values;
  max_values = other307.max_values;
  boundary_order = other307.boundary_order;
  null_counts = other307.null_counts;
  repetition_level_histograms = other307.repetition_level_histograms;
  definition_level_histograms = other307.definition_level_histograms;
  __isset = other307.__isset;
  return *this;
}
ColumnIndex& ColumnIndex::operator=(ColumnIndex&& other308) noexcept {
  null_pages = std::move(other308.null_pages);
  min_values = std::move(other308.min_values);
  max_values = std::move(other308.max_values);
  boundary_order = other308.boundary_order;
  null_counts = std::move(other308.null_counts);
  repetition_level_histograms = std::move(other308.repetition_level_histograms);
  definition_level_histograms = std::move(other308.definition_level_histograms);
  __isset = other308.__isset;
  return *this;
}
void ColumnIndex::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ColumnIndex(";
  out << "null_pages=" << to_string(null_pages);
  out << ", " << "min_values=" << to_string(min_values);
  out << ", " << "max_values=" << to_string(max_values);
  out << ", " << "boundary_order=" << to_string(boundary_order);
  out << ", " << "null_counts="; (__isset.null_counts ? (out << to_string(null_counts)) : (out << "<null>"));
  out << ", " << "repetition_level_histograms="; (__isset.repetition_level_histograms ? (out << to_string(repetition_level_histograms)) : (out << "<null>"));
  out << ", " << "definition_level_histograms="; (__isset.definition_level_histograms ? (out << to_string(definition_level_histograms)) : (out << "<null>"));
  out << ")";
}


AesGcmV1::~AesGcmV1() noexcept {
}


void AesGcmV1::__set_aad_prefix(const std::string& val) {
  this->aad_prefix = val;
__isset.aad_prefix = true;
}

void AesGcmV1::__set_aad_file_unique(const std::string& val) {
  this->aad_file_unique = val;
__isset.aad_file_unique = true;
}

void AesGcmV1::__set_supply_aad_prefix(const bool val) {
  this->supply_aad_prefix = val;
__isset.supply_aad_prefix = true;
}
std::ostream& operator<<(std::ostream& out, const AesGcmV1& obj)
{
  obj.printTo(out);
  return out;
}


void swap(AesGcmV1 &a, AesGcmV1 &b) {
  using ::std::swap;
  swap(a.aad_prefix, b.aad_prefix);
  swap(a.aad_file_unique, b.aad_file_unique);
  swap(a.supply_aad_prefix, b.supply_aad_prefix);
  swap(a.__isset, b.__isset);
}

AesGcmV1::AesGcmV1(const AesGcmV1& other309) {
  aad_prefix = other309.aad_prefix;
  aad_file_unique = other309.aad_file_unique;
  supply_aad_prefix = other309.supply_aad_prefix;
  __isset = other309.__isset;
}
AesGcmV1::AesGcmV1(AesGcmV1&& other310) noexcept {
  aad_prefix = std::move(other310.aad_prefix);
  aad_file_unique = std::move(other310.aad_file_unique);
  supply_aad_prefix = other310.supply_aad_prefix;
  __isset = other310.__isset;
}
AesGcmV1& AesGcmV1::operator=(const AesGcmV1& other311) {
  aad_prefix = other311.aad_prefix;
  aad_file_unique = other311.aad_file_unique;
  supply_aad_prefix = other311.supply_aad_prefix;
  __isset = other311.__isset;
  return *this;
}
AesGcmV1& AesGcmV1::operator=(AesGcmV1&& other312) noexcept {
  aad_prefix = std::move(other312.aad_prefix);
  aad_file_unique = std::move(other312.aad_file_unique);
  supply_aad_prefix = other312.supply_aad_prefix;
  __isset = other312.__isset;
  return *this;
}
void AesGcmV1::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "AesGcmV1(";
  out << "aad_prefix="; (__isset.aad_prefix ? (out << to_string(aad_prefix)) : (out << "<null>"));
  out << ", " << "aad_file_unique="; (__isset.aad_file_unique ? (out << to_string(aad_file_unique)) : (out << "<null>"));
  out << ", " << "supply_aad_prefix="; (__isset.supply_aad_prefix ? (out << to_string(supply_aad_prefix)) : (out << "<null>"));
  out << ")";
}


AesGcmCtrV1::~AesGcmCtrV1() noexcept {
}


void AesGcmCtrV1::__set_aad_prefix(const std::string& val) {
  this->aad_prefix = val;
__isset.aad_prefix = true;
}

void AesGcmCtrV1::__set_aad_file_unique(const std::string& val) {
  this->aad_file_unique = val;
__isset.aad_file_unique = true;
}

void AesGcmCtrV1::__set_supply_aad_prefix(const bool val) {
  this->supply_aad_prefix = val;
__isset.supply_aad_prefix = true;
}
std::ostream& operator<<(std::ostream& out, const AesGcmCtrV1& obj)
{
  obj.printTo(out);
  return out;
}


void swap(AesGcmCtrV1 &a, AesGcmCtrV1 &b) {
  using ::std::swap;
  swap(a.aad_prefix, b.aad_prefix);
  swap(a.aad_file_unique, b.aad_file_unique);
  swap(a.supply_aad_prefix, b.supply_aad_prefix);
  swap(a.__isset, b.__isset);
}

AesGcmCtrV1::AesGcmCtrV1(const AesGcmCtrV1& other313) {
  aad_prefix = other313.aad_prefix;
  aad_file_unique = other313.aad_file_unique;
  supply_aad_prefix = other313.supply_aad_prefix;
  __isset = other313.__isset;
}
AesGcmCtrV1::AesGcmCtrV1(AesGcmCtrV1&& other314) noexcept {
  aad_prefix = std::move(other314.aad_prefix);
  aad_file_unique = std::move(other314.aad_file_unique);
  supply_aad_prefix = other314.supply_aad_prefix;
  __isset = other314.__isset;
}
AesGcmCtrV1& AesGcmCtrV1::operator=(const AesGcmCtrV1& other315) {
  aad_prefix = other315.aad_prefix;
  aad_file_unique = other315.aad_file_unique;
  supply_aad_prefix = other315.supply_aad_prefix;
  __isset = other315.__isset;
  return *this;
}
AesGcmCtrV1& AesGcmCtrV1::operator=(AesGcmCtrV1&& other316) noexcept {
  aad_prefix = std::move(other316.aad_prefix);
  aad_file_unique = std::move(other316.aad_file_unique);
  supply_aad_prefix = other316.supply_aad_prefix;
  __isset = other316.__isset;
  return *this;
}
void AesGcmCtrV1::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "AesGcmCtrV1(";
  out << "aad_prefix="; (__isset.aad_prefix ? (out << to_string(aad_prefix)) : (out << "<null>"));
  out << ", " << "aad_file_unique="; (__isset.aad_file_unique ? (out << to_string(aad_file_unique)) : (out << "<null>"));
  out << ", " << "supply_aad_prefix="; (__isset.supply_aad_prefix ? (out << to_string(supply_aad_prefix)) : (out << "<null>"));
  out << ")";
}


EncryptionAlgorithm::~EncryptionAlgorithm() noexcept {
}


void EncryptionAlgorithm::__set_AES_GCM_V1(const AesGcmV1& val) {
  this->AES_GCM_V1 = val;
__isset.AES_GCM_V1 = true;
}

void EncryptionAlgorithm::__set_AES_GCM_CTR_V1(const AesGcmCtrV1& val) {
  this->AES_GCM_CTR_V1 = val;
__isset.AES_GCM_CTR_V1 = true;
}
std::ostream& operator<<(std::ostream& out, const EncryptionAlgorithm& obj)
{
  obj.printTo(out);
  return out;
}


void swap(EncryptionAlgorithm &a, EncryptionAlgorithm &b) {
  using ::std::swap;
  swap(a.AES_GCM_V1, b.AES_GCM_V1);
  swap(a.AES_GCM_CTR_V1, b.AES_GCM_CTR_V1);
  swap(a.__isset, b.__isset);
}

EncryptionAlgorithm::EncryptionAlgorithm(const EncryptionAlgorithm& other317) {
  AES_GCM_V1 = other317.AES_GCM_V1;
  AES_GCM_CTR_V1 = other317.AES_GCM_CTR_V1;
  __isset = other317.__isset;
}
EncryptionAlgorithm::EncryptionAlgorithm(EncryptionAlgorithm&& other318) noexcept {
  AES_GCM_V1 = std::move(other318.AES_GCM_V1);
  AES_GCM_CTR_V1 = std::move(other318.AES_GCM_CTR_V1);
  __isset = other318.__isset;
}
EncryptionAlgorithm& EncryptionAlgorithm::operator=(const EncryptionAlgorithm& other319) {
  AES_GCM_V1 = other319.AES_GCM_V1;
  AES_GCM_CTR_V1 = other319.AES_GCM_CTR_V1;
  __isset = other319.__isset;
  return *this;
}
EncryptionAlgorithm& EncryptionAlgorithm::operator=(EncryptionAlgorithm&& other320) noexcept {
  AES_GCM_V1 = std::move(other320.AES_GCM_V1);
  AES_GCM_CTR_V1 = std::move(other320.AES_GCM_CTR_V1);
  __isset = other320.__isset;
  return *this;
}
void EncryptionAlgorithm::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "EncryptionAlgorithm(";
  out << "AES_GCM_V1="; (__isset.AES_GCM_V1 ? (out << to_string(AES_GCM_V1)) : (out << "<null>"));
  out << ", " << "AES_GCM_CTR_V1="; (__isset.AES_GCM_CTR_V1 ? (out << to_string(AES_GCM_CTR_V1)) : (out << "<null>"));
  out << ")";
}


FileMetaData::~FileMetaData() noexcept {
}


void FileMetaData::__set_version(const int32_t val) {
  this->version = val;
}

void FileMetaData::__set_schema(const std::vector<SchemaElement> & val) {
  this->schema = val;
}

void FileMetaData::__set_num_rows(const int64_t val) {
  this->num_rows = val;
}

void FileMetaData::__set_row_groups(const std::vector<RowGroup> & val) {
  this->row_groups = val;
}

void FileMetaData::__set_key_value_metadata(const std::vector<KeyValue> & val) {
  this->key_value_metadata = val;
__isset.key_value_metadata = true;
}

void FileMetaData::__set_created_by(const std::string& val) {
  this->created_by = val;
__isset.created_by = true;
}

void FileMetaData::__set_column_orders(const std::vector<ColumnOrder> & val) {
  this->column_orders = val;
__isset.column_orders = true;
}

void FileMetaData::__set_encryption_algorithm(const EncryptionAlgorithm& val) {
  this->encryption_algorithm = val;
__isset.encryption_algorithm = true;
}

void FileMetaData::__set_footer_signing_key_metadata(const std::string& val) {
  this->footer_signing_key_metadata = val;
__isset.footer_signing_key_metadata = true;
}
std::ostream& operator<<(std::ostream& out, const FileMetaData& obj)
{
  obj.printTo(out);
  return out;
}


void swap(FileMetaData &a, FileMetaData &b) {
  using ::std::swap;
  swap(a.version, b.version);
  swap(a.schema, b.schema);
  swap(a.num_rows, b.num_rows);
  swap(a.row_groups, b.row_groups);
  swap(a.key_value_metadata, b.key_value_metadata);
  swap(a.created_by, b.created_by);
  swap(a.column_orders, b.column_orders);
  swap(a.encryption_algorithm, b.encryption_algorithm);
  swap(a.footer_signing_key_metadata, b.footer_signing_key_metadata);
  swap(a.__isset, b.__isset);
}

FileMetaData::FileMetaData(const FileMetaData& other345) {
  version = other345.version;
  schema = other345.schema;
  num_rows = other345.num_rows;
  row_groups = other345.row_groups;
  key_value_metadata = other345.key_value_metadata;
  created_by = other345.created_by;
  column_orders = other345.column_orders;
  encryption_algorithm = other345.encryption_algorithm;
  footer_signing_key_metadata = other345.footer_signing_key_metadata;
  __isset = other345.__isset;
}
FileMetaData::FileMetaData(FileMetaData&& other346) noexcept {
  version = other346.version;
  schema = std::move(other346.schema);
  num_rows = other346.num_rows;
  row_groups = std::move(other346.row_groups);
  key_value_metadata = std::move(other346.key_value_metadata);
  created_by = std::move(other346.created_by);
  column_orders = std::move(other346.column_orders);
  encryption_algorithm = std::move(other346.encryption_algorithm);
  footer_signing_key_metadata = std::move(other346.footer_signing_key_metadata);
  __isset = other346.__isset;
}
FileMetaData& FileMetaData::operator=(const FileMetaData& other347) {
  version = other347.version;
  schema = other347.schema;
  num_rows = other347.num_rows;
  row_groups = other347.row_groups;
  key_value_metadata = other347.key_value_metadata;
  created_by = other347.created_by;
  column_orders = other347.column_orders;
  encryption_algorithm = other347.encryption_algorithm;
  footer_signing_key_metadata = other347.footer_signing_key_metadata;
  __isset = other347.__isset;
  return *this;
}
FileMetaData& FileMetaData::operator=(FileMetaData&& other348) noexcept {
  version = other348.version;
  schema = std::move(other348.schema);
  num_rows = other348.num_rows;
  row_groups = std::move(other348.row_groups);
  key_value_metadata = std::move(other348.key_value_metadata);
  created_by = std::move(other348.created_by);
  column_orders = std::move(other348.column_orders);
  encryption_algorithm = std::move(other348.encryption_algorithm);
  footer_signing_key_metadata = std::move(other348.footer_signing_key_metadata);
  __isset = other348.__isset;
  return *this;
}
void FileMetaData::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "FileMetaData(";
  out << "version=" << to_string(version);
  out << ", " << "schema=" << to_string(schema);
  out << ", " << "num_rows=" << to_string(num_rows);
  out << ", " << "row_groups=" << to_string(row_groups);
  out << ", " << "key_value_metadata="; (__isset.key_value_metadata ? (out << to_string(key_value_metadata)) : (out << "<null>"));
  out << ", " << "created_by="; (__isset.created_by ? (out << to_string(created_by)) : (out << "<null>"));
  out << ", " << "column_orders="; (__isset.column_orders ? (out << to_string(column_orders)) : (out << "<null>"));
  out << ", " << "encryption_algorithm="; (__isset.encryption_algorithm ? (out << to_string(encryption_algorithm)) : (out << "<null>"));
  out << ", " << "footer_signing_key_metadata="; (__isset.footer_signing_key_metadata ? (out << to_string(footer_signing_key_metadata)) : (out << "<null>"));
  out << ")";
}


FileCryptoMetaData::~FileCryptoMetaData() noexcept {
}


void FileCryptoMetaData::__set_encryption_algorithm(const EncryptionAlgorithm& val) {
  this->encryption_algorithm = val;
}

void FileCryptoMetaData::__set_key_metadata(const std::string& val) {
  this->key_metadata = val;
__isset.key_metadata = true;
}
std::ostream& operator<<(std::ostream& out, const FileCryptoMetaData& obj)
{
  obj.printTo(out);
  return out;
}


void swap(FileCryptoMetaData &a, FileCryptoMetaData &b) {
  using ::std::swap;
  swap(a.encryption_algorithm, b.encryption_algorithm);
  swap(a.key_metadata, b.key_metadata);
  swap(a.__isset, b.__isset);
}

FileCryptoMetaData::FileCryptoMetaData(const FileCryptoMetaData& other349) {
  encryption_algorithm = other349.encryption_algorithm;
  key_metadata = other349.key_metadata;
  __isset = other349.__isset;
}
FileCryptoMetaData::FileCryptoMetaData(FileCryptoMetaData&& other350) noexcept {
  encryption_algorithm = std::move(other350.encryption_algorithm);
  key_metadata = std::move(other350.key_metadata);
  __isset = other350.__isset;
}
FileCryptoMetaData& FileCryptoMetaData::operator=(const FileCryptoMetaData& other351) {
  encryption_algorithm = other351.encryption_algorithm;
  key_metadata = other351.key_metadata;
  __isset = other351.__isset;
  return *this;
}
FileCryptoMetaData& FileCryptoMetaData::operator=(FileCryptoMetaData&& other352) noexcept {
  encryption_algorithm = std::move(other352.encryption_algorithm);
  key_metadata = std::move(other352.key_metadata);
  __isset = other352.__isset;
  return *this;
}
void FileCryptoMetaData::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "FileCryptoMetaData(";
  out << "encryption_algorithm=" << to_string(encryption_algorithm);
  out << ", " << "key_metadata="; (__isset.key_metadata ? (out << to_string(key_metadata)) : (out << "<null>"));
  out << ")";
}

}} // namespace
