﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ec2/model/DeleteIpamExternalResourceVerificationTokenRequest.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

using namespace Aws::EC2::Model;
using namespace Aws::Utils;

DeleteIpamExternalResourceVerificationTokenRequest::DeleteIpamExternalResourceVerificationTokenRequest() : 
    m_dryRun(false),
    m_dryRunHasBeenSet(false),
    m_ipamExternalResourceVerificationTokenIdHasBeenSet(false)
{
}

Aws::String DeleteIpamExternalResourceVerificationTokenRequest::SerializePayload() const
{
  Aws::StringStream ss;
  ss << "Action=DeleteIpamExternalResourceVerificationToken&";
  if(m_dryRunHasBeenSet)
  {
    ss << "DryRun=" << std::boolalpha << m_dryRun << "&";
  }

  if(m_ipamExternalResourceVerificationTokenIdHasBeenSet)
  {
    ss << "IpamExternalResourceVerificationTokenId=" << StringUtils::URLEncode(m_ipamExternalResourceVerificationTokenId.c_str()) << "&";
  }

  ss << "Version=2016-11-15";
  return ss.str();
}


void  DeleteIpamExternalResourceVerificationTokenRequest::DumpBodyToUrl(Aws::Http::URI& uri ) const
{
  uri.SetQueryString(SerializePayload());
}
